/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.bootstrap.api.helpers.RegistrySingletonProvider;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.WeldDeployment;
import org.jboss.weld.environment.deployment.WeldResourceLoader;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategyFactory;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.se.ShutdownManager;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.contexts.ThreadScoped;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.metadata.MetadataImpl;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.GetSystemPropertyAction;

@Vetoed
public class Weld {
    public static final String ARCHIVE_ISOLATION_SYSTEM_PROPERTY = "org.jboss.weld.se.archive.isolation";
    private ShutdownManager shutdownManager;
    private Set<Metadata<Extension>> extensions;
    private final String containerId;

    public Weld() {
        this("STATIC_INSTANCE");
    }

    public Weld(String containerId) {
        this.containerId = containerId;
    }

    public void addExtension(Extension extension) {
        if (this.extensions == null) {
            this.extensions = new HashSet<Metadata<Extension>>();
        }
        this.extensions.add(new MetadataImpl<Extension>(extension, "<explicitly-added>"));
    }

    public WeldContainer initialize() {
        WeldResourceLoader resourceLoader = new WeldResourceLoader();
        if (resourceLoader.getResource("META-INF/beans.xml") == null) {
            throw CommonLogger.LOG.missingBeansXml();
        }
        WeldBootstrap bootstrap = new WeldBootstrap();
        Deployment deployment = this.createDeployment(resourceLoader, bootstrap);
        bootstrap.startContainer(this.containerId, Environments.SE, deployment);
        bootstrap.startInitialization();
        bootstrap.deployBeans();
        bootstrap.validateBeans();
        bootstrap.endInitialization();
        WeldManager manager = bootstrap.getManager(deployment.loadBeanDeploymentArchive(WeldContainer.class));
        this.shutdownManager = new ShutdownManager(bootstrap, manager);
        WeldContainer container = this.getInstanceByType(manager, WeldContainer.class, new Annotation[0]);
        container.event().select(ContainerInitialized.class, InitializedLiteral.APPLICATION).fire(new ContainerInitialized());
        return container;
    }

    private Iterable<Metadata<Extension>> loadExtensions(ClassLoader classLoader, Bootstrap bootstrap) {
        Iterable<Metadata<Extension>> iter = bootstrap.loadExtensions(classLoader);
        if (this.extensions != null) {
            HashSet<Metadata<Extension>> set = new HashSet<Metadata<Extension>>(this.extensions);
            for (Metadata<Extension> ext : iter) {
                set.add(ext);
            }
            return set;
        }
        return iter;
    }

    protected Deployment createDeployment(ResourceLoader resourceLoader, CDI11Bootstrap bootstrap) {
        Iterable<Metadata<Extension>> loadedExtensions = this.loadExtensions(WeldResourceLoader.getClassLoader(), bootstrap);
        TypeDiscoveryConfiguration typeDiscoveryConfiguration = bootstrap.startExtensions(loadedExtensions);
        WeldDeployment deployment = null;
        DiscoveryStrategy strategy = DiscoveryStrategyFactory.create(resourceLoader, bootstrap, (Set<Class<? extends Annotation>>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(typeDiscoveryConfiguration.getKnownBeanDefiningAnnotations())).add(ThreadScoped.class)).build()));
        Set<WeldBeanDeploymentArchive> discoveredArchives = strategy.performDiscovery();
        String isolation = AccessController.doPrivileged(new GetSystemPropertyAction(ARCHIVE_ISOLATION_SYSTEM_PROPERTY));
        if (isolation != null && Boolean.valueOf(isolation).equals(Boolean.FALSE)) {
            HashSet<WeldBeanDeploymentArchive> archives = new HashSet<WeldBeanDeploymentArchive>();
            archives.add(WeldBeanDeploymentArchive.merge(bootstrap, discoveredArchives));
            deployment = new WeldDeployment(resourceLoader, bootstrap, archives, loadedExtensions);
            CommonLogger.LOG.archiveIsolationDisabled();
        } else {
            deployment = new WeldDeployment(resourceLoader, bootstrap, discoveredArchives, loadedExtensions);
            CommonLogger.LOG.archiveIsolationEnabled();
        }
        if (strategy.getClassFileServices() != null) {
            deployment.getServices().add(ClassFileServices.class, strategy.getClassFileServices());
        }
        return deployment;
    }

    protected <T> T getInstanceByType(BeanManager manager, Class<T> type, Annotation ... bindings) {
        Bean bean = manager.resolve(manager.getBeans(type, bindings));
        if (bean == null) {
            throw CommonLogger.LOG.unableToResolveBean(type, Arrays.asList(bindings));
        }
        CreationalContext cc = manager.createCreationalContext(bean);
        return type.cast(manager.getReference(bean, type, cc));
    }

    public void shutdown() {
        if (this.shutdownManager != null) {
            this.shutdownManager.shutdown();
        }
    }

    static {
        if (!(SingletonProvider.instance() instanceof RegistrySingletonProvider)) {
            SingletonProvider.reset();
            SingletonProvider.initialize(new RegistrySingletonProvider());
        }
    }
}

