/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.commons.APeriodOfTime;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class PeriodOfTime
extends APeriodOfTime {
    private final String startDate;
    private final String endDate;
    private final String rawString;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final PeriodOfTime INSTANCE = PeriodOfTime.validate(new PeriodOfTime());

    private PeriodOfTime() {
        this.startDate = this.initShim.getStartDate();
        this.endDate = this.initShim.getEndDate();
        this.rawString = this.initShim.getRawString();
        this.initShim = null;
    }

    private PeriodOfTime(String startDate, String endDate, String rawString) {
        this.startDate = (String)Preconditions.checkNotNull((Object)startDate);
        this.endDate = (String)Preconditions.checkNotNull((Object)endDate);
        this.rawString = (String)Preconditions.checkNotNull((Object)rawString);
        this.initShim = null;
    }

    private PeriodOfTime(PeriodOfTime original, String startDate, String endDate, String rawString) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.rawString = rawString;
        this.initShim = null;
    }

    @Override
    public String getStartDate() {
        return this.initShim != null ? this.initShim.getStartDate() : this.startDate;
    }

    @Override
    public String getEndDate() {
        return this.initShim != null ? this.initShim.getEndDate() : this.endDate;
    }

    @Override
    public String getRawString() {
        return this.initShim != null ? this.initShim.getRawString() : this.rawString;
    }

    public final PeriodOfTime withStartDate(String value) {
        if (this.startDate == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return PeriodOfTime.validate(new PeriodOfTime(this, newValue, this.endDate, this.rawString));
    }

    public final PeriodOfTime withEndDate(String value) {
        if (this.endDate == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return PeriodOfTime.validate(new PeriodOfTime(this, this.startDate, newValue, this.rawString));
    }

    public final PeriodOfTime withRawString(String value) {
        if (this.rawString == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return PeriodOfTime.validate(new PeriodOfTime(this, this.startDate, this.endDate, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PeriodOfTime && this.equalTo((PeriodOfTime)another);
    }

    private boolean equalTo(PeriodOfTime another) {
        return this.startDate.equals(another.startDate) && this.endDate.equals(another.endDate) && this.rawString.equals(another.rawString);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.startDate.hashCode();
        h = h * 17 + this.endDate.hashCode();
        h = h * 17 + this.rawString.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PeriodOfTime").add("startDate", (Object)this.startDate).add("endDate", (Object)this.endDate).add("rawString", (Object)this.rawString).toString();
    }

    public static PeriodOfTime of() {
        return INSTANCE;
    }

    public static PeriodOfTime of(String startDate, String endDate, String rawString) {
        return PeriodOfTime.validate(new PeriodOfTime(startDate, endDate, rawString));
    }

    private static PeriodOfTime validate(PeriodOfTime instance) {
        instance.check();
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static PeriodOfTime copyOf(PeriodOfTime instance) {
        if (instance instanceof PeriodOfTime) {
            return instance;
        }
        return PeriodOfTime.of(instance.getStartDate(), instance.getEndDate(), instance.getRawString());
    }

    private final class InitShim {
        private String startDate;
        private byte startDateStage;
        private String endDate;
        private byte endDateStage;
        private String rawString;
        private byte rawStringStage;

        private InitShim() {
        }

        String getStartDate() {
            if (this.startDateStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startDateStage == 0) {
                this.startDateStage = (byte)-1;
                this.startDate = (String)Preconditions.checkNotNull((Object)PeriodOfTime.super.getStartDate());
                this.startDateStage = 1;
            }
            return this.startDate;
        }

        String setStartDate(String value) {
            this.startDate = value;
            this.startDateStage = 1;
            return value;
        }

        String getEndDate() {
            if (this.endDateStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.endDateStage == 0) {
                this.endDateStage = (byte)-1;
                this.endDate = (String)Preconditions.checkNotNull((Object)PeriodOfTime.super.getEndDate());
                this.endDateStage = 1;
            }
            return this.endDate;
        }

        String setEndDate(String value) {
            this.endDate = value;
            this.endDateStage = 1;
            return value;
        }

        String getRawString() {
            if (this.rawStringStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rawStringStage == 0) {
                this.rawStringStage = (byte)-1;
                this.rawString = (String)Preconditions.checkNotNull((Object)PeriodOfTime.super.getRawString());
                this.rawStringStage = 1;
            }
            return this.rawString;
        }

        String setRawString(String value) {
            this.rawString = value;
            this.rawStringStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.startDateStage == -1) {
                attributes.add("startDate");
            }
            if (this.endDateStage == -1) {
                attributes.add("endDate");
            }
            if (this.rawStringStage == -1) {
                attributes.add("rawString");
            }
            return "Cannot build PeriodOfTime, attribute initializers form cycle" + attributes;
        }
    }
}

