/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cluster;

import java.util.ArrayList;
import java.util.Comparator;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.sdi.engine.impl.cluster.AbstractCluster;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoNetworkController;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceInteractionException;
import org.gcube.spatial.data.sdi.engine.impl.is.ISModule;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoNetworkCluster
extends AbstractCluster<GeoNetworkDescriptor, GeoNetworkController> {
    private static final Logger log = LoggerFactory.getLogger(GeoNetworkCluster.class);
    private static final Comparator<GeoNetworkController> comparator = new /* Unavailable Anonymous Inner Class!! */;

    public GeoNetworkCluster(long objectsTTL, ISModule retriever, String cacheName) {
        super(objectsTTL, retriever, cacheName);
    }

    protected Comparator<GeoNetworkController> getComparator() {
        return comparator;
    }

    protected GeoNetworkController translate(ServiceEndpoint e) throws InvalidServiceEndpointException {
        return new GeoNetworkController(e);
    }

    protected ArrayList<GeoNetworkController> getLiveControllerCollection() throws ConfigurationNotFoundException {
        ArrayList toReturn = super.getLiveControllerCollection();
        try {
            ((GeoNetworkController)toReturn.get(0)).configure();
        }
        catch (ServiceInteractionException e) {
            log.warn("Unexpected exception while configuring GeoNetwork SE [ID : " + ((GeoNetworkController)toReturn.get(0)).getServiceEndpoint().id() + "]", (Throwable)e);
        }
        return toReturn;
    }
}

