/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.planning.maxsubtree;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import org.gcube.searchsystem.planning.commonvocabulary.IndexRelationCommonSemantics;
import org.gcube.searchsystem.planning.exception.CQLUnsupportedException;
import org.gcube.searchsystem.planning.maxsubtree.AndTree;
import org.gcube.searchsystem.planning.maxsubtree.TreeTransformer;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.ModifierSet;

public class MaxSubtreeRewritter {
    private Logger logger = Logger.getLogger(MaxSubtreeRewritter.class.getName());
    private GCQLNode root;
    private Vector<ModifierSet> projections = new Vector();

    public MaxSubtreeRewritter(GCQLNode root) {
        this.root = root;
    }

    public ArrayList<AndTree> rewrite() throws CQLUnsupportedException {
        if (this.root instanceof GCQLProjectNode) {
            this.setProjections(((GCQLProjectNode)this.root).getProjectIndexes());
            this.root = ((GCQLProjectNode)this.root).subtree;
        }
        this.logger.fine("Starting push Not Down Or Up");
        long before = Calendar.getInstance().getTimeInMillis();
        ArrayList<Set<TreeTransformer.GCQLCondition>> trees = TreeTransformer.pushNotDownOrUp(this.root, false);
        long after = Calendar.getInstance().getTimeInMillis();
        this.logger.info("PushNotDownOrUp returned after: " + (after - before) + " millis");
        this.logger.finer("trees after push Not Down Or Up");
        for (Set<TreeTransformer.GCQLCondition> tree : trees) {
            this.logger.finer("set of conditions: ");
            for (TreeTransformer.GCQLCondition cond : tree) {
                this.logger.finer("Not: " + cond.not + ", term: " + cond.term.toCQL());
            }
        }
        this.logger.fine("check the validity of the trees");
        before = Calendar.getInstance().getTimeInMillis();
        this.checkValidityTrees(trees);
        after = Calendar.getInstance().getTimeInMillis();
        this.logger.info("CheckValidityTrees returned after: " + (after - before) + " millis");
        ArrayList<AndTree> results = new ArrayList<AndTree>(trees.size());
        this.logger.fine("detecting languages-collections for AndTrees");
        before = Calendar.getInstance().getTimeInMillis();
        for (Set<TreeTransformer.GCQLCondition> tree : trees) {
            AndTree currentResult = this.detectCollectionLang(tree);
            if (currentResult == null) continue;
            results.add(currentResult);
        }
        after = Calendar.getInstance().getTimeInMillis();
        this.logger.info("DetectCollectionLang returned after: " + (after - before) + " millis");
        return results;
    }

    private AndTree detectCollectionLang(Set<TreeTransformer.GCQLCondition> tree) throws CQLUnsupportedException {
        AndTree result = new AndTree();
        for (TreeTransformer.GCQLCondition condition : tree) {
            this.logger.finer("Not: " + condition.not + ", term: " + condition.term.toCQL());
            this.logger.finer("Modifiers size: " + condition.getTerm().getRelation().getModifiers().size());
            if (IndexRelationCommonSemantics.examineCondition(condition, result)) continue;
            this.logger.fine("Collections and languages are contraddicting for this tree:");
            this.logger.fine("set of conditions: ");
            for (TreeTransformer.GCQLCondition cond : tree) {
                this.logger.finer("Not: " + cond.not + ", term: " + cond.term.toCQL());
            }
            return null;
        }
        return result;
    }

    private void checkValidityTrees(ArrayList<Set<TreeTransformer.GCQLCondition>> trees) throws CQLUnsupportedException {
        block0: for (Set<TreeTransformer.GCQLCondition> andConditionSet : trees) {
            for (TreeTransformer.GCQLCondition cond : andConditionSet) {
                if (cond.not) continue;
                continue block0;
            }
            throw new CQLUnsupportedException("tree: " + this.root.toCQL() + ", indicates an pure-NOT part. pure-NOT parts are not supported");
        }
    }

    public Vector<ModifierSet> getProjections() {
        return this.projections;
    }

    public void setProjections(Vector<ModifierSet> projections) {
        boolean foundWild = false;
        for (ModifierSet current : projections) {
            if (!current.getBase().equals("*")) continue;
            foundWild = true;
            break;
        }
        if (foundWild) {
            projections.clear();
            projections.add(new ModifierSet("*"));
        }
        this.projections = projections;
    }
}

