/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.planning.maxsubtree;

import gr.uoa.di.madgik.workflow.adaptor.search.searchsystemplan.DataSourceNode;
import gr.uoa.di.madgik.workflow.adaptor.search.searchsystemplan.OperatorNode;
import gr.uoa.di.madgik.workflow.adaptor.search.searchsystemplan.PlanNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.searchsystem.environmentadaptor.EnvironmentAdaptor;
import org.gcube.searchsystem.environmentadaptor.ResourceRegistryAdapter;
import org.gcube.searchsystem.planning.Planner;
import org.gcube.searchsystem.planning.commonvocabulary.DefaultStrategy;
import org.gcube.searchsystem.planning.commonvocabulary.OperatorSemantics;
import org.gcube.searchsystem.planning.exception.CQLTreeSyntaxException;
import org.gcube.searchsystem.planning.exception.CQLUnsupportedException;
import org.gcube.searchsystem.planning.maxsubtree.AndTree;
import org.gcube.searchsystem.planning.maxsubtree.GeneralTreeNode;
import org.gcube.searchsystem.planning.maxsubtree.MaxSubtreeRewritter;
import org.gcube.searchsystem.planning.maxsubtree.TreeTransformer;
import org.gcube.searchsystem.planning.maxsubtree.TwoPhaseComposer;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.Modifier;
import search.library.util.cql.query.tree.ModifierSet;

public class MaxSubtreePlanner
implements Planner {
    private Logger logger = Logger.getLogger(MaxSubtreePlanner.class.getName());
    private ArrayList<String> priorities = new ArrayList();
    private ArrayList<String> warnings = new ArrayList();
    private EnvironmentAdaptor environmentAdaptor = null;
    private long timeSpendOnRegistry = 0L;
    private static final String TESTQUERY1 = "((((author any \"Joe\") and (title proximity \" invorves \")) not (gDocCollectionLang == \"fr\")) or ((gDocCollectionID == \"A\") and ((title any \"Will\") or (author any \"Norm\"))))";
    private static final String TESTQUERY2B = "((geo geosearch \"11 7 20 100\") and ((type exact \"new\") and ((geo geosearch \"-2 -6 8 4\") and ((gDocCollectionID == \"C\") and ((gDocCollectionLang == \"en\") and (((desc any \"new\") and (gDocCollectionID == \"C\")) or ((abstract exact \"new\") and ((spec any \"new\") or (tech any \"new\")))))))))";
    private static final String TESTQUERY2 = "((geo geosearch \"11 7 20 100\") and ((type exact \"new\") and ((geo geosearch \"-2 -6 8 4\") and ((gDocCollectionLang == \"en\") and (((desc any \"new\") and (gDocCollectionID == \"C\")) or ((abstract exact \"new\") and ((spec any \"new\") or (tech any \"new\"))))))))";
    private static final String TESTQUERY3 = "((((author any \"Joe\") and (title proximity \" invorves \")) not (gDocCollectionLang == \"fr\")) or ((gDocCollectionID == \"A\") and ((title any \"Will\") or (author any \"Norm\")))) or ((geo geosearch \"11 7 20 100\") and ((type exact \"new\") and ((geo geosearch \"-2 -6 8 4\") and ((gDocCollectionLang == \"en\") and (((desc any \"new\") and (gDocCollectionID == \"C\")) or ((abstract exact \"new\") and ((spec any \"new\") or (tech any \"new\"))))))))";
    public static final String DEFAULTPRIORITY = "default";
    static final String WILDCARD = "*";
    private static final String DISTINCT = "distinct";

    public static void main(String[] args) {
        GCQLNode head = GCQLQueryTreeManager.parseGCQLString((String)TESTQUERY3);
        MaxSubtreePlanner planner = new MaxSubtreePlanner(new ArrayList<String>(), new ResourceRegistryAdapter("dummyScope"));
        planner.priorities.add(DEFAULTPRIORITY);
        try {
            PlanNode plan = planner.plan(head);
            System.out.print(plan.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MaxSubtreePlanner(ArrayList<String> priorities, EnvironmentAdaptor environmentAdaptor) {
        this.priorities = priorities;
        this.environmentAdaptor = environmentAdaptor;
    }

    public ArrayList<String> getPriorities() {
        return this.priorities;
    }

    public void setPriorities(ArrayList<String> priorities) {
        this.priorities = priorities;
    }

    public ArrayList<String> getWarnings() {
        return this.warnings;
    }

    public void clearWarnings() {
        this.warnings = new ArrayList();
    }

    @Override
    public PlanNode plan(GCQLNode root) throws CQLTreeSyntaxException, CQLUnsupportedException {
        this.clearWarnings();
        this.logger.info("rewritting query for max subtree planner");
        MaxSubtreeRewritter rewriter = new MaxSubtreeRewritter(root);
        ArrayList<AndTree> subtreeList = rewriter.rewrite();
        for (String indication : this.priorities) {
            this.logger.info("started composition for indication: " + indication);
            ArrayList<AndTree> subtrees = new ArrayList<AndTree>();
            for (AndTree tree : subtreeList) {
                subtrees.add((AndTree)tree.clone());
            }
            this.logger.info("enhance trees with sources for indication: " + indication);
            long before = Calendar.getInstance().getTimeInMillis();
            try {
                subtrees = this.enhanceAndTreesWithSources(subtrees, rewriter.getProjections(), indication);
            }
            catch (CQLUnsupportedException cqle) {
                this.logger.log(Level.SEVERE, "enhance with sources failed: ", cqle);
                continue;
            }
            long after = Calendar.getInstance().getTimeInMillis();
            this.logger.info("enhanceAndTreesWithSources returned after: " + (after - before) + " millis");
            this.logger.info("Time spend on Environment Adaptor until now: " + this.timeSpendOnRegistry + " millis");
            this.logger.fine("enhance with sources returned: ");
            for (AndTree tree : subtrees) {
                this.logger.fine("Tree for collection: " + tree.collection + ", language: " + tree.language);
                for (int i = 0; i < tree.conditions.size(); ++i) {
                    TreeTransformer.GCQLCondition condition = tree.conditions.get(i);
                    this.logger.fine("Not: " + condition.not + ", term: " + condition.term.toCQL());
                    this.logger.fine("Sources: " + Arrays.toString(tree.sources.get(i).toArray(new String[tree.sources.get(i).size()])));
                }
            }
            if (subtrees.size() == 0) {
                this.logger.info("no trees after enhancement for indication: " + indication);
                continue;
            }
            this.logger.info("starting 2 phase composer for indication: " + indication);
            before = Calendar.getInstance().getTimeInMillis();
            TwoPhaseComposer composer = new TwoPhaseComposer(subtrees, rewriter.getProjections());
            GeneralTreeNode rootNode = composer.compose();
            after = Calendar.getInstance().getTimeInMillis();
            this.logger.info("TwoPhaseComposer returned after: " + (after - before) + " millis");
            boolean distinct = false;
            HashSet<String> projections = new HashSet<String>();
            for (ModifierSet mod : rewriter.getProjections()) {
                projections.add(mod.getBase());
                if (mod.getModifiers().size() <= 0 || !((Modifier)mod.getModifiers().get(0)).getType().equalsIgnoreCase(DISTINCT)) continue;
                distinct = true;
            }
            this.logger.info("starting node specialization for indication: " + indication);
            return this.specializeNode(rootNode, projections, indication, distinct);
        }
        return null;
    }

    private PlanNode specializeNode(GeneralTreeNode node, Set<String> projectionsNeeded, String indication, boolean distinct) throws CQLUnsupportedException {
        switch (node.type) {
            case AND: {
                return this.specializeAndNode(node, projectionsNeeded, indication, distinct);
            }
            case OR: {
                return this.specializeOrNode(node, projectionsNeeded, indication, distinct);
            }
            case LEAF: {
                return this.specializeLeafNode(node, projectionsNeeded, indication, distinct);
            }
            case NOT: {
                this.logger.severe("The NOT case should not happen in the current implementation");
                return this.specializeNotNode(node, projectionsNeeded, indication, distinct);
            }
        }
        throw new CQLUnsupportedException("Only AND, OR, LEAF (and NOT) cases are permitted");
    }

    private PlanNode specializeOrNode(GeneralTreeNode node, Set<String> projectionsNeeded, String indication, boolean distinct) throws CQLUnsupportedException {
        String semantics = OperatorSemantics.getOrOperationSemantics(indication);
        ArrayList<PlanNode> children = new ArrayList<PlanNode>();
        HashSet commonProjections = null;
        for (GeneralTreeNode child : node.children) {
            PlanNode current = this.specializeNode(child, projectionsNeeded, indication, distinct);
            if (commonProjections == null) {
                commonProjections = new HashSet(current.getProjections());
            } else {
                commonProjections.retainAll(current.getProjections());
            }
            children.add(current);
        }
        HashMap<String, String> args = OperatorSemantics.createOrOperationArgs(semantics, DEFAULTPRIORITY, indication);
        return new OperatorNode(semantics, args, children, commonProjections);
    }

    private PlanNode specializeAndNode(GeneralTreeNode node, Set<String> projectionsNeeded, String indication, boolean distinct) throws CQLUnsupportedException {
        distinct = false;
        this.logger.warning("the distinct currently can not be supported for the join case setting it to false");
        String semantics = OperatorSemantics.getAndOperationSemantics(indication);
        ArrayList<PlanNode> result = new ArrayList<PlanNode>();
        HashSet<String> currentProjections = new HashSet<String>(projectionsNeeded);
        for (GeneralTreeNode child : node.children) {
            PlanNode output = this.specializeNode(child, currentProjections, indication, distinct);
            result.add(output);
            currentProjections.removeAll(output.getProjections());
        }
        PlanNode current = (PlanNode)result.remove(0);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PlanNode left = (PlanNode)iter.next();
            ArrayList<PlanNode> children = new ArrayList<PlanNode>();
            children.add(left);
            children.add(current);
            HashMap<String, String> args = null;
            Set leftProjections = left.getProjections();
            args = leftProjections.size() == 0 ? OperatorSemantics.createAndOperationArgs(semantics, indication, "right") : OperatorSemantics.createAndOperationArgs(semantics, indication, "both");
            HashSet proj = new HashSet(current.getProjections());
            proj.addAll(leftProjections);
            current = new OperatorNode(semantics, args, children, proj);
            iter.remove();
        }
        return current;
    }

    private PlanNode specializeLeafNode(GeneralTreeNode node, Set<String> projectionsNeeded, String indication, boolean distinct) throws CQLUnsupportedException {
        Set<Object> sources = new HashSet();
        HashSet<Object> maxSet = null;
        GCQLProjectNode gcql = null;
        if (projectionsNeeded.contains(WILDCARD)) {
            gcql = new GCQLProjectNode();
            gcql.subtree = node.gcql;
            gcql.getProjectIndexes().add(new ModifierSet(WILDCARD));
            maxSet = new HashSet();
            maxSet.add(WILDCARD);
            sources = node.sources;
        } else {
            if (projectionsNeeded.size() > 0) {
                HashMap<String, HashSet<String>> projectionsPerSource = null;
                this.logger.finer("getting projections for sources");
                try {
                    this.logger.finest("log getProjections per source args - sources: " + Arrays.toString(node.sources.toArray(new String[node.sources.size()])) + " - projectionsNeeded: " + Arrays.toString(projectionsNeeded.toArray(new String[projectionsNeeded.size()])));
                    for (Map.Entry<String, HashSet<String>> entry : node.colLangs.entrySet()) {
                        this.logger.finest("log getProjections per source args - col: " + entry.getKey() + " - langs" + Arrays.toString(entry.getValue().toArray(new String[entry.getValue().size()])));
                    }
                    long before = Calendar.getInstance().getTimeInMillis();
                    projectionsPerSource = this.environmentAdaptor.getProjectionsPerSource(new HashSet<String>(node.sources), projectionsNeeded, node.colLangs);
                    long after = Calendar.getInstance().getTimeInMillis();
                    long total = after - before;
                    this.logger.info("getProjectionsPerSource returned after total: " + total + " millis");
                    this.timeSpendOnRegistry += total;
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "getProjectionsPerSource failed!", e);
                    throw new CQLUnsupportedException("specializeLeafNode could not complete. getProjectionsPerSource failed: " + e.getMessage());
                }
                for (Map.Entry<String, HashSet<String>> entry : projectionsPerSource.entrySet()) {
                    this.logger.finer("source: " + entry.getKey());
                    for (String projection : entry.getValue()) {
                        this.logger.finer("projected field: " + projection);
                    }
                }
                for (Map.Entry<String, HashSet<String>> entry : projectionsPerSource.entrySet()) {
                    HashSet<String> currentSet = entry.getValue();
                    if (maxSet != null && currentSet.size() <= maxSet.size()) continue;
                    maxSet = currentSet;
                }
                for (Map.Entry<String, HashSet<String>> entry : projectionsPerSource.entrySet()) {
                    HashSet<String> currentSet = entry.getValue();
                    HashSet<Object> tmpSet = new HashSet<Object>(maxSet);
                    tmpSet.retainAll(currentSet);
                    if (tmpSet.size() != maxSet.size()) continue;
                    sources.add(entry.getKey());
                }
                if (maxSet.size() > 0) {
                    gcql = new GCQLProjectNode();
                    gcql.subtree = node.gcql;
                    for (String string : maxSet) {
                        ModifierSet modSet = new ModifierSet(string);
                        if (distinct) {
                            distinct = false;
                            modSet.addModifier(DISTINCT);
                        }
                        gcql.getProjectIndexes().add(modSet);
                    }
                } else {
                    gcql = DefaultStrategy.addDefaultProjections(node.gcql);
                }
            } else {
                gcql = DefaultStrategy.addDefaultProjections(node.gcql);
            }
            if (maxSet == null) {
                maxSet = new HashSet<String>();
                sources = node.sources;
            }
        }
        return new DataSourceNode(sources, new HashMap(), gcql.toCQL(), maxSet);
    }

    private PlanNode specializeNotNode(GeneralTreeNode node, Set<String> projectionsNeeded, String indication, boolean distinct) throws CQLUnsupportedException {
        String semantics = OperatorSemantics.getNotOperationSemantics(indication);
        if (node.children.size() != 2) {
            throw new CQLUnsupportedException("NOT General Tree node doesn't have exactly two children");
        }
        ArrayList<PlanNode> children = new ArrayList<PlanNode>();
        PlanNode left = this.specializeNode(node.children.get(0), projectionsNeeded, indication, distinct);
        children.add(left);
        children.add(this.specializeNode(node.children.get(1), new HashSet<String>(), indication, distinct));
        HashMap<String, String> args = OperatorSemantics.createNotOperationArgs(semantics, DEFAULTPRIORITY, indication);
        return new OperatorNode(semantics, args, children, left.getProjections());
    }

    private ArrayList<AndTree> enhanceAndTreesWithSources(ArrayList<AndTree> subtrees, Vector<ModifierSet> proj, String indication) throws CQLUnsupportedException {
        ArrayList<AndTree> result = new ArrayList<AndTree>();
        ArrayList<String> projections = new ArrayList<String>();
        for (ModifierSet projection : proj) {
            projections.add(projection.getBase());
        }
        for (int i = 0; i < subtrees.size(); ++i) {
            AndTree tree;
            long total;
            Map<String, List<String>> fieldRelationMap;
            AndTree currentTree = subtrees.get(i);
            if (currentTree.collection == null) {
                HashSet<String> notCols;
                if (currentTree.language == null) {
                    this.logger.finer("get collection-languages for conditions: ");
                    fieldRelationMap = this.getFieldRelationMap(currentTree);
                    for (Map.Entry<String, List<String>> fieldRelations : fieldRelationMap.entrySet()) {
                        this.logger.finer("field: " + fieldRelations.getKey());
                        for (String relation : fieldRelations.getValue()) {
                            this.logger.finer("relation: " + relation);
                        }
                    }
                    Map<String, Set<String>> collectionLangs = null;
                    try {
                        long before = Calendar.getInstance().getTimeInMillis();
                        collectionLangs = this.environmentAdaptor.getCollectionLangsByFieldRelation(fieldRelationMap, projections);
                        long after = Calendar.getInstance().getTimeInMillis();
                        total = after - before;
                        this.logger.info("getCollectionLangsByFieldRelation returned after total: " + total + " millis");
                        this.timeSpendOnRegistry += total;
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "getCollectionLangsByFieldRelation failed!", e);
                        throw new CQLUnsupportedException("enhanceAndTreesWithSources could not complete. getCollectionLangsByFieldRelation failed: " + e.getMessage());
                    }
                    this.logger.finer("registry returned collection-languages: ");
                    for (Map.Entry<String, Set<String>> colLangs : collectionLangs.entrySet()) {
                        this.logger.finer("collection: " + colLangs.getKey());
                        for (String language : colLangs.getValue()) {
                            this.logger.finer("language: " + language);
                        }
                    }
                    notCols = new HashSet<String>(currentTree.notCollections);
                    HashSet<String> notLangs = new HashSet<String>(currentTree.notLanguages);
                    if (collectionLangs == null) continue;
                    for (Map.Entry<String, Set<String>> currentColLangs : collectionLangs.entrySet()) {
                        String collection = currentColLangs.getKey();
                        if (notCols.contains(collection)) continue;
                        for (String language : currentColLangs.getValue()) {
                            AndTree tree2;
                            if (notLangs.contains(language) || (tree2 = this.createNewTree(currentTree, collection, language, indication)) == null) continue;
                            result.add(tree2);
                        }
                    }
                    continue;
                }
                this.logger.finer("get collections for language: " + currentTree.language + ", for conditions: ");
                fieldRelationMap = this.getFieldRelationMap(currentTree);
                for (Map.Entry<String, List<String>> fieldRelations : fieldRelationMap.entrySet()) {
                    this.logger.finer("field: " + fieldRelations.getKey());
                    for (String relation : fieldRelations.getValue()) {
                        this.logger.finer("relation: " + relation);
                    }
                }
                Set<String> collections = null;
                try {
                    long before = Calendar.getInstance().getTimeInMillis();
                    collections = this.environmentAdaptor.getCollectionByFieldRelationLang(fieldRelationMap, currentTree.language, projections);
                    long after = Calendar.getInstance().getTimeInMillis();
                    total = after - before;
                    this.logger.info("getCollectionByFieldRelationLang returned after total: " + total + " millis");
                    this.timeSpendOnRegistry += total;
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "getCollectionByFieldRelationLang failed!", e);
                    throw new CQLUnsupportedException("enhanceAndTreesWithSources could not complete. getCollectionByFieldRelationLang failed: " + e.getMessage());
                }
                for (String collection : collections) {
                    this.logger.finer("collection: " + collection);
                }
                notCols = new HashSet<String>(currentTree.notCollections);
                if (collections == null) continue;
                for (String collection : collections) {
                    if (notCols.contains(collection) || (tree = this.createNewTree(currentTree, collection, currentTree.language, indication)) == null) continue;
                    result.add(tree);
                }
                continue;
            }
            if (currentTree.language == null) {
                this.logger.finer("get languages for collection: " + currentTree.collection + ", for conditions: ");
                fieldRelationMap = this.getFieldRelationMap(currentTree);
                for (Map.Entry<String, List<String>> fieldRelations : fieldRelationMap.entrySet()) {
                    this.logger.finer("field: " + fieldRelations.getKey());
                    for (String relation : fieldRelations.getValue()) {
                        this.logger.finer("relation: " + relation);
                    }
                }
                Set<String> languages = null;
                try {
                    long before = Calendar.getInstance().getTimeInMillis();
                    languages = this.environmentAdaptor.getLanguageByFieldRelationCol(fieldRelationMap, currentTree.collection, projections);
                    long after = Calendar.getInstance().getTimeInMillis();
                    total = after - before;
                    this.logger.info("getLanguageByFieldRelationCol returned after total: " + total + " millis");
                    this.timeSpendOnRegistry += total;
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "getLanguageByFieldRelationCol failed!", e);
                    throw new CQLUnsupportedException("enhanceAndTreesWithSources could not complete. getLanguageByFieldRelationCol failed: " + e.getMessage());
                }
                for (String language : languages) {
                    this.logger.finer("language: " + language);
                }
                HashSet<String> notLangs = new HashSet<String>(currentTree.notLanguages);
                if (languages == null) continue;
                for (String language : languages) {
                    if (notLangs.contains(language) || (tree = this.createNewTree(currentTree, currentTree.collection, language, indication)) == null) continue;
                    result.add(tree);
                }
                continue;
            }
            this.logger.finer("specific collection: " + currentTree.collection + ", language: " + currentTree.language);
            AndTree tree3 = this.createNewTree(currentTree, currentTree.collection, currentTree.language, indication);
            if (tree3 == null) continue;
            result.add(tree3);
        }
        return result;
    }

    private AndTree createNewTree(AndTree currentTree, String collection, String language, String indication) throws CQLUnsupportedException {
        AndTree newTree = new AndTree();
        newTree.setConditions(new ArrayList<TreeTransformer.GCQLCondition>(currentTree.conditions));
        newTree.setCollection(collection);
        newTree.setLanguage(language);
        for (TreeTransformer.GCQLCondition condition : currentTree.conditions) {
            this.logger.finer("Get sources for condition: Index - " + condition.getTerm().getIndex() + ", Relation - " + condition.getTerm().getRelation().getBase() + ", Collection - " + collection + ", Language - " + language + ", Indication - " + indication);
            Set<String> sources = null;
            try {
                long before = Calendar.getInstance().getTimeInMillis();
                sources = this.environmentAdaptor.getSourceIdsForFieldRelationCollectionLanguage(condition.getTerm().getIndex(), condition.getTerm().getRelation().getBase(), collection, language, indication);
                long after = Calendar.getInstance().getTimeInMillis();
                long total = after - before;
                this.logger.info("getSourceIdsForFieldRelationCollectionLanguage returned after total: " + total + " millis");
                this.timeSpendOnRegistry += total;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "getSourceIdsForFieldRelationCollectionLanguage failed!", e);
                throw new CQLUnsupportedException("createNewTree could not complete. getSourceIdsForFieldRelationCollectionLanguage failed: " + e.getMessage());
            }
            this.logger.finer("Sources returned: " + Arrays.toString(sources.toArray(new String[sources.size()])));
            if (sources == null || sources.size() == 0) {
                String msg = condition.getTerm().toCQL();
                if (condition.isNot()) {
                    msg = "not(" + msg + ")";
                }
                msg = "There is no source for the criterion: " + msg + ", for collectionID: " + collection + " and language: " + language;
                this.logger.severe(msg);
                if (indication.equals(DEFAULTPRIORITY)) {
                    this.warnings.add(msg);
                    return null;
                }
                throw new CQLUnsupportedException("For indication " + indication + ": " + msg);
            }
            newTree.sources.add(new LinkedHashSet<String>(sources));
        }
        return newTree;
    }

    private Map<String, List<String>> getFieldRelationMap(AndTree andTree) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (TreeTransformer.GCQLCondition condition : andTree.getConditions()) {
            String field = condition.getTerm().getIndex();
            String relation = condition.getTerm().getRelation().getBase();
            ArrayList<String> relations = (ArrayList<String>)map.get(field);
            if (relations == null) {
                relations = new ArrayList<String>();
                map.put(field, relations);
            }
            relations.add(relation);
        }
        return map;
    }

    private HashMap<String, HashSet<String>> getProjectionsPerSourceDummy(Set<String> sources, Set<String> projectionsNeeded, HashMap<String, HashSet<String>> colLangs) {
        HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
        for (String source : sources) {
            HashSet<String> proj = new HashSet<String>(projectionsNeeded);
            result.put(source, proj);
        }
        return result;
    }

    private Map<String, List<String>> getCollectionLangsByFieldRelationDummy(Map<String, List<String>> fieldRelationMap, List<String> projections) {
        HashMap<String, List<String>> colLangs = new HashMap<String, List<String>>();
        ArrayList<String> langs = new ArrayList<String>();
        langs.add("en");
        langs.add("fr");
        colLangs.put("A", langs);
        colLangs.put("B", new ArrayList(langs));
        colLangs.put("C", new ArrayList(langs));
        return colLangs;
    }

    private List<String> getCollectionByFieldRelationLangDummy(Map<String, List<String>> fieldRelationMap, String language, List<String> projections) {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("A");
        cols.add("B");
        cols.add("C");
        return cols;
    }

    private List<String> getLanguageByFieldRelationColDummy(Map<String, List<String>> fieldRelationMap, String collection, List<String> projections) {
        ArrayList<String> langs = new ArrayList<String>();
        langs.add("en");
        langs.add("fr");
        return langs;
    }

    private Set<String> getSourceIdsForFieldRelationCollectionLanguageDummy(String field, String relation, String collection, String language, String indication) {
        if (relation.equals("geosearch")) {
            HashSet<String> result = new HashSet<String>();
            result.add("GEO" + collection + language);
            return result;
        }
        if (relation.equals("exact")) {
            HashSet<String> result = new HashSet<String>();
            result.add("FWD" + collection + language);
            return result;
        }
        HashSet<String> result = new HashSet<String>();
        result.add("FT" + collection + language);
        return result;
    }
}

