/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.environmentadaptor;

import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.searchsystem.environmentadaptor.EnvironmentAdaptor;

public class ResourceRegistryAdapter
implements EnvironmentAdaptor {
    private String scope;
    private static Logger logger = Logger.getLogger(ResourceRegistryAdapter.class.getName());

    public static boolean initializeAdapter() throws Exception {
        try {
            ResourceRegistry.startBridging();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not start bridging", e);
            return false;
        }
        return true;
    }

    public ResourceRegistryAdapter(String scope) {
        this.scope = scope;
    }

    @Override
    public HashMap<String, HashSet<String>> getProjectionsPerSource(Set<String> sources, Set<String> projectionsNeeded, HashMap<String, HashSet<String>> colLangs) throws Exception {
        return QueryHelper.getProjectionsPerSource(sources, projectionsNeeded, colLangs, (String)this.scope);
    }

    @Override
    public Map<String, Set<String>> getCollectionLangsByFieldRelation(Map<String, List<String>> fieldRelationMap, List<String> projections) throws Exception {
        return QueryHelper.getCollectionLangsByFieldRelation(fieldRelationMap, projections, (String)this.scope);
    }

    @Override
    public Set<String> getCollectionByFieldRelationLang(Map<String, List<String>> fieldRelationMap, String language, List<String> projections) throws Exception {
        return QueryHelper.getCollectionByFieldRelationLang(fieldRelationMap, (String)language, projections, (String)this.scope);
    }

    @Override
    public Set<String> getLanguageByFieldRelationCol(Map<String, List<String>> fieldRelationMap, String collection, List<String> projections) throws Exception {
        return QueryHelper.getLanguageByFieldRelationCol(fieldRelationMap, (String)collection, projections, (String)this.scope);
    }

    @Override
    public Set<String> getSourceIdsForFieldRelationCollectionLanguage(String field, String relation, String collection, String language, String indication) throws Exception {
        return new HashSet<String>(QueryHelper.getSourceIdsForFieldRelationCollectionLanguage((String)field, (String)relation, (String)collection, (String)language, (String)this.scope));
    }
}

