/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.rseprcache;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.lang.StringUtils;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParsingUtils {
    public static Document parseXMLFileToDOM(String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
        return document;
    }

    public static String createStringFromDomTree(Node node) throws TransformerException {
        String string = null;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        DOMSource dOMSource = new DOMSource(node);
        transformer.transform(dOMSource, streamResult);
        string = stringWriter.getBuffer().toString();
        return string;
    }

    public static String removeSpaces(String string) {
        return StringUtils.deleteWhitespace((String)string);
    }

    public static EndpointReferenceType deserializeEPR(String string) {
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        try {
            return (EndpointReferenceType)ObjectDeserializer.deserialize((InputSource)inputSource, EndpointReferenceType.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

