/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rswriter;

import java.security.PrivateKey;
import java.util.Date;
import org.apache.log4j.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.searchlibrary.resultset.ResultSet;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.CreationParams;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSConstants;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocationWrapper;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.RSPoolObject;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSWriterCreationParams;

public class RSFullWriter
extends RSPoolObject {
    private static Logger log = Logger.getLogger(RSFullWriter.class);
    private ResultSet rs = null;
    private RSLocator remoteLocator = null;
    private RSLocator localLocator = null;
    private RSWriterCreationParams initParams = null;

    public static RSFullWriter getRSFullWriter(RSWriterCreationParams initParams) throws Exception {
        return new RSFullWriter(initParams);
    }

    public static RSFullWriter getRSFullWriter(PropertyElementBase[] properties) throws Exception {
        try {
            return new RSFullWriter(properties, false);
        }
        catch (Exception e) {
            log.error((Object)"Could not create full writer. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create full writer");
        }
    }

    public static RSFullWriter getRSFullWriter(PropertyElementBase[] properties, boolean dataFlow) throws Exception {
        try {
            return new RSFullWriter(properties, dataFlow);
        }
        catch (Exception e) {
            log.error((Object)"Could not create full writer. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create full writer");
        }
    }

    public static RSFullWriter getRSFullWriter(String properties) throws Exception {
        try {
            return new RSFullWriter(properties, false);
        }
        catch (Exception e) {
            log.error((Object)"Could not create full writer. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create full writer");
        }
    }

    public static RSFullWriter getRSFullWriter(String properties, boolean dataFlow) throws Exception {
        try {
            return new RSFullWriter(properties, dataFlow);
        }
        catch (Exception e) {
            log.error((Object)"Could not create full writer. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create full writer");
        }
    }

    protected RSFullWriter(PropertyElementBase[] properties, boolean dataFlow) throws Exception {
        try {
            String[] props = null;
            if (properties != null) {
                props = new String[properties.length];
                for (int i = 0; i < properties.length; ++i) {
                    try {
                        props[i] = properties[i].RS_toXML();
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not serialize property. Continuing", (Throwable)e);
                    }
                }
            }
            this.rs = new ResultSet(props, dataFlow);
        }
        catch (Exception e) {
            log.error((Object)"Could not create ResultSet. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create ResultSet");
        }
    }

    protected RSFullWriter(String properties, boolean dataFlow) throws Exception {
        try {
            this.rs = new ResultSet(properties, dataFlow);
        }
        catch (Exception e) {
            log.error((Object)"Could not create ResultSet. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create ResultSet");
        }
    }

    public RSFullWriter(RSWriterCreationParams initParams) throws Exception {
        log.trace((Object)" RSFullWriter(RSWriterCreationParams initParams)");
        this.initParams = initParams;
        CreationParams rsParams = new CreationParams();
        PropertyElementBase[] properties = initParams.properties.toArray(new PropertyElementBase[initParams.properties.size()]);
        for (int i = 0; i < properties.length; ++i) {
            try {
                rsParams.properties.add(properties[i].RS_toXML());
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Could not serialize property. Continuing", (Throwable)e);
            }
        }
        rsParams.setAccessReads(initParams.getAccessReads());
        rsParams.setDataflow(initParams.isDataflow());
        rsParams.setExpire_date(initParams.getExpire_date());
        rsParams.setForward(initParams.isForward());
        rsParams.setPKey(initParams.getPubKey());
        this.rs = new ResultSet(rsParams);
    }

    public RSLocator getRSLocator(RSResourceType type) throws Exception {
        if (this.initParams != null && this.initParams.getPrivKey() != null) {
            return this.getRSLocator(type, null, this.initParams.getPrivKey());
        }
        return this.getRSLocator(type, null, null);
    }

    public RSLocator getRSLocator(RSResourceType type, GCUBEScope scope) throws Exception {
        return this.getRSLocator(type, scope, null);
    }

    public RSLocator getRSLocator(RSResourceType type, PrivateKey pKey) throws Exception {
        return this.getRSLocator(type, null, pKey);
    }

    public RSLocator getRSLocator(RSResourceType type, GCUBEScope scope, PrivateKey pKey) throws Exception {
        try {
            if (this.remoteLocator != null && (type instanceof RSResourceWSRFType || type instanceof RSResourceWSType)) {
                return this.remoteLocator;
            }
            if (this.localLocator != null && type instanceof RSResourceLocalType) {
                return this.localLocator;
            }
            if (type instanceof RSResourceLocalType) {
                this.localLocator = new RSLocator(new RSResourceLocalType(), this.rs.getHeadName());
                return this.localLocator;
            }
            this.remoteLocator = RSLocationWrapper.retrieveLocator(type, this.rs.getHeadName(), scope, pKey);
            return this.remoteLocator;
        }
        catch (Exception e) {
            log.error((Object)"Could not create RSLocator", (Throwable)e);
            throw new Exception("Could not create RSLocator");
        }
    }

    public String getHeadName() throws Exception {
        try {
            return this.rs.getHeadName();
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve head part name. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve head part name");
        }
    }

    public void startNewPart() throws Exception {
        try {
            this.rs.startNewPart();
        }
        catch (Exception e) {
            log.error((Object)"Could not start new part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not start new part");
        }
    }

    public void endAuthoring() throws Exception {
        try {
            this.rs.endAuthoring();
        }
        catch (Exception e) {
            log.error((Object)"Could not end authoring. Throwing Exception", (Throwable)e);
            throw new Exception("Could not end authoring");
        }
    }

    public RSConstants.CONTROLFLOW more(long time) throws Exception {
        try {
            return this.rs.more(time);
        }
        catch (Exception e) {
            log.error((Object)"Could not check if more records are needed. Throwing Exception", (Throwable)e);
            throw new Exception("Could not check if more records are needed");
        }
    }

    public boolean isFlowControled() throws Exception {
        return this.rs.getRSRef().isDataFlow();
    }

    public boolean addResults(ResultElementBase[] results) throws Exception {
        try {
            if (results == null) {
                return true;
            }
            if (results.length == 0) {
                return true;
            }
            String[] res = new String[results.length];
            for (int i = 0; i < results.length; ++i) {
                try {
                    res[i] = results[i].RS_toXML();
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"Could not add results. Continuing", (Throwable)e);
                }
            }
            return this.rs.addResults(res);
        }
        catch (Exception e) {
            log.error((Object)"Could not add results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not add results");
        }
    }

    public boolean addText(String[] results) throws Exception {
        try {
            if (results == null) {
                return true;
            }
            if (results.length == 0) {
                return true;
            }
            return this.rs.addText(results);
        }
        catch (Exception e) {
            log.error((Object)"Could not add results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not add results");
        }
    }

    public boolean addResults(ResultElementBase results) throws Exception {
        try {
            if (results == null) {
                return true;
            }
            String[] res = new String[1];
            try {
                res[0] = results.RS_toXML();
            }
            catch (Exception e) {
                log.error((Object)"Could not serialize result. returning false", (Throwable)e);
                return false;
            }
            return this.rs.addResults(res);
        }
        catch (Exception e) {
            log.error((Object)"Could not start new part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not start new part");
        }
    }

    public boolean addText(String results) throws Exception {
        if (results == null) {
            return true;
        }
        return this.rs.addText(new String[]{results});
    }

    public void wrapFile(String filename) throws Exception {
        this.rs.wrapFile(filename);
    }

    public void overrideProperties(PropertyElementBase[] properties) throws Exception {
        this.rs.overrideProperties(properties);
    }

    public void overrideProperties(String properties) throws Exception {
        this.rs.overrideProperties(properties);
    }

    public void disableAccessLeasing() throws Exception {
        this.rs.disableAccessLeasing();
    }

    public void extendAccessLeasing(int extend) throws Exception {
        this.rs.extendAccessLeasing(extend);
    }

    public int getAccessLeasing() throws Exception {
        return this.rs.getAccessLeasing();
    }

    public boolean isForward() throws Exception {
        return this.rs.isForward();
    }

    public boolean setForward(boolean f) throws Exception {
        return this.rs.setForward(f);
    }

    public Date getTimeLeasing() throws Exception {
        return this.rs.getTimeLeasing();
    }

    public boolean extendTimeLeasing(Date extend) throws Exception {
        return this.rs.extendTimeLeasing(extend);
    }

    public void disableTimeLeasing() throws Exception {
        this.rs.disableTimeLeasing();
    }
}

