/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.hive.test;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import gr.uoa.di.madgik.hive.HiveQLPlanner;
import gr.uoa.di.madgik.hive.analyzer.OperatorAnalyzer;
import gr.uoa.di.madgik.hive.plan.DataSourceNode;
import gr.uoa.di.madgik.hive.plan.Functionality;
import gr.uoa.di.madgik.hive.plan.OperatorNode;
import gr.uoa.di.madgik.hive.plan.PlanNode;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserTest {
    private static Logger log = LoggerFactory.getLogger((String)HiveParserTest.class.getName());

    public static String getSimpleLine() {
        String line = "";
        line = line + "CREATE TABLE wiki (\n\t\tid STRING,\n\t\tproperty STRING,\n\t\ttype STRING,\n\t\tcontent STRING,\n\t\tlang STRING)\nROW FORMAT DELIMITED\nFIELDS TERMINATED BY '\\t'\nSTORED AS TEXTFILE;\n\n";
        line = line + "LOAD DATA LOCAL INPATH '/home/jgerbe/Desktop/in.txt'\nOVERWRITE INTO TABLE wiki;\n\n";
        line = line + "INSERT OVERWRITE LOCAL DIRECTORY '/home/jgerbe/Desktop/tmp/'\nSELECT id, property, content\nFROM wiki;\n\n";
        line = line + "DROP TABLE wiki;\n\n";
        return line;
    }

    public static String getLine(String dist, String file, String script) {
        String line = "";
        line = line + "CREATE TABLE wiki (\n\t\tproperty STRING,\n\t\ttype STRING,\n\t\tvalue STRING,\n\t\tlang STRING)\nROW FORMAT DELIMITED\nFIELDS TERMINATED BY '\\t'\nSTORED AS TEXTFILE;\n\n";
        line = line + "LOAD DATA LOCAL INPATH '" + file + "'\n" + "OVERWRITE INTO TABLE wiki;\n\n";
        line = line + "add FILE " + script + ";\n\n";
        line = line + "CREATE TABLE wiki_new (\n\t\tlang STRING,\tfreq STRING)\nROW FORMAT DELIMITED\nFIELDS TERMINATED BY '\\t';\n\n";
        line = line + "FROM wiki\nINSERT OVERWRITE TABLE wiki_new\nSELECT\n\t\tTRANSFORM(property, value, lang)\n\t\tUSING 'python counter.py'\n\t\tAS lang, content";
        line = !dist.equals("1") ? line + "\nDISTRIBUTE BY " + dist + ";\n\n" : line + ";\n\n";
        line = line + "INSERT OVERWRITE LOCAL DIRECTORY '/home/jgerbe/Desktop/tmp/'\nSELECT *\nFROM wiki_new;\n\n";
        line = line + "DROP TABLE wiki;\n\n";
        line = line + "DROP TABLE wiki_new;\n\n";
        return line;
    }

    public static void run(String[] args) throws Exception {
        HiveQLPlanner planner = new HiveQLPlanner();
        planner.processLine(args[0]);
        System.out.println(OperatorAnalyzer.optimizePlan(planner.getCreatedPlan()));
    }

    public static PlanNode createPlan() throws UnsupportedEncodingException {
        String selectString = "jdbc:postgresql://localhost:5432/mydb%3Fuser=postgres&password=aplagiadb/SELECT%20myproperty,mycontent,mylang%20FROM%20wikimulti";
        String insertString = new String("<q><query>insert into wikimulti_new values (?, ?, ?)</query><driverName>org.postgresql.Driver</driverName><connectionString>jdbc:postgresql://localhost:5432/mydb?user=postgres&amp;password=aplagiadb</connectionString></q>");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("schema", "[myproperty, mycontentq, mylang]");
        args.put("delimiter", "\t");
        args.put("filterMask", "[0, 1, 2]");
        args.put("source", selectString);
        PlanNode node = new DataSourceNode("wiki", args);
        args = new HashMap();
        args.put("schema", "[myproperty, mycontent, mylang]");
        args.put("clusterBy", "2");
        ArrayList<PlanNode> children = new ArrayList<PlanNode>();
        children.add(node);
        node = new OperatorNode(Functionality.PARTITION, args, children);
        args = new HashMap();
        args.put("schema", "[id, output]");
        args.put("scriptCmd", "python script.py");
        args.put("CDATA:script.py", Base64.encode(new HiveQLPlanner().comressedContentOfFile(new File("/home/jgerbe/Desktop/datasets/wiki/multi/counter.py"))));
        children = new ArrayList();
        children.add(node);
        node = new OperatorNode(Functionality.SCRIPT, args, children);
        args = new HashMap();
        args.put("schema", "[id, output]");
        children = new ArrayList();
        children.add(node);
        node = new OperatorNode(Functionality.MERGE, args, children);
        args = new HashMap();
        args.put("filterMask", "[0, 1]");
        args.put("schema", "[id, output]");
        children = new ArrayList();
        children.add(node);
        node = new OperatorNode(Functionality.SELECT, args, children);
        args = new HashMap();
        args.put("tableName", "wikimulti_new");
        args.put("sink", insertString);
        children = new ArrayList();
        children.add(node);
        node = new OperatorNode(Functionality.DATASINK, args, children);
        return node;
    }
}

