/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.hive;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import gr.uoa.di.madgik.hive.HiveQLParser;
import gr.uoa.di.madgik.hive.analyzer.OperatorAnalyzer;
import gr.uoa.di.madgik.hive.plan.DataSourceNode;
import gr.uoa.di.madgik.hive.plan.Functionality;
import gr.uoa.di.madgik.hive.plan.OperatorNode;
import gr.uoa.di.madgik.hive.plan.PlanNode;
import gr.uoa.di.madgik.hive.representation.TableDesc;
import gr.uoa.di.madgik.hive.representation.TableFieldsAssociation;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveQLPlanner {
    private Logger log = LoggerFactory.getLogger((String)HiveQLPlanner.class.getName());
    private HiveQLParser parser = new HiveQLParser();
    private PlanNode plan;
    private static Map<String, TableDesc> tablesMap = new HashMap<String, TableDesc>();
    private Map<String, String> addedFiles = new HashMap<String, String>();
    private TableFieldsAssociation fieldsToTableMap = new TableFieldsAssociation();
    private String clusterBy;
    private static final String DEFDELIMITER = "\\" + Character.toString('\u0001');

    public void processLine(String line) throws Exception {
        PrintStream errorStream = System.err;
        System.setErr(new PrintStream(new OutputStream(){
            private String str = "";

            @Override
            public void write(int b) throws IOException {
                if ((char)b == '\n') {
                    if (this.str.contains("FAILED")) {
                        HiveQLPlanner.this.log.error(this.str);
                    } else if (this.str.contains("OK")) {
                        HiveQLPlanner.this.log.debug(this.str);
                    }
                    this.str = "";
                } else {
                    this.str = this.str + (char)b;
                }
            }
        }));
        String command = "";
        for (String oneCmd : line.split(";")) {
            if (StringUtils.endsWith((String)oneCmd, (String)"\\")) {
                command = command + StringUtils.chop((String)oneCmd) + ";";
                continue;
            }
            if (StringUtils.isBlank((String)(command = command + oneCmd))) continue;
            this.log.debug("command: {\n" + command.trim() + "\n}");
            this.processCmd(command);
            command = "";
        }
        System.setErr(errorStream);
    }

    private void processCmd(String command) throws Exception {
        this.parser.parse(command);
        int ret = this.parser.compile();
        if (ret != 0) {
            throw new Exception("parsing compile failed with code: " + ret);
        }
        switch (this.parser.getQueryType()) {
            case CREATE: {
                this.parser.execute();
                CommonTree tree = this.parser.getASTree();
                String name = HiveQLPlanner.getNodes(tree, "TOK_CREATETABLE", "TOK_TABNAME").get(0);
                String delimiter = HiveQLPlanner.removeQuotes(HiveQLPlanner.getNodes(tree, "TOK_CREATETABLE", "TOK_TABLEROWFORMAT", "TOK_SERDEPROPS", "TOK_TABLEROWFORMATFIELD").isEmpty() ? DEFDELIMITER : StringEscapeUtils.unescapeJava((String)HiveQLPlanner.getNodes(tree, "TOK_CREATETABLE", "TOK_TABLEROWFORMAT", "TOK_SERDEPROPS", "TOK_TABLEROWFORMATFIELD").get(0)));
                TableDesc table = new TableDesc(name, delimiter);
                List<String> colList = HiveQLPlanner.getNodes(tree, "TOK_CREATETABLE", "TOK_TABCOLLIST", "TOK_TABCOL");
                int i = 0;
                while (i < colList.size()) {
                    table.addColumn(colList.get(i++), colList.get(i++));
                }
                tablesMap.put(table.getName(), table);
                for (String col : table.getColumns().keySet()) {
                    this.fieldsToTableMap.asscociate(col, table.getName());
                }
                this.log.debug("Created table: " + table);
                break;
            }
            case DROP: {
                this.parser.execute();
                CommonTree tree = this.parser.getASTree();
                String name = HiveQLPlanner.getNodes(tree, "TOK_DROPTABLE", "TOK_TABNAME").get(0);
                tablesMap.remove(name);
                this.fieldsToTableMap.removeTableAssociations(name);
                break;
            }
            case LOAD: {
                CommonTree tree = this.parser.getASTree();
                String source = HiveQLPlanner.removeQuotes(HiveQLPlanner.getNodes(tree, "TOK_LOAD").get(0));
                source = this.getUri(source);
                String name = HiveQLPlanner.getNodes(tree, "TOK_LOAD", "TOK_TAB", "TOK_TABNAME").get(0);
                TableDesc table = tablesMap.get(name);
                if (table == null) {
                    this.log.error("table does not exist");
                    throw new Exception("tables does not exist");
                }
                if (table.getSource() != null) {
                    this.log.warn("table already has data. Going to ovewrite");
                }
                table.setSource(source);
                tablesMap.put(name, table);
                this.log.debug("Load data: " + name + "[" + source + "]");
                break;
            }
            case QUERY: {
                CommonTree tree = this.parser.getASTree();
                String sink = null;
                if (!HiveQLPlanner.getNodes(tree, "TOK_QUERY", "TOK_INSERT", "TOK_DESTINATION", "TOK_TAB").isEmpty()) {
                    this.plan = this.parser.constructPlan();
                    if (!HiveQLPlanner.getNodes(tree, "TOK_QUERY", "TOK_INSERT", "TOK_DESTINATION", "TOK_LOCAL_DIR").isEmpty()) {
                        sink = this.getUri(HiveQLPlanner.removeQuotes(HiveQLPlanner.getNodes(tree, "TOK_QUERY", "TOK_INSERT", "TOK_DESTINATION", "TOK_LOCAL_DIR").get(0)));
                        this.plan.getFunctionalArgs().put("sink", sink);
                        this.plan = this.makeFinalReplacements();
                    }
                    if (!HiveQLPlanner.getNodes(tree, "TOK_QUERY", "TOK_INSERT", "TOK_DISTRIBUTEBY", "TOK_TABLE_OR_COL").isEmpty()) {
                        List<String> clusterCols = HiveQLPlanner.getNodes(tree, "TOK_QUERY", "TOK_INSERT", "TOK_DISTRIBUTEBY", "TOK_TABLE_OR_COL");
                        List<String> expList = HiveQLPlanner.getNodes(tree, "TOK_QUERY", "TOK_INSERT", "TOK_SELECT", "TOK_SELEXPR", "TOK_TRANSFORM", "TOK_EXPLIST", "TOK_TABLE_OR_COL");
                        String clusterBy = "[";
                        for (String col : clusterCols) {
                            clusterBy = clusterBy + (expList.indexOf(col) != -1 ? expList.indexOf(col) + ", " : "");
                        }
                        if ((clusterBy = clusterBy.substring(0, clusterBy.length() - 2) + "]").length() > 2) {
                            this.clusterBy = clusterBy;
                        }
                    }
                } else if (!HiveQLPlanner.getNodes(tree, "TOK_QUERY", "TOK_INSERT", "TOK_DESTINATION", "TOK_LOCAL_DIR").isEmpty()) {
                    sink = this.getUri(HiveQLPlanner.removeQuotes(HiveQLPlanner.getNodes(tree, "TOK_QUERY", "TOK_INSERT", "TOK_DESTINATION", "TOK_LOCAL_DIR").get(0)));
                    this.plan = this.plan != null ? OperatorAnalyzer.concatPlans(this.plan, this.parser.constructPlan()) : this.parser.constructPlan();
                    this.plan.getFunctionalArgs().put("sink", sink);
                    this.plan = this.makeFinalReplacements();
                }
                if (this.plan instanceof OperatorNode) break;
                throw new Exception("constructed plan has no operator node as root");
            }
            case ADD: {
                String fname = command.trim().split("\\s+")[2].split("/")[command.trim().split("/").length - 1];
                String file = command.trim().split("\\s+")[2];
                this.addedFiles.put(fname, file);
                this.log.debug("Add File: " + fname + "[" + file + "]");
                break;
            }
            default: {
                throw new Exception("Unexpected command: " + command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanNode makeFinalReplacements() throws Exception {
        LinkedList<OperatorNode> operList = new LinkedList<OperatorNode>();
        if (this.plan instanceof OperatorNode) {
            operList.add((OperatorNode)this.plan);
        }
        while (!operList.isEmpty()) {
            OperatorNode op = (OperatorNode)operList.removeFirst();
            for (PlanNode ch : op.getChildren()) {
                if (ch instanceof OperatorNode) {
                    operList.add((OperatorNode)ch);
                    continue;
                }
                if (!(ch instanceof DataSourceNode)) continue;
                ch.getFunctionalArgs().put("source", tablesMap.get(((DataSourceNode)ch).getSource()).getSource());
            }
            if (op.getFunctionality() == Functionality.SCRIPT) {
                String scriptCmd = op.getFunctionalArgs().get("scriptCmd");
                String script = scriptCmd.split(" ")[scriptCmd.split(" ").length - 1];
                if (scriptCmd.split(" ").length > 1) {
                    if (!this.addedFiles.containsKey(script)) {
                        throw new Exception("script has not been loaded. script: " + script);
                    }
                    String scriptLoc = this.addedFiles.get(script);
                    File fileScript = null;
                    boolean local = false;
                    try {
                        URL url = new URL(scriptLoc);
                        fileScript = File.createTempFile("script", ".tmp");
                        FileUtils.copyURLToFile((URL)url, (File)fileScript);
                    }
                    catch (MalformedURLException e) {
                        local = true;
                        fileScript = new File(scriptLoc);
                    }
                    finally {
                        op.getFunctionalArgs().put("CDATA:" + script, Base64.encode(this.comressedContentOfFile(fileScript)));
                        if (!local) {
                            fileScript.delete();
                        }
                    }
                }
            }
            if (op.getFunctionality() != Functionality.PARTITION || this.clusterBy == null) continue;
            op.getFunctionalArgs().put("clusterBy", this.clusterBy);
        }
        return this.plan;
    }

    public PlanNode getCreatedPlan() {
        return this.plan;
    }

    public static TableDesc getTablesSource(String table) {
        return tablesMap.get(table);
    }

    private String getAddedFiles(String file) {
        return this.addedFiles.get(file);
    }

    protected static String removeQuotes(String str) {
        if (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    private String getUri(String source) throws UnsupportedEncodingException {
        if (!source.startsWith("ftp://")) {
            if (source.startsWith("jdbc:")) {
                source = source.substring(0, source.lastIndexOf("/") + 1) + URLEncoder.encode(source.substring(source.lastIndexOf("/") + 1), "UTF-8");
            } else if (!source.startsWith("tm:")) {
                source = new File(source).toURI().toASCIIString();
            }
        }
        return source;
    }

    public static List<String> getNodes(CommonTree tree, String ... path) {
        ArrayList<String> list = new ArrayList<String>();
        if (path.length == 0) {
            list.add(tree.getText());
            return list;
        }
        if (tree.getText().matches(path[0])) {
            String[] restPath = new String[path.length - 1];
            System.arraycopy(path, 1, restPath, 0, restPath.length);
            if (tree.getChildCount() > 0) {
                for (Object n : tree.getChildren()) {
                    CommonTree child = (CommonTree)n;
                    list.addAll(HiveQLPlanner.getNodes(child, restPath));
                }
            }
        }
        return list;
    }

    private CommonTree getSubtree(CommonTree tree, String name) throws Exception {
        for (Object child : tree.getChildren()) {
            if (!((CommonTree)child).getText().equals(name)) continue;
            return (CommonTree)child;
        }
        throw new Exception("Unkown subtree: " + name + " for tree: " + tree.toStringTree());
    }

    private String getColumn(CommonTree child) {
        if (child.getText().equals(".")) {
            String fileTable = HiveQLPlanner.getNodes(child, "\\.", "TOK_TABLE_OR_COL").get(0);
            String fileName = HiveQLPlanner.getNodes(child, "\\.").get(1);
            return fileTable + "." + fileName;
        }
        if (child.getText().equals("TOK_TABLE_OR_COL")) {
            return HiveQLPlanner.getNodes(child, "TOK_TABLE_OR_COL").get(0);
        }
        if (child.getText().equals("TOK_ALLCOLREF")) {
            return HiveQLPlanner.getNodes(child, "TOK_ALLCOLREF", "TOK_TABNAME").get(0) + "." + "*";
        }
        return child.getText();
    }

    public byte[] comressedContentOfFile(File file) {
        byte[] buffer = new byte[1024];
        byte[] compressed = null;
        try {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedOutputStream bfos = new BufferedOutputStream(bos);
            GZIPOutputStream gz = new GZIPOutputStream(bfos);
            FileInputStream in = new FileInputStream(file);
            while ((len = in.read(buffer)) > 0) {
                gz.write(buffer, 0, len);
            }
            gz.finish();
            gz.flush();
            bos.flush();
            compressed = bos.toByteArray();
            in.close();
            bos.close();
            bfos.close();
            gz.close();
        }
        catch (IOException e) {
            this.log.error("compression failed", (Throwable)e);
        }
        return compressed;
    }
}

