/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.hive.analyzer;

import gr.uoa.di.madgik.hive.HiveQLPlanner;
import gr.uoa.di.madgik.hive.plan.DataSourceNode;
import gr.uoa.di.madgik.hive.plan.Functionality;
import gr.uoa.di.madgik.hive.plan.OperatorNode;
import gr.uoa.di.madgik.hive.plan.PlanNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorAnalyzer {
    private static Logger log = LoggerFactory.getLogger((String)OperatorAnalyzer.class.getName());
    private static PlanNode plan;
    private static String source;

    public static void analyzeOperator(Operator<? extends OperatorDesc> op) throws Exception {
        if (op instanceof TableScanOperator) {
            OperatorAnalyzer.analyzeOperator((TableScanOperator)op);
        } else if (op instanceof FilterOperator) {
            OperatorAnalyzer.analyzeOperator((FilterOperator)op);
        } else if (op instanceof SelectOperator) {
            OperatorAnalyzer.analyzeOperator((SelectOperator)op);
        } else if (op instanceof FileSinkOperator) {
            OperatorAnalyzer.analyzeOperator((FileSinkOperator)op);
        } else if (op instanceof ScriptOperator) {
            OperatorAnalyzer.analyzeOperator((ScriptOperator)op);
        } else if (op instanceof ReduceSinkOperator) {
            OperatorAnalyzer.analyzeOperator((ReduceSinkOperator)op);
        } else if (op instanceof ExtractOperator) {
            OperatorAnalyzer.analyzeOperator((ExtractOperator)op);
        } else {
            log.warn("Unknown operator: " + op.getName());
            throw new Exception("Unknown operator: " + op.getName());
        }
        if (op.getChildOperators() == null) {
            return;
        }
        for (Operator ch : op.getChildOperators()) {
            OperatorAnalyzer.analyzeOperator((Operator<? extends OperatorDesc>)ch);
        }
    }

    private static void analyzeOperator(TableScanOperator op) throws Exception {
        source = ((TableScanDesc)op.getConf()).getAlias();
        HashMap<String, String> functionalArgs = new HashMap<String, String>();
        functionalArgs.put("filterMask", op.getNeededColumnIDs().toString());
        functionalArgs.put("delimiter", HiveQLPlanner.getTablesSource(source).getDelimiter());
        DataSourceNode node = new DataSourceNode(source, functionalArgs);
        ArrayList<String> colList = new ArrayList<String>();
        for (Integer i : op.getNeededColumnIDs()) {
            colList.add(((ColumnInfo)op.getSchema().getSignature().get(i)).getInternalName());
        }
        functionalArgs.put("schema", ((Object)colList).toString());
        log.debug(op.getParentOperators() + "->" + op);
        log.debug("source: " + source);
        log.debug("args: " + functionalArgs);
        plan = node;
    }

    private static void analyzeOperator(FilterOperator op) {
        HashMap<String, String> functionalArgs = new HashMap<String, String>();
        ArrayList<PlanNode> planList = new ArrayList<PlanNode>();
        planList.add(plan);
        OperatorNode node = new OperatorNode(Functionality.SELECT, functionalArgs, planList);
        try {
            functionalArgs.put("logicalExpressions", OperatorAnalyzer.getExpression(op.getSchema(), ((FilterDesc)op.getConf()).getPredicate()));
        }
        catch (Exception e) {
            log.warn("Could not extract logical expression");
        }
        ArrayList<String> colList = new ArrayList<String>();
        for (ColumnInfo columnInfo : op.getSchema().getSignature()) {
            colList.add(columnInfo.getInternalName());
        }
        functionalArgs.put("schema", ((Object)colList).toString());
        functionalArgs.put("filterMask", OperatorAnalyzer.createFilterMask(plan.getFunctionalArgs().get("schema"), ((Object)colList).toString()));
        log.debug(op.getParentOperators() + "->" + op);
        log.debug("expression: " + ((FilterDesc)op.getConf()).getPredicate().getExprString());
        log.debug("args: " + functionalArgs);
        plan = node;
    }

    private static void analyzeOperator(SelectOperator op) {
        ArrayList currColList = new ArrayList();
        for (ExprNodeDesc exprNodeDesc : ((SelectDesc)op.getConf()).getColList()) {
            currColList.add(exprNodeDesc.getCols().get(0));
        }
        String filterMask = OperatorAnalyzer.createFilterMask(plan.getFunctionalArgs().get("schema"), ((Object)currColList).toString());
        HashMap<String, String> functionalArgs = new HashMap<String, String>();
        if (filterMask != null) {
            ArrayList<PlanNode> planList = new ArrayList<PlanNode>();
            planList.add(plan);
            OperatorNode node = new OperatorNode(Functionality.SELECT, functionalArgs, planList);
            functionalArgs.put("filterMask", filterMask);
            functionalArgs.put("schema", ((Object)currColList).toString());
            plan = node;
        }
        log.debug(op.getParentOperators() + "->" + op);
        log.debug("args: " + functionalArgs);
    }

    private static void analyzeOperator(FileSinkOperator op) {
        String tableName = null;
        log.debug(op.getParentOperators() + "->" + op);
        tableName = ((FileSinkDesc)op.getConf()).getTableInfo().getTableName() != null ? ((FileSinkDesc)op.getConf()).getTableInfo().getTableName().replaceFirst("default\\.", "") : source;
        HashMap<String, String> functionalArgs = new HashMap<String, String>();
        ArrayList<PlanNode> planList = new ArrayList<PlanNode>();
        planList.add(plan);
        OperatorNode node = new OperatorNode(Functionality.DATASINK, functionalArgs, planList);
        functionalArgs.put("tableName", tableName);
        functionalArgs.put("delimiter", HiveQLPlanner.getTablesSource(tableName).getDelimiter());
        ArrayList<String> colList = new ArrayList<String>();
        for (ColumnInfo columnInfo : op.getSchema().getSignature()) {
            colList.add(columnInfo.getInternalName());
        }
        functionalArgs.put("schema", ((Object)colList).toString());
        plan = node;
        log.debug("args: " + functionalArgs);
    }

    private static void analyzeOperator(ScriptOperator op) {
        String scriptCmd = ((ScriptDesc)op.getConf()).getScriptCmd();
        String schema = "[" + ((ScriptDesc)op.getConf()).getScriptOutputInfo().getProperties().get("columns").toString().replace(",", ", ") + "]";
        HashMap<String, String> functionalArgs = new HashMap<String, String>();
        ArrayList<PlanNode> planList = new ArrayList<PlanNode>();
        planList.add(plan);
        OperatorNode node = new OperatorNode(Functionality.SCRIPT, functionalArgs, planList);
        functionalArgs.put("scriptCmd", scriptCmd);
        functionalArgs.put("schema", schema);
        plan = node;
        log.debug(op.getParentOperators() + "->" + op);
        log.debug("args: " + functionalArgs);
    }

    private static void analyzeOperator(ReduceSinkOperator op) {
        String order = ((ReduceSinkDesc)op.getConf()).getKeySerializeInfo().getProperties().getProperty("serialization.sort.order");
        ArrayList<Integer> clustCol = new ArrayList<Integer>();
        for (ExprNodeDesc exprNodeDesc : ((ReduceSinkDesc)op.getConf()).getPartitionCols()) {
            for (int i = 0; i < ((ReduceSinkDesc)op.getConf()).getValueCols().size(); ++i) {
                if (!((ExprNodeDesc)((ReduceSinkDesc)op.getConf()).getValueCols().get(i)).getExprString().equals(exprNodeDesc.getExprString())) continue;
                clustCol.add(i);
            }
        }
        PlanNode pointer = plan;
        while (!(pointer instanceof DataSourceNode) && ((OperatorNode)pointer).getFunctionality() != Functionality.SELECT) {
            pointer = ((OperatorNode)pointer).getChildren().get(0);
        }
        HashMap<String, String> partFunctionalArgs = new HashMap<String, String>();
        partFunctionalArgs.put("clusterBy", ((Object)clustCol).toString());
        partFunctionalArgs.put("schema", pointer.getFunctionalArgs().get("schema"));
        partFunctionalArgs.put("order", order);
        ArrayList<PlanNode> children = new ArrayList<PlanNode>();
        children.add(pointer);
        OperatorNode parent = pointer.getParent();
        pointer.setParent(null);
        OperatorNode partNode = new OperatorNode(Functionality.PARTITION, partFunctionalArgs, children);
        if (parent != null) {
            ArrayList<PlanNode> parentChildren = new ArrayList<PlanNode>();
            parentChildren.add(partNode);
            parent.setChildren(parentChildren);
        } else {
            pointer.setParent(partNode);
            plan = partNode;
        }
        HashMap<String, String> functionalArgs = new HashMap<String, String>();
        ArrayList<PlanNode> planList = new ArrayList<PlanNode>();
        planList.add(plan);
        OperatorNode node = new OperatorNode(Functionality.MERGE, functionalArgs, planList);
        ArrayList<String> colList = new ArrayList<String>();
        for (ColumnInfo columnInfo : op.getSchema().getSignature()) {
            colList.add(columnInfo.getInternalName());
        }
        functionalArgs.put("schema", ((Object)colList).toString());
        log.debug(op.getParentOperators() + "->" + op);
        log.debug("args: " + functionalArgs);
        plan = node;
    }

    private static void analyzeOperator(ExtractOperator op) {
        ArrayList<String> colList = new ArrayList<String>();
        for (ColumnInfo columnInfo : op.getSchema().getSignature()) {
            colList.add(columnInfo.getInternalName());
        }
        log.debug("colList: " + colList);
    }

    public static PlanNode concatPlans(PlanNode main, PlanNode exten) throws Exception {
        LinkedList<OperatorNode> operList = new LinkedList<OperatorNode>();
        PlanNode it = exten;
        while (!(it instanceof DataSourceNode)) {
            operList.add((OperatorNode)it);
            if (((OperatorNode)it).getChildren().size() > 1) {
                log.warn("Unexpected insert query: plan has multiple branches");
                throw new Exception("Unexpected insert query: plan has multiple branches");
            }
            it = ((OperatorNode)it).getChildren().get(0);
        }
        if (!((DataSourceNode)it).getSource().equals(((OperatorNode)main).getFunctionalArgs().get("tableName"))) {
            log.warn("Unexpected insert query: plan has multiple branches");
            throw new Exception("plans can not be concatenated");
        }
        HashMap<String, String> functionalArgs = new HashMap<String, String>();
        functionalArgs.put("schema", it.getFunctionalArgs().get("schema"));
        functionalArgs.put("filterMask", it.getFunctionalArgs().get("filterMask"));
        OperatorNode select = new OperatorNode(Functionality.SELECT, functionalArgs, null);
        operList.add(select);
        while (!operList.isEmpty()) {
            OperatorNode last = (OperatorNode)operList.removeLast();
            last.setChildren(((OperatorNode)main).getChildren());
            ArrayList<PlanNode> children = new ArrayList<PlanNode>();
            children.add(last);
            ((OperatorNode)main).setChildren(children);
        }
        main.getFunctionalArgs().put("schema", ((OperatorNode)main).getChildren().get(0).getFunctionalArgs().get("schema") != null ? ((OperatorNode)main).getChildren().get(0).getFunctionalArgs().get("schema") : main.getFunctionalArgs().get("schema"));
        return main;
    }

    public static PlanNode optimizePlan(PlanNode node) {
        int i;
        int maxTries = 5;
        int hash = node.hashCode();
        for (i = 0; i < maxTries; ++i) {
            log.debug("Optimization pass: " + i);
            node = OperatorAnalyzer.optimizationPassPlan(node);
            if (node.hashCode() == hash) break;
            hash = node.hashCode();
        }
        if (i == maxTries) {
            log.warn("Reached maximum (" + i + ") tries of optimization passes");
        }
        return node;
    }

    private static PlanNode optimizationPassPlan(PlanNode node) {
        LinkedList<OperatorNode> operList = OperatorAnalyzer.getAllOperators(node);
        while (!operList.isEmpty()) {
            ArrayList<String> newSchemaList;
            ArrayList<String> chSchemarList;
            ArrayList<String> newFilterList;
            ArrayList<String> opFilterList;
            ArrayList<String> chFilterList;
            OperatorNode op = operList.removeLast();
            if (op.getFunctionality() != Functionality.SELECT || op.getChildren().size() != 1) continue;
            PlanNode ch = op.getChildren().get(0);
            if (ch instanceof DataSourceNode) {
                if (!op.getFunctionalArgs().containsKey("filterMask") || op.getFunctionalArgs().containsKey("logicalExpressions")) continue;
                chFilterList = OperatorAnalyzer.getList(ch.getFunctionalArgs().get("filterMask"));
                opFilterList = OperatorAnalyzer.getList(op.getFunctionalArgs().get("filterMask"));
                newFilterList = new ArrayList<String>();
                for (String str : opFilterList) {
                    newFilterList.add(chFilterList.get(Integer.parseInt(str)));
                }
                chSchemarList = OperatorAnalyzer.getList(ch.getFunctionalArgs().get("schema"));
                newSchemaList = new ArrayList<String>();
                for (String str : opFilterList) {
                    newSchemaList.add(chSchemarList.get(Integer.parseInt(str)));
                }
                ch.getFunctionalArgs().put("filterMask", newFilterList.toString());
                ch.getFunctionalArgs().put("schema", newSchemaList.toString());
                if (op.getFunctionalArgs().containsKey("logicalExpressions")) {
                    op.getFunctionalArgs().remove("filterMask");
                    continue;
                }
                if (op.getParent() == null) continue;
                op.getParent().getChildren().remove(op);
                op.getParent().addChild(ch);
                operList.remove(op);
                continue;
            }
            if (!(ch instanceof OperatorNode) || ((OperatorNode)ch).getFunctionality() != Functionality.SELECT || op.getFunctionalArgs().containsKey("logicalExpressions")) continue;
            if (ch.getFunctionalArgs().containsKey("logicalExpressions")) {
                op.getFunctionalArgs().put("logicalExpressions", ch.getFunctionalArgs().get("logicalExpressions"));
                if (ch.getFunctionalArgs().containsKey("filterMask")) {
                    chFilterList = OperatorAnalyzer.getList(ch.getFunctionalArgs().get("filterMask"));
                    opFilterList = OperatorAnalyzer.getList(op.getFunctionalArgs().get("filterMask"));
                    newFilterList = new ArrayList();
                    for (String str : opFilterList) {
                        newFilterList.add(chFilterList.get(Integer.parseInt(str)));
                    }
                    op.getFunctionalArgs().put("filterMask", newFilterList.toString());
                    chSchemarList = OperatorAnalyzer.getList(ch.getFunctionalArgs().get("schema"));
                    newSchemaList = new ArrayList();
                    for (String str : opFilterList) {
                        newSchemaList.add(chSchemarList.get(Integer.parseInt(str)));
                    }
                    op.getFunctionalArgs().put("schema", newSchemaList.toString());
                }
                op.setChildren(((OperatorNode)ch).getChildren());
                operList.remove((OperatorNode)ch);
                continue;
            }
            ArrayList<String> prevFilterList = OperatorAnalyzer.getList(ch.getFunctionalArgs().get("filterMask"));
            ArrayList<String> currFilterList = OperatorAnalyzer.getList(op.getFunctionalArgs().get("filterMask"));
            newFilterList = new ArrayList();
            for (String str : currFilterList) {
                newFilterList.add(prevFilterList.get(Integer.parseInt(str)));
            }
            op.getFunctionalArgs().put("filterMask", newFilterList.toString());
            op.setChildren(((OperatorNode)ch).getChildren());
            operList.remove((OperatorNode)ch);
        }
        return node;
    }

    private static LinkedList<OperatorNode> getAllOperators(PlanNode node) {
        LinkedList<OperatorNode> operList = new LinkedList<OperatorNode>();
        if (!(node instanceof DataSourceNode)) {
            operList.add((OperatorNode)node);
            for (PlanNode ch : ((OperatorNode)node).getChildren()) {
                operList.addAll(OperatorAnalyzer.getAllOperators(ch));
            }
        }
        return operList;
    }

    private static String getExpression(RowSchema rowSchema, ExprNodeDesc exprNodeDesc) throws Exception {
        if (exprNodeDesc instanceof ExprNodeColumnDesc) {
            ColumnInfo columnInfo;
            String col = ((ExprNodeColumnDesc)exprNodeDesc).getColumn();
            int i = 0;
            Iterator i$ = rowSchema.getSignature().iterator();
            while (i$.hasNext() && !(columnInfo = (ColumnInfo)i$.next()).getInternalName().equals(col)) {
                ++i;
            }
            return "[" + i + "]";
        }
        if (exprNodeDesc instanceof ExprNodeConstantDesc) {
            String value = ((ExprNodeConstantDesc)exprNodeDesc).getValue().toString();
            return value.matches("\\d+") ? value : "'" + ((ExprNodeConstantDesc)exprNodeDesc).getValue() + "'";
        }
        if (exprNodeDesc instanceof ExprNodeGenericFuncDesc) {
            String[] childrenExprStrings = new String[exprNodeDesc.getChildren().size()];
            for (int i = 0; i < childrenExprStrings.length; ++i) {
                childrenExprStrings[i] = OperatorAnalyzer.getExpression(rowSchema, (ExprNodeDesc)exprNodeDesc.getChildren().get(i));
            }
            return ((ExprNodeGenericFuncDesc)exprNodeDesc).getGenericUDF().getDisplayString(childrenExprStrings);
        }
        log.warn("Unknown expression" + exprNodeDesc);
        throw new Exception("Unknown expression" + exprNodeDesc);
    }

    private static String createFilterMask(String prevSchema, String currSchema) {
        String[] nextSchemaArr;
        if (Arrays.equals(prevSchema.split(",\\s*"), currSchema.split(",\\s*"))) {
            ArrayList<Integer> filterMask = new ArrayList<Integer>();
            for (int i = 0; i < currSchema.split(",\\s*").length; ++i) {
                filterMask.add(i);
            }
            return filterMask.toString();
        }
        ArrayList<Integer> filterMask = new ArrayList<Integer>();
        ArrayList<String> currSchemaList = OperatorAnalyzer.getList(prevSchema);
        currSchema = currSchema.substring(1, currSchema.length() - 1);
        for (String str : nextSchemaArr = currSchema.split(",\\s*")) {
            filterMask.add(currSchemaList.indexOf(str));
        }
        return filterMask.toString();
    }

    private static ArrayList<String> getList(String strList) {
        strList = strList.substring(1, strList.length() - 1);
        ArrayList<String> list = new ArrayList<String>();
        for (String str : strList.split(",\\s*")) {
            list.add(str);
        }
        return list;
    }

    public static PlanNode getPlan() {
        return plan;
    }
}

