/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.harvestersettingsmanager.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.xml.transform.TransformerException;
import org.gcube.application.framework.core.genericresources.model.ISGenericResource;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.RuntimeResource;
import org.gcube.application.framework.harvesting.common.db.tools.DBConstants;
import org.gcube.application.framework.harvesting.common.db.tools.SourcePropsTools;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBProps;
import org.gcube.common.database.is.ISDatabaseProvider;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.portlets.admin.harvestersettingsmanager.client.rpc.InformationExchanger;
import org.gcube.portlets.admin.harvestersettingsmanager.server.datasource.ElementGenerator;
import org.gcube.portlets.admin.harvestersettingsmanager.shared.DBSourceP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class InformationExchangerImpl
extends RemoteServiceServlet
implements InformationExchanger {
    private static final long serialVersionUID = -8289746397108763902L;
    private static final Logger logger = LoggerFactory.getLogger(InformationExchangerImpl.class);

    public void init() throws ServletException {
        super.init();
    }

    public boolean updateGenericOnIS(String genResName, String dbName, String typeName, String body) throws Exception {
        org.gcube.application.framework.core.util.GenericResource genRes = new org.gcube.application.framework.core.util.GenericResource(this.getASLsession());
        List resources = null;
        try {
            resources = genRes.getGenericResourcesByType(typeName);
            for (ISGenericResource resource : resources) {
                if (!resource.getName().equals(genResName) || !SourcePropsTools.parseSourceProps((String)resource.getBody()).getSourceName().equals(dbName)) continue;
                resource.setBody(body);
                genRes.updateGenericResourceByID(resource);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean removeGenericFromIS(String genResName, String dbName, String typeName) throws Exception {
        org.gcube.application.framework.core.util.GenericResource genRes = new org.gcube.application.framework.core.util.GenericResource(this.getASLsession());
        List resources = null;
        try {
            resources = genRes.getGenericResourcesByType(typeName);
            for (ISGenericResource resource : resources) {
                if (!resource.getName().equals(genResName) || !SourcePropsTools.parseSourceProps((String)resource.getBody()).getSourceName().equals(dbName)) continue;
                genRes.removeGenericResource(resource);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String createGenericOnIS(String name, String typeName, String body) {
        ISGenericResource res = new ISGenericResource("", name, "Holds within body information used by ASL Harvesters", body, typeName);
        org.gcube.application.framework.core.util.GenericResource genRes = new org.gcube.application.framework.core.util.GenericResource(this.getASLsession());
        try {
            return genRes.createGenericResource(res);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBodyByName(String name) {
        List allRes;
        org.gcube.application.framework.core.util.GenericResource genRes = new org.gcube.application.framework.core.util.GenericResource(this.getASLsession());
        try {
            allRes = genRes.getGenericResourceByName(name);
            if (allRes.size() == 0) {
                return null;
            }
        }
        catch (RemoteException e) {
            return null;
        }
        return ((ISGenericResource)allRes.get(0)).getBody();
    }

    public String getBodyByType(String type) throws TransformerException {
        List allRes;
        org.gcube.application.framework.core.util.GenericResource genRes = new org.gcube.application.framework.core.util.GenericResource(this.getASLsession());
        try {
            allRes = genRes.getAllGenericResources();
        }
        catch (RemoteException e) {
            return null;
        }
        for (GenericResource res : allRes) {
            if (!res.profile().type().equalsIgnoreCase(type)) continue;
            System.out.println("Name: " + res.profile().name() + "\tType: " + res.profile().type());
            return ElementGenerator.domToXML((Element)res.profile().body());
        }
        return null;
    }

    public String[] getPropsNames(String dbName) throws Exception {
        ArrayList<String> output = new ArrayList<String>();
        org.gcube.application.framework.core.util.GenericResource genRes = new org.gcube.application.framework.core.util.GenericResource(this.getASLsession());
        List allRes = genRes.getGenericResourcesByType("HarvesterProps");
        for (ISGenericResource resource : allRes) {
            DBProps props = SourcePropsTools.parseSourceProps((String)resource.getBody());
            if (!props.getSourceName().equalsIgnoreCase(dbName)) continue;
            output.add(props.getPropsName());
        }
        return output.toArray(new String[0]);
    }

    public String getDBPropsByName(String dbName, String propsName) throws Exception {
        List allRes;
        org.gcube.application.framework.core.util.GenericResource genRes = new org.gcube.application.framework.core.util.GenericResource(this.getASLsession());
        try {
            allRes = genRes.getGenericResourcesByType("HarvesterProps");
        }
        catch (RemoteException e) {
            return null;
        }
        String result = new String();
        for (ISGenericResource res : allRes) {
            DBProps props = SourcePropsTools.parseSourceProps((String)res.getBody());
            if (!res.getName().equals(propsName) || !props.getSourceName().equals(dbName)) continue;
            System.out.println("propsName: " + res.getName() + "\tdbName: " + props.getSourceName());
            result = res.getBody();
        }
        return result;
    }

    private ASLSession getASLsession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session;
    }

    public String[] getDBTypes() {
        return DBConstants.getDBTypes();
    }

    public DBSourceP[] getDBSourcesInfo() throws MalformedURLException {
        System.out.println("GETTING DBSOURCES INFO");
        RuntimeResource runResource = new RuntimeResource(this.getASLsession());
        ArrayList<DBSourceP> lst = new ArrayList<DBSourceP>();
        ISDatabaseProvider isDBProvider = new ISDatabaseProvider();
        ScopeProvider.instance.set(this.getASLsession().getScope());
        for (ServiceEndpoint se : runResource.getRuntimeResourceByCategory("Database")) {
            System.out.println("Getting props of : " + se.profile().name());
            DBSourceP dbSource = new DBSourceP();
            dbSource.setSourceName(se.profile().name());
            dbSource.setDBType(se.profile().platform().name());
            dbSource.setHostName(se.profile().runtime().hostedOn());
            dbSource.setVersionMajor((int)se.profile().platform().version());
            dbSource.setVersionMinor((int)se.profile().platform().minorVersion().shortValue());
            lst.add(dbSource);
        }
        return lst.toArray(new DBSourceP[0]);
    }

    public String createDBSourceInfo(DBSourceP dbSource) {
        ServiceEndpoint se = new ServiceEndpoint();
        se.newProfile();
        se.profile().name(dbSource.getSourceName());
        se.profile().category("Database");
        se.profile().description("For use by ASL harvesters");
        se.profile().version("1");
        se.profile().newRuntime();
        se.profile().runtime().hostedOn(dbSource.getHostName());
        se.profile().runtime().ghnId("-");
        se.profile().runtime().status("READY");
        se.profile().newPlatform();
        se.profile().platform().name(dbSource.getDBType());
        se.profile().platform().buildVersion(Short.parseShort("0"));
        se.profile().platform().revisionVersion(Short.parseShort("0"));
        se.profile().platform().version((short)dbSource.getVersionMajor());
        se.profile().platform().minorVersion((short)dbSource.getVersionMinor());
        RuntimeResource runResource = new RuntimeResource(this.getASLsession());
        try {
            runResource.createRuntimeResource(se);
        }
        catch (RegistryNotFoundException e) {
            return "Could not create the DB source info on IS. ";
        }
        return "Created resource on IS";
    }

    public String updateDBSourceInfo(DBSourceP dbInfo) {
        RuntimeResource runResource = new RuntimeResource(this.getASLsession());
        for (ServiceEndpoint se : runResource.getRuntimeResourceByCategory("Database")) {
            if (!se.profile().name().equals(dbInfo.getSourceName())) continue;
            se.profile().name(dbInfo.getSourceName());
            se.profile().category("Database");
            se.profile().runtime().hostedOn(dbInfo.getHostName());
            se.profile().platform().name(dbInfo.getDBType());
            se.profile().platform().version(Short.parseShort(String.valueOf(dbInfo.getVersionMajor())));
            se.profile().platform().minorVersion(Short.parseShort(String.valueOf(dbInfo.getVersionMinor())));
            ServiceEndpoint.AccessPoint ap = new ServiceEndpoint.AccessPoint();
            ap.credentials(dbInfo.getPassword(), dbInfo.getUserName());
            se.profile().accessPoints().clear();
            se.profile().accessPoints().add((Object)ap);
            try {
                runResource.updateRuntimeResource(se);
            }
            catch (RemoteException e) {
                return "Could not update the DB source info on IS";
            }
        }
        return "Updated resource on IS";
    }

    public String deleteDBSourceInfo(DBSourceP dbInfo) {
        RuntimeResource runResource = new RuntimeResource(this.getASLsession());
        for (ServiceEndpoint se : runResource.getRuntimeResourceByCategory("Database")) {
            if (!se.profile().name().equals(dbInfo.getSourceName())) continue;
            try {
                runResource.deleteRuntimeResource(se);
            }
            catch (RemoteException e) {
                return "Could not delete the DB source info from the IS";
            }
        }
        return "Deleted resource from IS";
    }
}

