package org.gcube.portlets.admin.harvestersettingsmanager.client.tools;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

public class InputBox extends DialogBox {

	public TextBox textBox = new TextBox();
	
	public InputBox(String title, String text) {
		
		super(false, false);
		setTitle(title);
		setText(title);
		setAnimationEnabled(true);
		setGlassEnabled(true);

		Button ok = new Button("Ok");
		ok.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				InputBox.this.hide();
			}
		});

		Button cancel = new Button("Cancel");
		cancel.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				textBox.setText("");
				InputBox.this.hide();
			}
		});

		VerticalPanel vp = new VerticalPanel();	
		HorizontalPanel hp = new HorizontalPanel();
		
		vp.add(textBox);
		hp.add(ok);
		hp.add(cancel);
		vp.add(hp);
		setWidget(vp);
		
		this.center();
		this.show();
	}

}
