package org.gcube.portlets.admin.harvestersettingsmanager.client.tools;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

public class ConfirmationDialog extends DialogBox {
	
	private Label textLabel;
	private Hidden response;
	
	public ConfirmationDialog(String title, String text) {
		
		super(false, false);
		setTitle(title);
		textLabel =  new Label(text);
		response = new Hidden();
		response.setVisible(false);
		setAnimationEnabled(true);
		setGlassEnabled(true);

		Button yes = new Button("Yes");
		yes.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				response.setValue("yes");
				ConfirmationDialog.this.hide();
			}
		});

		Button no = new Button("No");
		no.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				response.setValue("no");
				ConfirmationDialog.this.hide();
			}
		});

		VerticalPanel vp = new VerticalPanel();	
		HorizontalPanel hp = new HorizontalPanel();
		
		vp.add(textLabel);
		vp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
		vp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		hp.add(yes);
		hp.add(no);
		vp.add(hp);
		hp.setCellHorizontalAlignment(yes, HasHorizontalAlignment.ALIGN_LEFT);
		hp.setCellHorizontalAlignment(no, HasHorizontalAlignment.ALIGN_RIGHT);
		setWidget(vp);
		
		this.center();
		this.show();
	}
	
	
	public String getResponse(){
		return response.getValue();
	}
	
	
}
