
package org.gcube.portlets.admin.harvestersettingsmanager.client.rpc;




import org.gcube.portlets.admin.harvestersettingsmanager.shared.DBSourceP;

import com.google.gwt.user.client.rpc.AsyncCallback;


public interface InformationExchangerAsync {
	
	public void updateGenericOnIS(String genResName, String dbName, String typeName, String body, AsyncCallback<Boolean> callback);
	
	public void createGenericOnIS(String name, String typeName, String body, AsyncCallback<String> callback);
	
	public void removeGenericFromIS(String genResName, String dbName, String typeName, AsyncCallback<Boolean> callback);
	
	public void getBodyByName(String name, AsyncCallback<String> callback);
	
	public void getBodyByType(String type, AsyncCallback<String> callback);
	
	public void getDBPropsByName(String dbName, String propsName, AsyncCallback <String> callback);

//	public void prettyFormat(String input, AsyncCallback <String> callback);
	
	public void getPropsNames(String dbName, AsyncCallback<String[]> callback);
	
	public void getDBTypes(AsyncCallback<String[]> callback);

	public void getDBSourcesInfo(AsyncCallback<DBSourceP[]> callback);
	
	public void createDBSourceInfo(DBSourceP dbInfo, AsyncCallback<String> callback);
	
	public void updateDBSourceInfo(DBSourceP dbInfo, AsyncCallback<String> callback);
	
	public void deleteDBSourceInfo(DBSourceP dbInfo, AsyncCallback<String> callback);
	
}
