package org.gcube.portlets.admin.harvestersettingsmanager.client;



import org.gcube.portlets.admin.harvestersettingsmanager.client.tools.Tools;
import org.gcube.portlets.admin.harvestersettingsmanager.shared.DBSourceP;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.gwtext.client.widgets.MessageBox;

public class DBResourcesPanel extends VerticalPanel{
	
	private static DBSourceP[] dbInfos;
	
	VerticalPanel verticalPanel = new VerticalPanel();
	HorizontalPanel horizontalPanelUpper = new HorizontalPanel();
	Label lblSources = new Label("Available DB Sources: ");
	final ListBox dbSources = new ListBox();
	Button createSource = new Button("Create new");
	DBResourcesInfoPanel dbResourcesInfoPanel = new DBResourcesInfoPanel();
	HorizontalPanel horizontalPanelLower = new HorizontalPanel();

	
	public DBResourcesPanel() {
		
		
		horizontalPanelUpper.add(lblSources);
		horizontalPanelUpper.add(dbSources);
		horizontalPanelUpper.add(createSource);
		verticalPanel.add(horizontalPanelUpper);
		
		verticalPanel.add(dbResourcesInfoPanel);
		
		Button saveButton = new Button("Save");
		Button deleteButton = new Button("Delete");
		horizontalPanelLower.add(saveButton);
		horizontalPanelLower.add(deleteButton);
		verticalPanel.add(horizontalPanelLower);
		
		this.add(verticalPanel);
		
		MessageBox.alert("Experimental, use with care!");
		
		//load all the available db sources from the IS
		HarvesterSettingsManager.info.getDBSourcesInfo(new AsyncCallback<DBSourceP[]>() {
			public void onFailure(Throwable caught) {
				Tools.consoleLog("FAILED TO RETRIEVE THE DB INFO STORED ON I.S.");
			}
			public void onSuccess(DBSourceP[] result) {
				dbInfos = result;
				refreshSourcesDroplist();
			}
		});
		
		
		createSource.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				new DBResourcesCreatePanel();
			}
		});
		
		saveButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				HarvesterSettingsManager.info.updateDBSourceInfo(dbResourcesInfoPanel.getDBSource(), new AsyncCallback<String>() {
					public void onFailure(Throwable caught) {
						MessageBox.alert("","A problem occured upon the communication with the server. Resource not updated");
					}
					public void onSuccess(String result) {
						MessageBox.alert("",result);
					}
				});
			}
		});
		
		deleteButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				HarvesterSettingsManager.info.deleteDBSourceInfo(dbResourcesInfoPanel.getDBSource(), new AsyncCallback<String>() {
					public void onFailure(Throwable caught) {
						MessageBox.alert("","A problem occured upon the communication with the server. Resource not deleted");
					}
					public void onSuccess(String result) {
						MessageBox.alert("",result);
					}
				});
			}
		});
		
		
		
	}
	
	public void refreshSourcesDroplist(){
		dbSources.clear();
		for(DBSourceP dbInfo : dbInfos)
			dbSources.addItem(dbInfo.getSourceName(), dbInfo.getSourceName());
		dbSources.setSelectedIndex(-1);
	}
	

}
