package org.gcube.portlets.admin.harvestersettingsmanager.client;

import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBSource;
import org.gcube.portlets.admin.harvestersettingsmanager.client.tools.Tools;
import org.gcube.portlets.admin.harvestersettingsmanager.shared.DBSourceP;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.IntegerBox;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.PasswordTextBox;

public class DBResourcesInfoPanel extends VerticalPanel{
	
	TextBox dbName = new TextBox();
	ListBox dbType = new ListBox();
	IntegerBox majorVersion = new IntegerBox();
	IntegerBox minorVersion = new IntegerBox();
	TextBox username = new TextBox();
	PasswordTextBox password = new PasswordTextBox();
	TextBox hostName = new TextBox();
	
	public DBResourcesInfoPanel() {
		setSize("0", "0");
		
		CaptionPanel cptnpnlDbinfo = new CaptionPanel("DBInfo");
		add(cptnpnlDbinfo);
		
		VerticalPanel verticalPanel = new VerticalPanel();
		cptnpnlDbinfo.setContentWidget(verticalPanel);
		verticalPanel.setSize("5cm", "3cm");
		
		HorizontalPanel horizontalPanel = new HorizontalPanel();
		verticalPanel.add(horizontalPanel);
		
		Label lblDatabaseName = new Label("Database Name: ");
		lblDatabaseName.setWordWrap(false);
		horizontalPanel.add(lblDatabaseName);
		lblDatabaseName.setSize("154px", "18px");
		
		horizontalPanel.add(dbName);
		
		HorizontalPanel horizontalPanel_1 = new HorizontalPanel();
		verticalPanel.add(horizontalPanel_1);
		
		Label lblDatabaseType = new Label("Database Type: ");
		lblDatabaseType.setWordWrap(false);
		horizontalPanel_1.add(lblDatabaseType);
		lblDatabaseType.setSize("160px", "16px");
		
		horizontalPanel_1.add(dbType);
		dbType.setSize("103px", "22px");
		
		HorizontalPanel horizontalPanel_2 = new HorizontalPanel();
		verticalPanel.add(horizontalPanel_2);
		
		Label lblVersion = new Label("Version: ");
		horizontalPanel_2.add(lblVersion);
		lblVersion.setSize("141px", "19px");
		
		majorVersion.setVisibleLength(2);
		horizontalPanel_2.add(majorVersion);
		
		InlineLabel inlineLabel = new InlineLabel(".");
		horizontalPanel_2.add(inlineLabel);

		minorVersion.setVisibleLength(2);
		horizontalPanel_2.add(minorVersion);
		
		HorizontalPanel horizontalPanel_5 = new HorizontalPanel();
		verticalPanel.add(horizontalPanel_5);
		
		Label lblHostname = new Label("Hostname:  ");
		lblHostname.setWordWrap(false);
		horizontalPanel_5.add(lblHostname);
		lblHostname.setWidth("150px");
		
		horizontalPanel_5.add(hostName);
		
		HorizontalPanel horizontalPanel_3 = new HorizontalPanel();
		verticalPanel.add(horizontalPanel_3);
		
		Label lblUsername = new Label("Username: ");
		lblUsername.setWordWrap(false);
		horizontalPanel_3.add(lblUsername);
		
		horizontalPanel_3.add(username);
		
		HorizontalPanel horizontalPanel_4 = new HorizontalPanel();
		verticalPanel.add(horizontalPanel_4);
		
		Label nlnlblPassword = new Label("Password: ");
		nlnlblPassword.setWordWrap(false);
		horizontalPanel_4.add(nlnlblPassword);
		
		horizontalPanel_4.add(password);

		HarvesterSettingsManager.info.getDBTypes(new AsyncCallback<String[]>() {
			
			public void onSuccess(String[] result) {
				for(String r : result)
					dbType.addItem(r,r);
			}
			
			public void onFailure(Throwable caught) {
				Tools.consoleLog("FAILED TO RETRIEVE THE DBTYPES");
			}
		});
		
	}
	
	public DBSourceP getDBSource(){
		DBSourceP dbSource = new DBSourceP();
		dbSource.setDBType(dbType.getItemText(dbType.getSelectedIndex()));
		dbSource.setHostName(hostName.getValue());
		dbSource.setSourceName(dbName.getValue());
		dbSource.setPassword(password.getValue());
		dbSource.setUserName(username.getValue());
		dbSource.setVersionMajor(Integer.parseInt(majorVersion.getText()));
		dbSource.setVersionMinor(Integer.parseInt(minorVersion.getText()));
		return dbSource;
	}
	
	
}
