package org.gcube.portlets.admin.harvestersettingsmanager.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.gwtext.client.widgets.MessageBox;

public class DBResourcesCreatePanel extends DialogBox {

	DBResourcesInfoPanel dbResourcesInfoPanel = new DBResourcesInfoPanel();
	Button create = new Button("Create");
//	Button clear = new Button("Clear data");
	Button cancel = new Button("Cancel");
	
	public DBResourcesCreatePanel() {
		
		VerticalPanel verticalPanel = new VerticalPanel();
		HorizontalPanel horizontalPanelLower = new HorizontalPanel();
		verticalPanel.add(dbResourcesInfoPanel);
		horizontalPanelLower.add(create);
//		horizontalPanelLower.add(clear);
		horizontalPanelLower.add(cancel);
		verticalPanel.add(horizontalPanelLower);
		this.add(verticalPanel);
		setProperties();
		
		
		create.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				HarvesterSettingsManager.info.createDBSourceInfo(dbResourcesInfoPanel.getDBSource(), new AsyncCallback<String>() {
					public void onSuccess(String result) {
						MessageBox.alert("",result);
					}
					
					public void onFailure(Throwable caught) {
						MessageBox.alert("","A problem occured upon the communication with the server. Resource not created.");
					}
				});
			}
		});
		
		
		cancel.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				DBResourcesCreatePanel.this.removeFromParent();
			}
		});
		
	}
	
	public void setProperties(){
		 this.setGlassEnabled(true);
		 this.setAnimationEnabled(true);
		 this.center();
		 this.setModal(false);
		 this.show();
	}
	
	
}
