package org.gcube.portlets.admin.harvestersettingsmanager.client;

import java.util.ArrayList;

import org.gcube.portlets.admin.harvestersettingsmanager.client.tools.ConfirmationDialog;
import org.gcube.portlets.admin.harvestersettingsmanager.client.tools.InputBox;
import org.gcube.portlets.admin.harvestersettingsmanager.client.tools.Tools;
import org.gcube.portlets.admin.harvestersettingsmanager.shared.DBSourceP;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.logging.client.DefaultLevel.Info;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.RichTextArea;
import com.gwtext.client.widgets.MessageBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;

public class DBPropsPanel extends VerticalPanel{
	
	private final Button dbSaveProps = new Button("Save DB Props");
	private final RichTextArea dbProps  = new RichTextArea();
	private boolean initialXMLEmpty;
	private ListBox dbSources = new ListBox();
	private final HorizontalPanel horizontalPanel_1 = new HorizontalPanel();
	private final Label lblConfiguration = new Label("Configuration: ");
	private final ListBox configurations = new ListBox();
	private final Button dbNewProps = new Button("Create new configuration");
	private final Button dbDelProps = new Button("Remove configuration");
	
	
	private final String GENERIC_CATEGORY_NAME = "HarvesterProps";
	
	public DBPropsPanel(){
		this.setSize("800px", "535px");
		dbNewProps.setEnabled(false);
		dbDelProps.setEnabled(false);
		
		HorizontalPanel horizontalPanel = new HorizontalPanel();
		add(horizontalPanel);
		
		Label lblSources = new Label("Available DB Sources: ");
		horizontalPanel.add(lblSources);
		
		dbSources.setSize("112px", "23px");
		horizontalPanel.add(dbSources);
		
		add(horizontalPanel_1);
		
		horizontalPanel_1.add(lblConfiguration);
		horizontalPanel_1.add(configurations);
		horizontalPanel_1.add(dbNewProps);
		horizontalPanel_1.add(dbDelProps);
		
		this.add(dbProps);
		dbProps.setSize("800px", "500px");
		this.add(dbSaveProps);
//		dbSaveSettings.setSize("100px", "30px");
		this.setVisible(true);
		
		dbSources.setSelectedIndex(-1);
		
		HarvesterSettingsManager.info.getDBSourcesInfo(new AsyncCallback<DBSourceP[]>() {

			public void onFailure(Throwable caught) {
				Tools.consoleLog(caught.getMessage());
				//print a popup message 
				MessageBox.alert("Server error","Could not retrieve the available databases from server\n"+caught.getMessage());
			}

			public void onSuccess(DBSourceP[] results) {
				Tools.consoleLog("Available number of databases on this scope: "+results.length);
				for(DBSourceP db : results)
					dbSources.addItem(db.getSourceName(),db.getSourceName());
				dbSources.setSelectedIndex(-1);
//				dbNewProps.setEnabled(true);
//				dbDelProps.setEnabled(true);
			}
		});
		
		
		dbSources.addChangeHandler(new ChangeHandler() {
			
			public void onChange(ChangeEvent event) {
				String value = dbSources.getItemText(dbSources.getSelectedIndex());
				Tools.consoleLog("Changed to: "+value);
				//retrieve all the properties names for the selected db
				HarvesterSettingsManager.info.getPropsNames(value, new AsyncCallback<String[]>() {
					
					public void onFailure(Throwable caught) {
						Tools.consoleLog(caught.getMessage());
						MessageBox.alert("Server error","Could not retrieve the available properties for the selected database from server\n"+caught.getMessage());
						dbNewProps.setEnabled(false);
						dbDelProps.setEnabled(false);
					}

					public void onSuccess(String[] results) {
						dbProps.setText("");
						Tools.consoleLog("Available number of different properties for "+dbSources.getItemText(dbSources.getSelectedIndex())+" = "+results.length);
						if(results.length == 0)
							MessageBox.alert("Info","No properties for the selected database found. Please create new");
						configurations.clear();
						for(String name : results)
							configurations.addItem(name, name);
						configurations.setSelectedIndex(-1);
						dbNewProps.setEnabled(true);
						dbDelProps.setEnabled(true);
					}
				});
			}
		});


		dbNewProps.addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent event) {
				final InputBox box = new InputBox("New Configuration name: ", "New Configuration name: ");
				box.addCloseHandler(new CloseHandler<PopupPanel>() {
					public void onClose(CloseEvent<PopupPanel> event) {
						String config = box.textBox.getText();
						if(!config.isEmpty()){
							
							dbProps.setText(beautify(freshText(dbSources.getItemText(dbSources.getSelectedIndex()),config)));
							configurations.addItem(box.textBox.getText(), box.textBox.getText());
							for(int i=0;i<configurations.getItemCount();i++)
								if(configurations.getItemText(i).equals(box.textBox.getText()))
									configurations.setItemSelected(i, true);
							initialXMLEmpty = true;
							
//							HarvesterSettingsManager.info.prettyFormat(freshText(dbSources.getItemText(dbSources.getSelectedIndex()),config),new AsyncCallback<String>() {
//								public void onFailure(Throwable caught) {
//									MessageBox.alert("Error","Could not create new, please try again.");
//								}
//								public void onSuccess(String result) {
//									dbProps.setText(result);
//									configurations.addItem(box.textBox.getText(), box.textBox.getText());
//									for(int i=0;i<configurations.getItemCount();i++)
//										if(configurations.getItemText(i).equals(box.textBox.getText()))
//											configurations.setItemSelected(i, true);
//									initialXMLEmpty = true;
//								}
//							});
						}
					}
				});
			}
		});
		
		configurations.addChangeHandler(new ChangeHandler() {
			
			public void onChange(ChangeEvent event) {
				HarvesterSettingsManager.info.getDBPropsByName(dbSources.getItemText(dbSources.getSelectedIndex()),configurations.getItemText(configurations.getSelectedIndex()),new AsyncCallback<String>() {
					public void onFailure(Throwable caught) {
						MessageBox.alert("Error","Could not get the specified configuration from the server.");
					}

					public void onSuccess(String result) {
						dbProps.setText(beautify(result));
//						HarvesterSettingsManager.info.prettyFormat(result, new AsyncCallback<String>() {
//							public void onFailure(Throwable caught) {
//								MessageBox.alert("Error","Could not format new configuration, please try again.");
//							}
//							public void onSuccess(String result) {
//								dbProps.setText(result);
//							}
//						});
						Tools.consoleLog("Successfully retrieved configuration");
					}
				});
				
			}
		});
		
		dbDelProps.addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent event) {
				final String itemName = configurations.getItemText(configurations.getSelectedIndex());
				final ConfirmationDialog cd = new ConfirmationDialog("Confirm deletion", "Are you sure you want to delete configuration of '"+itemName+"' ?");
				cd.addCloseHandler(new CloseHandler<PopupPanel>() {
					public void onClose(CloseEvent<PopupPanel> event) {
						if(cd.getResponse().equalsIgnoreCase("yes")){
							HarvesterSettingsManager.info.removeGenericFromIS(itemName, dbSources.getItemText(dbSources.getSelectedIndex()), GENERIC_CATEGORY_NAME, new AsyncCallback<Boolean>(){

								public void onFailure(Throwable caught) {
									MessageBox.alert("Server error","Could not send the command to the server: "+caught.getMessage());
									Tools.consoleLog(caught.getMessage());
								}
								public void onSuccess(Boolean result) {
									if(result.booleanValue())
										MessageBox.alert("Result","Successfully removed the settings from the IS!");
									else
										MessageBox.alert("Result","Could not delete the settings from the IS!");
								}
								
							});
//							Tools.consoleLog("Deleting component "+itemName);
						}

					}
				});
			}
		});
		
		
//		HarvesterSettingsManager.info.getBodyByName("DBHarvestInfo", new AsyncCallback<String>() {
//			
//			public void onSuccess(String result) {
//				if((result==null)||(result.isEmpty())){
//					initialXMLEmpty = true;
//					MessageBox.alert("","No DB harvester settings found on server. Creating a new file.\n"+result);
//				}
//				else{
//					initialXMLEmpty = false;
////					dbSettings.setHTML(Tools.getHighlighted(result).toString());
////					dbSettings.getElement().setInnerHTML(Tools.getHighlighted(result).getText());
//					
////					dbSettings.setHTML(Tools.getHighlighted(result).getText());
//					dbProps.setText(result);
//					MessageBox.alert("","Loaded DB harvester settings from server");
//				}
////				Tools.consoleLog(Tools.getHighlighted(result).getText());
//			}
//			
//			public void onFailure(Throwable caught) {
//				Tools.consoleLog(caught.getMessage());
//				//print a popup message 
//				MessageBox.alert("Server error","Could not retrieve the settings from server\n"+caught.getMessage());
//				//and disable the text editor
//				dbProps.setEnabled(false);
//			}
//		});
		
		dbSaveProps.addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent event) {
				if(initialXMLEmpty){//create mode
					HarvesterSettingsManager.info.createGenericOnIS(configurations.getValue(configurations.getSelectedIndex()), GENERIC_CATEGORY_NAME, dbProps.getText(), new AsyncCallback<String>() {
						public void onFailure(Throwable caught) {
							Tools.consoleLog(caught.getMessage());
							MessageBox.alert("Server error","Could not send the command to the server: "+caught.getMessage());
						}
						public void onSuccess(String result) {
							MessageBox.alert("","Successfully updated the settings on server!\n");//+result);
							Tools.consoleLog(result);
							initialXMLEmpty = false;
						}
					});
				}
//				public void updateGenericOnIS(String genResName, String dbName, String typeName,  String body) throws Exception{
				else{//update mode
					HarvesterSettingsManager.info.updateGenericOnIS(configurations.getValue(configurations.getSelectedIndex()),dbSources.getItemText(dbSources.getSelectedIndex()) ,GENERIC_CATEGORY_NAME, dbProps.getText(), new AsyncCallback<Boolean>() {
						public void onFailure(Throwable caught) {
							MessageBox.alert("Server error","Could not send the command to the server: "+caught.getMessage());
							Tools.consoleLog(caught.getMessage());
						}
						public void onSuccess(Boolean result) {
							if(result.booleanValue())
								MessageBox.alert("Result","Successfully updated the settings on IS!");
							else
								MessageBox.alert("Result","Could not update the settings on IS!");
						}
					});
				}
			}
		});
	}
	
	private final static String freshText(String sourcename, String propsname){
		return "<DBProps><sourcename>"+sourcename+"</sourcename><propsname>"+propsname+"</propsname><table><name></name><sql></sql></table><table><name></name><sql></sql></table><edge><parent></parent><pkeys></pkeys><!-- if more than one, seperate them with comma --><child></child><ckeys></ckeys><!-- if more than one, seperate them with comma --></edge></DBProps>";
	}
	
	/**
	 * native javascript code to format the XML string (indentations, etc)
	 * @param xml
	 */
	private static native String beautify(String xml) /*-{
	  return $wnd.vkbeautify.xml(xml);
	}-*/;
	
	
	
}