/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gcube.data.spd.gbifplugin.search.ProductKey;
import org.gcube.data.spd.gbifplugin.search.Utils;
import org.gcube.data.spd.gbifplugin.search.query.MappingUtils;
import org.gcube.data.spd.gbifplugin.search.query.PagedQueryIterator;
import org.gcube.data.spd.gbifplugin.search.query.PagedQueryObject;
import org.gcube.data.spd.gbifplugin.search.query.QueryByIdentifier;
import org.gcube.data.spd.gbifplugin.search.query.QueryCondition;
import org.gcube.data.spd.gbifplugin.search.query.QueryType;
import org.gcube.data.spd.gbifplugin.search.query.ResultType;
import org.gcube.data.spd.model.BasisOfRecord;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OccurrenceSearch {
    private static Logger log = LoggerFactory.getLogger(OccurrenceSearch.class);
    private String baseURL;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    public OccurrenceSearch(String baseURL) {
        this.baseURL = baseURL;
    }

    public void search(ObjectWriter<OccurrencePoint> writer, String scientificName, int limit, Condition ... conditions) throws Exception {
        PagedQueryObject occurrencesQuery = new PagedQueryObject(this.baseURL, ResultType.Occurrence, limit);
        List<QueryCondition> queryConditions = Utils.elaborateConditions(conditions);
        occurrencesQuery.setConditions(QueryCondition.cond("scientificName", scientificName.replaceAll(" ", "%20")), QueryCondition.cond("hasCoordinate", "true"));
        occurrencesQuery.getConditions().addAll(queryConditions);
        this.writeElements(writer, occurrencesQuery, null);
    }

    public void searchByKey(ObjectWriter<OccurrencePoint> writer, String key, int limit) throws Exception {
        PagedQueryObject occurrencesQuery = new PagedQueryObject(this.baseURL, ResultType.Occurrence, limit);
        ProductKey productKey = Utils.elaborateProductsKey(key);
        occurrencesQuery.getConditions().addAll(productKey.getQueryCondition());
        occurrencesQuery.getConditions().add(QueryCondition.cond("hasCoordinate", "true"));
        this.writeElements(writer, occurrencesQuery, productKey.getDataset());
    }

    private void writeElements(ObjectWriter<OccurrencePoint> writer, PagedQueryObject occurrencesQuery, final DataSet dataset) {
        PagedQueryIterator<OccurrencePoint> pagedIterator = new PagedQueryIterator<OccurrencePoint>(occurrencesQuery){

            @Override
            protected OccurrencePoint getObject(Map<String, Object> mappedObject) throws Exception {
                OccurrencePoint op = OccurrenceSearch.this.retrieveElement(mappedObject);
                if (dataset != null) {
                    Calendar now = Calendar.getInstance();
                    String credits = "Biodiversity occurrence data published by: " + dataset.getDataProvider().getName() + " (Accessed through GBIF Data Portal, data.gbif.org, " + OccurrenceSearch.this.format.format(now.getTime()) + ")";
                    op.setCredits(credits);
                    op.setDataSet(dataset);
                }
                return op;
            }
        };
        try {
            while (pagedIterator.hasNext() && writer.isAlive()) {
                writer.write(pagedIterator.next());
            }
        }
        catch (Exception e) {
            log.error("error writing occurrences", (Throwable)e);
            writer.write((StreamException)new StreamBlockingException("GBIF"));
        }
    }

    public OccurrencePoint searchById(String id) throws Exception {
        QueryByIdentifier queryByIdentifier = new QueryByIdentifier(this.baseURL, id, QueryType.Occurrence);
        return this.retrieveElement(MappingUtils.getObjectMapping(queryByIdentifier.build()));
    }

    private static BasisOfRecord matchBasisOfRecord(String value) {
        if (value.equals("PRESERVED_SPECIMEN")) {
            return BasisOfRecord.PreservedSpecimen;
        }
        if (value.equals("HUMAN_OBSERVATION")) {
            return BasisOfRecord.HumanObservation;
        }
        if (value.equals("FOSSIL_SPECIMEN")) {
            return BasisOfRecord.FossilSpecimen;
        }
        if (value.equals("MACHINE_OBSERVATION")) {
            return BasisOfRecord.MachineObservation;
        }
        if (value.equals("LIVING_SPECIMEN")) {
            return BasisOfRecord.LivingSpecimen;
        }
        if (value.equals("OBSERVATION")) {
            return BasisOfRecord.Observation;
        }
        if (value.equals("MATERIAL_SAMPLE")) {
            return BasisOfRecord.MaterialSample;
        }
        if (value.equals("LITERATURE")) {
            return BasisOfRecord.Literature;
        }
        return BasisOfRecord.Unknown;
    }

    private OccurrencePoint retrieveElement(Map<String, Object> mappedObj) throws Exception {
        long start = System.currentTimeMillis();
        String occurrenceId = MappingUtils.getAsInteger(mappedObj, "key").toString();
        OccurrencePoint occurrence = new OccurrencePoint(occurrenceId);
        occurrence.setCollectionCode(MappingUtils.getAsString(mappedObj, "collectionCode"));
        occurrence.setInstitutionCode(MappingUtils.getAsString(mappedObj, "institutionCode"));
        occurrence.setCatalogueNumber(MappingUtils.getAsString(mappedObj, "catalogNumber"));
        occurrence.setRecordedBy(MappingUtils.getAsString(mappedObj, "recordedBy"));
        occurrence.setIdentifiedBy(MappingUtils.getAsString(mappedObj, "identifiedBy"));
        occurrence.setCountry(MappingUtils.getAsString(mappedObj, "country"));
        occurrence.setLocality(MappingUtils.getAsString(mappedObj, "locality"));
        Calendar eventDate = MappingUtils.getAsCalendar(mappedObj, "eventDate");
        if (eventDate == null) {
            eventDate = MappingUtils.getAsCalendar(mappedObj, "dateIdentified");
        }
        occurrence.setEventDate(eventDate);
        occurrence.setDecimalLatitude(MappingUtils.getAsDouble(mappedObj, "decimalLatitude").doubleValue());
        occurrence.setDecimalLongitude(MappingUtils.getAsDouble(mappedObj, "decimalLongitude").doubleValue());
        occurrence.setBasisOfRecord(OccurrenceSearch.matchBasisOfRecord(MappingUtils.getAsString(mappedObj, "basisOfRecord")));
        occurrence.setMinDepth(MappingUtils.getAsDouble(mappedObj, "elevation").doubleValue());
        occurrence.setMaxDepth(MappingUtils.getAsDouble(mappedObj, "depth").doubleValue());
        String taxonKey = MappingUtils.getAsInteger(mappedObj, "taxonKey").toString();
        ReducedTaxon rt = this.retrieveParentTaxon(taxonKey);
        occurrence.setKingdom(rt.getKingdom());
        occurrence.setFamily(rt.getFamily());
        QueryByIdentifier taxonQuery = new QueryByIdentifier(this.baseURL, taxonKey, QueryType.Taxon);
        Map<String, Object> taxon = MappingUtils.getObjectMapping(taxonQuery.build());
        occurrence.setScientificNameAuthorship(MappingUtils.getAsString(taxon, "authorship"));
        occurrence.setScientificName(MappingUtils.getAsString(taxon, "scientificName"));
        occurrence.setCitation(MappingUtils.getAsString(taxon, "accordingTo"));
        log.trace("[Benchmark] time to retrieve occurrence is " + (System.currentTimeMillis() - start));
        return occurrence;
    }

    private ReducedTaxon retrieveParentTaxon(String taxonId) throws Exception {
        long start = System.currentTimeMillis();
        QueryByIdentifier query = new QueryByIdentifier(this.baseURL, taxonId, QueryType.Taxon);
        query.addPath("parents");
        LinkedList<HashMap<String, Object>> parentsList = MappingUtils.getObjectList(query.build());
        ReducedTaxon taxon = new ReducedTaxon();
        for (HashMap hashMap : parentsList) {
            String rank = MappingUtils.getAsString(hashMap, "rank");
            String value = MappingUtils.getAsString(hashMap, "scientificName");
            if (rank.equalsIgnoreCase("family")) {
                taxon.setFamily(value);
            } else if (rank.equalsIgnoreCase("kingdom")) {
                taxon.setKingdom(value);
            }
            if (!taxon.isValid()) continue;
            return taxon;
        }
        log.trace("[Benchmark] time to retrieve taxon is " + (System.currentTimeMillis() - start));
        return taxon;
    }

    protected static class ReducedTaxon {
        private String family = null;
        private String kingdom = null;

        protected ReducedTaxon() {
        }

        public String getFamily() {
            return this.family;
        }

        public void setFamily(String family) {
            this.family = family;
        }

        public String getKingdom() {
            return this.kingdom;
        }

        public void setKingdom(String kingdom) {
            this.kingdom = kingdom;
        }

        public boolean isValid() {
            return this.family != null && this.kingdom != null;
        }
    }
}

