/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.is.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.soap.SOAPFaultException;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datapublishing.sdmx.is.ISReader;
import org.gcube.datapublishing.sdmx.is.InformationSystemLabelConstants;
import org.gcube.datapublishing.sdmx.is.SDMXCategoryConstants;
import org.gcube.datapublishing.sdmx.model.DataSource;
import org.gcube.datapublishing.sdmx.model.impl.DataSourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISDataSourceDataReader
extends ISReader<ServiceEndpoint.Profile>
implements InformationSystemLabelConstants,
SDMXCategoryConstants {
    private final String RESULTS = "$resource/Profile";
    private Logger logger = LoggerFactory.getLogger(ISDataSourceDataReader.class);

    public List<ServiceEndpoint.Profile> getProfiles() {
        this.logger.debug("Getting SDMX Data Sources in the current VRE");
        super.newQuery(ServiceEndpoint.class);
        super.addCondition("Category", "SDMXDataSources");
        super.setResults("$resource/Profile");
        return super.submit(ServiceEndpoint.Profile.class);
    }

    public List<DataSource> getDataSources() {
        ArrayList<DataSource> response = new ArrayList<DataSource>();
        this.logger.debug("Getting Data Sources for VRE " + ScopeProvider.instance.get());
        List<ServiceEndpoint.Profile> profiles = this.getProfiles();
        if (profiles != null) {
            for (ServiceEndpoint.Profile profile : profiles) {
                this.logger.debug("Data Source found ");
                String name = profile.name();
                this.logger.debug("VM " + name);
                Group accessPoints = profile.accessPoints();
                Iterator accessPointIterator = accessPoints.iterator();
                if (accessPointIterator.hasNext()) {
                    ServiceEndpoint.AccessPoint accessPoint = (ServiceEndpoint.AccessPoint)accessPointIterator.next();
                    String endpoint = accessPoint.address();
                    this.logger.debug("Endpoint " + endpoint);
                    response.add(new DataSourceImpl(name, endpoint));
                    continue;
                }
                this.logger.debug("Data source " + name + " does not have any access point");
            }
        } else {
            this.logger.debug("Data Sources not found");
        }
        return response;
    }

    public static void main(String[] args) {
        ScopeProvider.instance.set("/gcube/devNext/NextNext");
        try {
            List<DataSource> dataSources = new ISDataSourceDataReader().getDataSources();
            for (DataSource dataSource : dataSources) {
                System.out.println(dataSource.getName());
                System.out.println(dataSource.getEndpoint());
                System.out.println("********************");
            }
        }
        catch (RuntimeException e) {
            SOAPFaultException soap = (SOAPFaultException)e.getCause();
            System.out.println(soap.getMessage());
            System.out.println(soap.getFault());
        }
    }
}

