/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.impl.datasource;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gcube.datapublishing.sdmx.api.datasource.GCubeSDMXDatasourceClient;
import org.gcube.datapublishing.sdmx.api.model.GCubeSDMXDatasourceDescriptor;
import org.gcube.datapublishing.sdmx.impl.data.DataDocumentVersion;
import org.gcube.datapublishing.sdmx.impl.data.TimeseriesRegistration;
import org.sdmxsource.sdmx.api.constants.SDMX_ERROR_CODE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GCubeSDMXDatasourceClientImpl
implements GCubeSDMXDatasourceClient {
    private static final Logger log = LoggerFactory.getLogger(GCubeSDMXDatasourceClientImpl.class);
    private GCubeSDMXDatasourceDescriptor datasource;

    @Autowired
    public GCubeSDMXDatasourceClientImpl(GCubeSDMXDatasourceDescriptor datasource) {
        this.datasource = datasource;
    }

    @Override
    public void registerTimeseries(String flowAgencyId, String flowId, String flowVersion, String providerAgencyId, String providerId, String timeseriesId, String timeseriesServiceScope, String registryScope) throws Exception {
        TimeseriesRegistration tsr = new TimeseriesRegistration(timeseriesServiceScope, timeseriesId, flowAgencyId, flowId, flowVersion, providerAgencyId, providerId, registryScope);
        Client client = Client.create();
        String url = this.datasource.getPublishInterfaceUrl();
        client.setFollowRedirects(Boolean.valueOf(true));
        log.debug("POST " + url + ", Timeseries Registration: " + tsr);
        ClientResponse response = (ClientResponse)((WebResource.Builder)client.resource(url).accept(new String[]{"application/xml"}).type("application/xml")).post(ClientResponse.class, (Object)tsr);
        log.debug("Datasource returned: " + response);
        if (response.getStatus() != 201) {
            log.error("Received status " + response.getStatus() + " while registering timeseries on sdmx datasource. " + "Received message from server: " + (String)response.getEntity(String.class));
            throw new Exception("Error encountered while registering timeseries. Received status " + response.getStatus() + " from sdmx datasource");
        }
        TimeseriesRegistration receivedTsr = (TimeseriesRegistration)response.getEntity(TimeseriesRegistration.class);
        if (receivedTsr.equals((Object)tsr)) {
            return;
        }
        throw new Exception("Unable to register timeseries. Check sdmx datasource server log.");
    }

    @Override
    public List<TimeseriesRegistration> getTimeseriesRegistrations() throws Exception {
        Client client = Client.create();
        client.setFollowRedirects(Boolean.valueOf(true));
        ClientResponse response = (ClientResponse)client.resource(this.datasource.getPublishInterfaceUrl()).accept(new String[]{"application/xml"}).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            log.error("Received status " + response.getStatus() + " while registering timeseries on sdmx datasource. " + "Received message from server: " + (String)response.getEntity(String.class));
            throw new Exception("Error encountered while registering timeseries. Received status " + response.getStatus() + " from sdmx datasource");
        }
        return (List)response.getEntity((GenericType)new GenericType<ArrayList<TimeseriesRegistration>>(){});
    }

    @Override
    public InputStream dataQuery(String flowRef, String key, String providerRef, Integer firstNObservations, GCubeSDMXDatasourceClient.DataDetail detail, DataDocumentVersion documentVersion) throws SdmxException {
        String url;
        try {
            url = this.getRestServiceUrl(documentVersion);
        }
        catch (Exception e) {
            throw new SdmxException("Invalid Data document version provided", SDMX_ERROR_CODE.SYNTAX_ERROR);
        }
        url = url + "data/" + flowRef + "/" + key + "/" + providerRef;
        url = detail == null ? url + "?detail=" + GCubeSDMXDatasourceClient.DataDetail.full.toString() : url + "?detail=" + detail.toString();
        if (firstNObservations != null) {
            url = url + "&firstNObservation=" + firstNObservations;
        }
        Client client = Client.create();
        client.setFollowRedirects(Boolean.valueOf(true));
        WebResource resource = client.resource(url);
        String acceptType = "application/xml;version=" + documentVersion.getVersion();
        log.debug("Accepted SDMX document version: " + documentVersion.getVersion());
        log.debug("GET " + url);
        ClientResponse response = (ClientResponse)resource.accept(new String[]{acceptType}).get(ClientResponse.class);
        log.debug("Datasource returned: " + response);
        return response.getEntityInputStream();
    }

    @Override
    public void removeTimeseriesRegistration(String flowAgencyId, String flowId, String flowVersion, String providerAgencyId, String providerId) throws Exception {
        Client client = Client.create();
        String url = this.datasource.getPublishInterfaceUrl();
        url = url + flowAgencyId;
        url = url + flowId;
        url = url + flowVersion;
        url = url + providerAgencyId;
        url = url + providerId;
        log.debug("DELETE " + url);
        ClientResponse response = (ClientResponse)client.resource(url).delete(ClientResponse.class);
        log.debug("Datasource returned: " + response);
        if (response.getStatus() == 204) {
            return;
        }
        if (response.getStatus() == 404) {
            log.warn("Datasource didn't found a Timeseries Registration with the given coordinates: [flowAgencyId=" + flowAgencyId + ", flowId=" + flowId + ", flowVersion=" + flowVersion + ", providerAgencyId=" + providerAgencyId + ", providerId=" + providerId + "]");
            return;
        }
        throw new Exception("Received unmanaged HTTP status code from datasource: " + response.getStatus());
    }

    private String getRestServiceUrl(DataDocumentVersion version) throws Exception {
        switch (version) {
            case V1: {
                return this.datasource.getRest_url_V1();
            }
            case V2: {
                return this.datasource.getRest_url_V2();
            }
            case V2_1: {
                return this.datasource.getRest_url_V2_1();
            }
        }
        throw new Exception("Unable to retrieve REST URL for the given document version: " + version.toString());
    }
}

