/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.impl.model;

import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datapublishing.sdmx.api.model.GCubeSDMXDatasourceDescriptor;
import org.gcube.datapublishing.sdmx.impl.model.GCubeSDMXDatasourceDescriptorImpl;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeSDMXDatasourceDescriptorIS
implements GCubeSDMXDatasourceDescriptor {
    private static final Logger log = LoggerFactory.getLogger(GCubeSDMXDatasourceDescriptorIS.class);
    private GCubeSDMXDatasourceDescriptor delegate;
    private boolean empty = true;

    @Override
    public String getRest_url_V2_1() {
        if (this.empty) {
            this.delegate = this.retrieveDescriptor();
        }
        return this.delegate.getRest_url_V2_1();
    }

    @Override
    public String getRest_url_V2() {
        if (this.empty) {
            this.delegate = this.retrieveDescriptor();
        }
        return this.delegate.getRest_url_V2();
    }

    @Override
    public String getRest_url_V1() {
        if (this.empty) {
            this.delegate = this.retrieveDescriptor();
        }
        return this.delegate.getRest_url_V1();
    }

    @Override
    public String getPublishInterfaceUrl() {
        if (this.empty) {
            this.delegate = this.retrieveDescriptor();
        }
        return this.delegate.getPublishInterfaceUrl();
    }

    private GCubeSDMXDatasourceDescriptor retrieveDescriptor() {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        String scope = ScopeProvider.instance.get();
        if (scope == null || scope.isEmpty()) {
            log.error("No scope provided, unable to retrieve SDMX datasource");
            return null;
        }
        query.addCondition("$resource/Profile/Category/text() eq 'SDMX'");
        query.addCondition("$resource/Profile/Name/text() eq 'SDMXDatasource'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources.size() > 1 || resources.isEmpty()) {
            log.error("Invalid number of SDMX datasource resources found");
            return null;
        }
        GCubeSDMXDatasourceDescriptorImpl descriptor = new GCubeSDMXDatasourceDescriptorImpl();
        for (ServiceEndpoint.AccessPoint ap : ((ServiceEndpoint)resources.get(0)).profile().accessPoints()) {
            log.trace("Retrieved " + ap.name() + ": " + ap.address());
            if (ap.name().equals(DatasourceInterfaceCode.RESTV1.toString())) {
                descriptor.setRest_url_V1(ap.address());
            }
            if (ap.name().equals(DatasourceInterfaceCode.RESTV2.toString())) {
                descriptor.setRest_url_V2(ap.address());
            }
            if (ap.name().equals(DatasourceInterfaceCode.RESTV2_1.toString())) {
                descriptor.setRest_url_V2_1(ap.address());
            }
            if (!ap.name().equals(DatasourceInterfaceCode.PUBLISH.toString())) continue;
            descriptor.setPublishInterfaceUrl(ap.address());
        }
        this.empty = false;
        log.debug("SDMX datasource resource retrieved from IS: " + descriptor);
        return descriptor;
    }

    static enum DatasourceInterfaceCode {
        RESTV1,
        RESTV2,
        RESTV2_1,
        PUBLISH;

    }
}

