/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkerCrossValidator {
    private final String languageCode;
    private final int cutoff;
    private final int iterations;
    private FMeasure fmeasure = new FMeasure();

    public ChunkerCrossValidator(String languageCode, int cutoff, int iterations) {
        this.languageCode = languageCode;
        this.cutoff = cutoff;
        this.iterations = iterations;
    }

    public void evaluate(ObjectStream<ChunkSample> samples, int nFolds) throws IOException, InvalidFormatException, IOException {
        CrossValidationPartitioner<ChunkSample> partitioner = new CrossValidationPartitioner<ChunkSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<ChunkSample> trainingSampleStream = partitioner.next();
            ChunkerModel model = ChunkerME.train(this.languageCode, trainingSampleStream, this.cutoff, this.iterations);
            ChunkerEvaluator evaluator = new ChunkerEvaluator(new ChunkerME(model));
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(evaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

