/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Logger;

public class LoggingReader
extends FilterReader {
    protected Logger logger;
    protected StringBuffer logText;

    public LoggingReader(Reader in, Logger logger) {
        super(in);
        this.logger = logger;
        this.logText = new StringBuffer();
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c == -1) {
            this.logRead();
        } else {
            this.logText.append((char)c);
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int nr = super.read(cbuf, off, len);
        if (nr == -1) {
            this.logRead();
        } else {
            this.logText.append(new String(cbuf, off, nr));
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.logRead();
    }

    public void logRead() {
        if (this.logText.length() > 0) {
            this.logger.info("Read:\n" + this.logText.toString());
            this.logText.setLength(0);
        }
    }
}

