/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.SynthesisException;
import marytts.modules.synthesis.Voice;
import marytts.modules.synthesis.WaveformSynthesizer;
import marytts.server.MaryProperties;
import marytts.unitselection.UnitSelectionVoice;
import marytts.unitselection.concat.BaseUnitConcatenator;
import marytts.unitselection.concat.UnitConcatenator;
import marytts.unitselection.data.Unit;
import marytts.unitselection.data.UnitDatabase;
import marytts.unitselection.select.HalfPhoneTarget;
import marytts.unitselection.select.SelectedUnit;
import marytts.unitselection.select.Target;
import marytts.unitselection.select.UnitSelector;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryNormalisedWriter;
import marytts.util.dom.NameNodeFilter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class UnitSelectionSynthesizer
implements WaveformSynthesizer {
    private Logger logger;

    @Override
    public void startup() throws Exception {
        this.logger = MaryUtils.getLogger("UnitSelectionSynthesizer");
        this.logger.debug("Register UnitSelection voices:");
        List<String> voiceNames = MaryProperties.getList("unitselection.voices.list");
        for (String voiceName : voiceNames) {
            long time = System.currentTimeMillis();
            UnitSelectionVoice unitSelVoice = new UnitSelectionVoice(voiceName, this);
            this.logger.debug("Voice '" + unitSelVoice + "'");
            Voice.registerVoice(unitSelVoice);
            long newtime = System.currentTimeMillis() - time;
            this.logger.info("Loading of voice " + voiceName + " took " + newtime + " milliseconds");
        }
        this.logger.info("started.");
    }

    @Override
    public void powerOnSelfTest() throws Error {
        try {
            Collection<Voice> myVoices = Voice.getAvailableVoices(this);
            if (myVoices.size() == 0) {
                return;
            }
            UnitSelectionVoice unitSelVoice = (UnitSelectionVoice)myVoices.iterator().next();
            assert (unitSelVoice != null);
            MaryData in = new MaryData(MaryDataType.get("ACOUSTPARAMS"), unitSelVoice.getLocale());
            if (!unitSelVoice.getDomain().equals("general")) {
                this.logger.info("Cannot perform power-on self test using limited-domain voice '" + unitSelVoice.getName() + "' - skipping.");
                return;
            }
            String exampleText = MaryDataType.ACOUSTPARAMS.exampleText(unitSelVoice.getLocale());
            if (exampleText != null) {
                in.readFrom(new StringReader(exampleText));
                in.setDefaultVoice(unitSelVoice);
                if (in == null) {
                    System.out.println(exampleText + " is null");
                }
                ArrayList<Element> tokensAndBoundaries = new ArrayList<Element>();
                TreeWalker tw = ((DocumentTraversal)((Object)in.getDocument())).createTreeWalker(in.getDocument(), 1, new NameNodeFilter("t", "boundary"), false);
                Element el = null;
                while ((el = (Element)tw.nextNode()) != null) {
                    tokensAndBoundaries.add(el);
                }
                AudioInputStream ais = this.synthesize(tokensAndBoundaries, unitSelVoice, null);
                assert (ais != null);
            } else {
                this.logger.debug("No example text -- no power-on self test!");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("Module " + this.toString() + ": Power-on self test failed.", t);
        }
        this.logger.info("Power-on self test complete.");
    }

    @Override
    public AudioInputStream synthesize(List<Element> tokensAndBoundaries, Voice voice, String outputParams) throws SynthesisException {
        assert (voice instanceof UnitSelectionVoice);
        UnitSelectionVoice v = (UnitSelectionVoice)voice;
        UnitDatabase udb = v.getDatabase();
        UnitSelector unitSel = v.getUnitSelector();
        UnitConcatenator unitConcatenator = outputParams != null && outputParams.contains("MODIFICATION") ? v.getModificationConcatenator() : v.getConcatenator();
        UnitDatabase database = v.getDatabase();
        this.logger.debug("Selecting units with a " + unitSel.getClass().getName() + " from a " + database.getClass().getName());
        List<SelectedUnit> selectedUnits = unitSel.selectUnits(tokensAndBoundaries, voice);
        this.logger.debug("Now creating audio with a " + unitConcatenator.getClass().getName());
        AudioInputStream audio = null;
        try {
            audio = unitConcatenator.getAudio(selectedUnits);
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Iterator<SelectedUnit> selIt = selectedUnits.iterator();
            while (selIt.hasNext()) {
                pw.println(selIt.next());
            }
            throw new SynthesisException("Problems generating audio for unit chain: " + sw.toString(), ioe);
        }
        float endInSeconds = 0.0f;
        float durLeftHalfInSeconds = 0.0f;
        String unitString = "";
        String unitAttrName = "units";
        for (SelectedUnit su : selectedUnits) {
            Element maryxmlElement;
            Target t = su.getTarget();
            boolean halfphone = t instanceof HalfPhoneTarget;
            Object concatenationData = su.getConcatenationData();
            assert (concatenationData instanceof BaseUnitConcatenator.UnitData);
            BaseUnitConcatenator.UnitData unitData = (BaseUnitConcatenator.UnitData)concatenationData;
            Unit unit = su.getUnit();
            int unitDurationInSamples = unitData.getUnitDuration();
            float unitDurationInSeconds = (float)unitDurationInSamples / (float)database.getUnitFileReader().getSampleRate();
            int prevEndInMillis = (int)(1000.0f * endInSeconds);
            int endInMillis = (int)(1000.0f * (endInSeconds += unitDurationInSeconds));
            int unitDurationInMillis = endInMillis - prevEndInMillis;
            unitString = t.getName() + " " + udb.getFilename(unit) + " " + unit.index + " " + unitDurationInSeconds;
            if (halfphone) {
                if (((HalfPhoneTarget)t).isLeftHalf()) {
                    durLeftHalfInSeconds = unitDurationInSeconds;
                } else {
                    float totalUnitDurInSeconds = durLeftHalfInSeconds + unitDurationInSeconds;
                    float prevEndInSeconds = endInSeconds - totalUnitDurInSeconds;
                    prevEndInMillis = (int)(1000.0f * prevEndInSeconds);
                    unitDurationInMillis = endInMillis - prevEndInMillis;
                    durLeftHalfInSeconds = 0.0f;
                }
            }
            if ((maryxmlElement = t.getMaryxmlElement()) != null) {
                if (maryxmlElement.getNodeName().equals("ph")) {
                    if (!maryxmlElement.hasAttribute("d") || !maryxmlElement.hasAttribute("end")) {
                        throw new IllegalStateException("No duration information in MaryXML -- check log file for messages warning about unloadable acoustic models instead of voice-specific acoustic feature predictors");
                    }
                    maryxmlElement.setAttribute("d", String.valueOf(unitDurationInMillis));
                    maryxmlElement.setAttribute("end", String.valueOf(endInSeconds));
                } else {
                    assert (maryxmlElement.getNodeName().equals("boundary"));
                    maryxmlElement.setAttribute("duration", String.valueOf(unitDurationInMillis));
                }
                if (maryxmlElement.hasAttribute(unitAttrName)) {
                    String prevUnitString = maryxmlElement.getAttribute(unitAttrName);
                    maryxmlElement.setAttribute(unitAttrName, prevUnitString + "; " + unitString);
                    continue;
                }
                maryxmlElement.setAttribute(unitAttrName, unitString);
                continue;
            }
            this.logger.debug("Unit " + su.getTarget().getName() + " of length " + unitDurationInMillis + " ms has no maryxml element.");
        }
        if (this.logger.getEffectiveLevel().equals(Level.DEBUG)) {
            try {
                MaryNormalisedWriter writer = new MaryNormalisedWriter();
                ByteArrayOutputStream debugOut = new ByteArrayOutputStream();
                writer.output(tokensAndBoundaries.get(0).getOwnerDocument(), debugOut);
                this.logger.debug("Propagating the realised unit durations to the XML tree: \n" + debugOut.toString());
            }
            catch (Exception e) {
                this.logger.warn("Problem writing XML to logfile: " + e);
            }
        }
        return audio;
    }
}

