/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.math.Complex;
import com.rapidminer.tools.math.WindowFunction;
import java.util.Iterator;
import java.util.TreeMap;

public class FastFourierTransform {
    public static final int TIME2FREQUENCY = 0;
    public static final int FREQUENCY2TIME = 1;
    private int windowFunctionType = 1;

    public FastFourierTransform(int windowFunctionType) {
        this.windowFunctionType = windowFunctionType;
    }

    public Complex[] getFourierTransform(ExampleSet exampleSet, Attribute source, Attribute target) throws OperatorException {
        TreeMap<Double, Double> pairs = new TreeMap<Double, Double>();
        for (Example example : exampleSet) {
            pairs.put(example.getValue(target), example.getValue(source));
        }
        Complex[] complex = new Complex[pairs.size()];
        Iterator p = pairs.values().iterator();
        int k = 0;
        while (p.hasNext()) {
            complex[k++] = new Complex((Double)p.next(), 0.0);
        }
        return this.getFourierTransform(complex, 0, this.windowFunctionType);
    }

    public static double convertFrequency(double frequency, int nyquist, int totalLength) {
        return frequency / (Math.PI * 2) * ((double)totalLength / (double)nyquist);
    }

    /*
     * Unable to fully structure code
     */
    public Complex[] getFourierTransform(Complex[] series, int direction, int functionType) throws OperatorException {
        n = FastFourierTransform.getGreatestPowerOf2LessThan(series.length);
        filter = new WindowFunction(functionType, n);
        if (n < 2) {
            throw new UserError(null, 110, new Object[]{"4"});
        }
        nu = (int)(Math.log(n) / Math.log(2.0));
        n2 = n / 2;
        nu1 = nu - 1;
        xre = new double[n];
        xim = new double[n];
        i = 0;
        while (i < n) {
            xre[i] = filter.getFactor(i) * series[i].getReal();
            xim[i] = filter.getFactor(i) * series[i].getImaginary();
            ++i;
        }
        k = 0;
        l = 1;
        ** GOTO lbl42
        {
            i = 1;
            while (i <= n2) {
                p = this.bitrev(k >> nu1, nu);
                arg = 6.283185307179586 * p / (double)n;
                c = Math.cos(arg);
                s = Math.sin(arg);
                tr = xre[k + n2] * c + xim[k + n2] * s;
                ti = xim[k + n2] * c - xre[k + n2] * s;
                xre[k + n2] = xre[k] - tr;
                xim[k + n2] = xim[k] - ti;
                v0 = k;
                xre[v0] = xre[v0] + tr;
                v1 = k++;
                xim[v1] = xim[v1] + ti;
                ++i;
            }
            k += n2;
            do {
                if (k < n) continue block5;
                k = 0;
                --nu1;
                n2 /= 2;
                ++l;
lbl42:
                // 2 sources

            } while (l <= nu);
        }
        k = 0;
        while (k < n) {
            r = this.bitrev(k, nu);
            if (r > k) {
                tr = xre[k];
                ti = xim[k];
                xre[k] = xre[r];
                xim[k] = xim[r];
                xre[r] = tr;
                xim[r] = ti;
            }
            ++k;
        }
        nyquist = n / 2;
        result = new Complex[nyquist];
        switch (direction) {
            case 0: {
                i = 0;
                while (i < nyquist) {
                    result[i] = new Complex(-xre[i], xim[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                i = 0;
                while (i < nyquist) {
                    result[i] = new Complex(-xre[i], xim[i]);
                    ++i;
                }
                break;
            }
        }
        return result;
    }

    public static int getGreatestPowerOf2LessThan(int n) {
        int power = (int)(Math.log(n) / Math.log(2.0));
        return (int)Math.pow(2.0, power);
    }

    private int bitrev(int j, double nu) {
        int j1 = j;
        int k = 0;
        int i = 1;
        while ((double)i <= nu) {
            int j2 = j1 / 2;
            k = 2 * k + j1 - 2 * j2;
            j1 = j2;
            ++i;
        }
        return k;
    }
}

