/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.CombinedInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SpecificInnerOperatorCondition;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WrapperValidationChain
extends OperatorChain {
    private static final Class[] OUTPUT_CLASSES = new Class[]{PerformanceVector.class, AttributeWeights.class};
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private PerformanceCriterion lastPerformance;
    private IOContainer learnResult;
    private IOContainer methodResult;

    public WrapperValidationChain(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("performance", "The last performance (main criterion)."){

            public double getDoubleValue() {
                if (WrapperValidationChain.this.lastPerformance != null) {
                    return WrapperValidationChain.this.lastPerformance.getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue(new ValueDouble("variance", "The variance of the last performance (main criterion)."){

            public double getDoubleValue() {
                if (WrapperValidationChain.this.lastPerformance != null) {
                    return WrapperValidationChain.this.lastPerformance.getVariance();
                }
                return Double.NaN;
            }
        });
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 3;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 3;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new SpecificInnerOperatorCondition("Wrapper", 0, new Class[]{ExampleSet.class}, new Class[]{AttributeWeights.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Training", 1, new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Testing", 2, new Class[]{ExampleSet.class, Model.class}, new Class[]{PerformanceVector.class}));
        return condition;
    }

    private Operator getMethod() {
        return this.getOperator(0);
    }

    private Operator getLearner() {
        return this.getOperator(1);
    }

    private Operator getEvaluator() {
        return this.getOperator(2);
    }

    void setResult(PerformanceCriterion pc) {
        this.lastPerformance = pc;
    }

    IOContainer useMethod(ExampleSet methodTrainingSet) throws OperatorException {
        this.methodResult = this.getMethod().apply(new IOContainer(methodTrainingSet));
        return this.methodResult;
    }

    IOContainer learn(ExampleSet trainingSet) throws OperatorException {
        if (this.methodResult == null) {
            throw new RuntimeException("Wrong use of MethodEvaluator.evaluate(ExampleSet): No preceding invocation of useMethod(ExampleSet)!");
        }
        this.learnResult = this.getLearner().apply(new IOContainer(trainingSet));
        this.methodResult = null;
        return this.learnResult;
    }

    IOContainer evaluate(ExampleSet testSet) throws OperatorException {
        if (this.learnResult == null) {
            throw new RuntimeException("Wrong use of ValidationChain.evaluate(ExampleSet): No preceding invocation of learn(ExampleSet)!");
        }
        IOContainer result = this.getEvaluator().apply(this.learnResult.append(new IOObject[]{testSet}));
        this.learnResult = null;
        return result;
    }
}

