/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Series2WindowExamples
extends AbstractSeriesProcessing {
    public static final String PARAMETER_SERIES_REPRESENTATION = "series_representation";
    public static final String PARAMETER_HORIZON = "horizon";
    public static final String PARAMETER_WINDOW_SIZE = "window_size";
    public static final String PARAMETER_STEP_SIZE = "step_size";
    public static final String PARAMETER_CREATE_SINGLE_ATTRIBUTES = "create_single_attributes";
    public static final String[] SERIES_REPRESENTATIONS = new String[]{"encode_series_by_examples", "encode_series_by_attributes"};
    public static final int SERIES_AS_EXAMPLES = 0;
    public static final int SERIES_AS_ATTRIBUTES = 1;

    public Series2WindowExamples(OperatorDescription description) {
        super(description);
    }

    public abstract void performChecks(ExampleSet var1, int var2, int var3, int var4, int var5) throws OperatorException;

    public abstract void fillSeriesExampleTable(MemoryExampleTable var1, ExampleSet var2, Attribute var3, int var4, int var5, int var6, int var7) throws OperatorException;

    public abstract int[] getValueTypes(ExampleSet var1, int var2, int var3);

    public abstract String getNameForAttribute(Attribute[] var1, int var2, int var3, int var4, int var5);

    public abstract Attribute createLabel(ExampleSet var1, int var2) throws OperatorException;

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int i;
        int representation = this.getParameterAsInt(PARAMETER_SERIES_REPRESENTATION);
        int horizon = this.getParameterAsInt(PARAMETER_HORIZON) - 1;
        int windowWidth = this.getParameterAsInt(PARAMETER_WINDOW_SIZE);
        int stepSize = this.getParameterAsInt(PARAMETER_STEP_SIZE);
        this.performChecks(exampleSet, representation, windowWidth, stepSize, horizon);
        Attribute[] originalAttributeArray = exampleSet.getAttributes().createRegularAttributeArray();
        int[] valueTypes = this.getValueTypes(exampleSet, representation, windowWidth);
        int numberOfResultingAttributes = valueTypes.length;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(numberOfResultingAttributes + 1);
        if (this.getParameterAsBoolean(PARAMETER_CREATE_SINGLE_ATTRIBUTES)) {
            i = 0;
            while (i < numberOfResultingAttributes) {
                attributes.add(AttributeFactory.createAttribute(this.getNameForAttribute(originalAttributeArray, representation, windowWidth, horizon, i), valueTypes[i]));
                ++i;
            }
        } else {
            attributes.add(AttributeFactory.createAttribute(this.getNameForAttribute(originalAttributeArray, representation, windowWidth, horizon, 0), valueTypes[0], 3));
            i = 1;
            while (i < numberOfResultingAttributes - 1) {
                attributes.add(AttributeFactory.createAttribute(this.getNameForAttribute(originalAttributeArray, representation, windowWidth, horizon, i), valueTypes[i], 2));
                ++i;
            }
            attributes.add(AttributeFactory.createAttribute(this.getNameForAttribute(originalAttributeArray, representation, windowWidth, horizon, numberOfResultingAttributes - 1), valueTypes[valueTypes.length - 1], 4));
        }
        Attribute label = this.createLabel(exampleSet, representation);
        if (label != null) {
            attributes.add(label);
        }
        Attribute idAttribute = exampleSet.getAttributes().getId();
        Attribute idClone = null;
        if (idAttribute != null) {
            idClone = (Attribute)idAttribute.clone();
            attributes.add(idClone);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        this.fillSeriesExampleTable(table, exampleSet, idAttribute, representation, windowWidth, stepSize, horizon);
        ExampleSet result = table.createExampleSet(label, null, idClone);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_SERIES_REPRESENTATION, "This parameter defines how the series values will be represented.", SERIES_REPRESENTATIONS, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_HORIZON, "The prediction horizon, i.e. the distance between the last window value and the value to predict.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_WINDOW_SIZE, "The width of the used windows.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_STEP_SIZE, "The step size of the used windows, i.e. the distance between the first values", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_CREATE_SINGLE_ATTRIBUTES, "Indicates if the result example set should use single attributes instead of series attributes.", true));
        return types;
    }
}

