/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Tupel;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZTransformationModel
extends PreprocessingModel {
    private static final long serialVersionUID = 7739929307307501706L;
    private HashMap<String, Tupel<Double, Double>> attributeMeanVarianceMap;

    public ZTransformationModel(ExampleSet exampleSet, HashMap<String, Tupel<Double, Double>> attributeMeanVarianceMap) {
        super(exampleSet);
        this.attributeMeanVarianceMap = attributeMeanVarianceMap;
    }

    @Override
    public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
        Attributes attributes = exampleSet.getAttributes();
        for (Example example : exampleSet) {
            for (Attribute attribute : attributes) {
                if (!this.attributeMeanVarianceMap.containsKey(attribute.getName())) continue;
                Tupel<Double, Double> meanVarianceTupel = this.attributeMeanVarianceMap.get(attribute.getName());
                if (meanVarianceTupel.getSecond() <= 0.0) {
                    example.setValue(attribute, 0.0);
                    continue;
                }
                double newValue = (example.getValue(attribute) - meanVarianceTupel.getFirst()) / Math.sqrt(meanVarianceTupel.getSecond());
                example.setValue(attribute, newValue);
            }
        }
        return exampleSet;
    }

    @Override
    public String getName() {
        return "Z-Transformation";
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Normalize " + this.attributeMeanVarianceMap.size() + " attributes to mean 0 and variance 1." + Tools.getLineSeparator() + "Using");
        int counter = 0;
        for (String name : this.attributeMeanVarianceMap.keySet()) {
            if (counter > 4) {
                result.append(String.valueOf(Tools.getLineSeparator()) + "... " + (this.attributeMeanVarianceMap.size() - 5) + " more attributes ...");
                break;
            }
            Tupel<Double, Double> meanVariance = this.attributeMeanVarianceMap.get(name);
            result.append(String.valueOf(Tools.getLineSeparator()) + name + " --> mean: " + meanVariance.getFirst() + ", variance: " + meanVariance.getSecond());
            ++counter;
        }
        return result.toString();
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet viewParent) {
        SimpleAttributes attributes = new SimpleAttributes();
        Iterator<AttributeRole> roleIterator = viewParent.getAttributes().allAttributeRoles();
        while (roleIterator.hasNext()) {
            AttributeRole role = roleIterator.next();
            if (!role.isSpecial()) continue;
            attributes.add(role);
        }
        for (Attribute attribute : viewParent.getAttributes()) {
            if (!attribute.isNumerical() || !this.attributeMeanVarianceMap.containsKey(attribute.getName())) {
                attributes.addRegular(attribute);
                continue;
            }
            attributes.addRegular(new ViewAttribute(this, attribute, attribute.getName(), 2, null));
        }
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        Tupel<Double, Double> meanVarianceTupel = this.attributeMeanVarianceMap.get(targetAttribute.getName());
        if (meanVarianceTupel.getSecond() <= 0.0) {
            return 0.0;
        }
        return (value - meanVarianceTupel.getFirst()) / Math.sqrt(meanVarianceTupel.getSecond());
    }
}

