/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SimpleChainInnerOperatorCondition;
import com.rapidminer.operator.meta.ParameterIteratingOperatorChain;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.value.ParameterValueRange;
import com.rapidminer.parameter.value.ParameterValues;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterIteration
extends ParameterIteratingOperatorChain {
    public static final String PARAMETER_PARAMETERS = "parameters";
    public static final String PARAMETER_SYNCHRONIZE = "synchronize";
    public static final String PARAMETER_KEEP_OUTPUT = "keep_output";
    private PerformanceVector performance;
    private int iteration = 0;

    public ParameterIteration(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("performance", "The last performance."){

            public double getDoubleValue() {
                if (ParameterIteration.this.performance != null) {
                    return ParameterIteration.this.performance.getMainCriterion().getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue(new ValueDouble("iteration", "The current iteration."){

            public double getDoubleValue() {
                return ParameterIteration.this.iteration;
            }
        });
    }

    @Override
    public int getParameterValueMode() {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IOObject[] apply() throws OperatorException {
        input = this.getInput();
        output = new LinkedList<IOObject>();
        isSynchronized = this.getParameterAsBoolean("synchronize");
        keepOutput = this.getParameterAsBoolean("keep_output");
        parameterList = this.getParameterList("parameters");
        operators = new Operator[parameterList.size()];
        parameters = new String[parameterList.size()];
        values = new String[parameterList.size()][];
        currentIndex = new int[parameterList.size()];
        parameterValuesList = this.parseParameterValues(parameterList);
        numberOfCombinations = 1;
        lastNumberOfValues = -1;
        iterator = parameterValuesList.iterator();
        while (iterator.hasNext()) {
            parameterValues = iterator.next();
            if (parameterValues instanceof ParameterValueRange) {
                this.logWarning("found (and deleted) parameter values range (" + parameterValues.getKey() + ") which makes no sense in grid parameter optimization");
                iterator.remove();
            }
            numberOfCombinations *= parameterValues.getNumberOfValues();
        }
        operators = new Operator[parameterValuesList.size()];
        parameters = new String[parameterValuesList.size()];
        values = new String[parameterValuesList.size()][];
        currentIndex = new int[parameterValuesList.size()];
        index = 0;
        for (ParameterValues parameterValues : parameterValuesList) {
            operators[index] = parameterValues.getOperator();
            parameters[index] = parameterValues.getParameterType().getKey();
            values[index] = parameterValues.getValuesArray();
            if (!isSynchronized) {
                numberOfCombinations *= values[index].length;
            } else {
                numberOfCombinations = values[index].length;
                if (lastNumberOfValues < 0) {
                    lastNumberOfValues = values[index].length;
                } else if (lastNumberOfValues != values[index].length) {
                    throw new UserError(this, 926);
                }
            }
            ++index;
        }
        this.iteration = 0;
        while (true) {
            block19: {
                block20: {
                    this.log("Using parameter set");
                    j = 0;
                    while (j < operators.length) {
                        operators[j].setParameter(parameters[j], values[j][currentIndex[j]].trim());
                        this.log(operators[j] + "." + parameters[j] + " = " + values[j][currentIndex[j]].trim());
                        ++j;
                    }
                    this.setInput(input.copy());
                    evalout = super.apply();
                    evalCont = new IOContainer(evalout);
                    try {
                        this.performance = evalCont.remove(PerformanceVector.class);
                    }
                    catch (MissingIOObjectException e) {
                        this.log("Inner operators of ParameterIteration do not provide performance vectors: performance cannot be plotted!");
                    }
                    if (keepOutput) {
                        j = 0;
                        while (j < evalout.length) {
                            evalout[j].setSource(String.valueOf(evalout[j].getSource()) + " (" + this.getName() + ", iter.: " + (this.iteration + 1) + ")");
                            output.add(evalout[j]);
                            ++j;
                        }
                    }
                    ++this.iteration;
                    ok = true;
                    if (isSynchronized) break block20;
                    k = 0;
                    if (true) ** GOTO lbl76
                    do {
                        currentIndex[k] = 0;
                        if (++k >= currentIndex.length) {
                            ok = false;
                            break block19;
                        }
lbl76:
                        // 3 sources

                        v0 = k;
                    } while ((currentIndex[v0] = currentIndex[v0] + 1) >= values[k].length);
                    break block19;
                }
                k = 0;
                while (k < currentIndex.length) {
                    v1 = k++;
                    currentIndex[v1] = currentIndex[v1] + 1;
                }
                if (currentIndex[0] >= values[0].length) {
                    ok = false;
                    break;
                }
            }
            if (!ok) break;
            this.inApplyLoop();
        }
        if (keepOutput) {
            this.getInput().removeAll();
        }
        temp = new IOObject[output.size()];
        output.toArray(temp);
        return temp;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        boolean keepOutput = this.getParameterAsBoolean(PARAMETER_KEEP_OUTPUT);
        if (keepOutput) {
            Operator operator = null;
            if (this.getNumberOfOperators() > 0) {
                operator = this.getOperator(this.getNumberOfOperators() - 1);
            }
            if (operator != null) {
                return operator.getOutputClasses();
            }
            return new Class[0];
        }
        return new Class[0];
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        boolean keepOutput = this.getParameterAsBoolean(PARAMETER_KEEP_OUTPUT);
        return new SimpleChainInnerOperatorCondition(!keepOutput);
    }

    @Override
    public boolean shouldReturnInnerOutput() {
        return !this.getParameterAsBoolean(PARAMETER_KEEP_OUTPUT);
    }

    @Override
    public boolean shouldAddNonConsumedInput() {
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_SYNCHRONIZE, "Synchronize parameter iteration", false));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_OUTPUT, "Delivers the merged output of the last operator of all the iterations, delivers the original input otherwise.", false));
        return types;
    }
}

