/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SimpleChainInnerOperatorCondition;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleLabelIterator
extends OperatorChain {
    public MultipleLabelIterator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute[] labels = this.getLabels(exampleSet);
        if (labels.length == 0) {
            throw new UserError(this, 105);
        }
        LinkedList<IOObject> outputs = new LinkedList<IOObject>();
        int i = 0;
        while (i < labels.length) {
            ExampleSet cloneSet = (ExampleSet)exampleSet.clone();
            cloneSet.getAttributes().setLabel(labels[i]);
            IOContainer input = new IOContainer(cloneSet);
            int o = 0;
            while (o < this.getNumberOfOperators()) {
                input = this.getOperator(o).apply(input);
                ++o;
            }
            IOObject[] innerResult = input.getIOObjects();
            int j = 0;
            while (j < innerResult.length) {
                outputs.add(innerResult[j]);
                ++j;
            }
            this.inApplyLoop();
            ++i;
        }
        IOObject[] result = new IOObject[outputs.size()];
        outputs.toArray(result);
        return result;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        if (this.getNumberOfOperators() == 0) {
            return new Class[0];
        }
        return this.getOperator(this.getNumberOfOperators() - 1).getOutputClasses();
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean shouldReturnInnerOutput() {
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    private Attribute[] getLabels(ExampleSet exampleSet) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        Iterator<AttributeRole> i = exampleSet.getAttributes().specialAttributes();
        while (i.hasNext()) {
            AttributeRole role = i.next();
            String name = role.getSpecialName();
            if (!name.startsWith("label")) continue;
            attributes.add(role.getAttribute());
        }
        Attribute[] result = new Attribute[attributes.size()];
        attributes.toArray(result);
        return result;
    }
}

