/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.lazy;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.tools.Tools;

public class DefaultModel
extends PredictionModel {
    private static final long serialVersionUID = -1455906287520811107L;
    private double value;
    private double[] confidences;

    public DefaultModel(ExampleSet exampleSet, double value) {
        this(exampleSet, value, null);
    }

    public DefaultModel(ExampleSet exampleSet, double value, double[] confidences) {
        super(exampleSet);
        this.value = value;
        this.confidences = confidences;
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabelAttribute) throws OperatorException {
        Attribute label = this.getLabel();
        for (Example example : exampleSet) {
            example.setValue(predictedLabelAttribute, this.value);
            if (!label.isNominal()) continue;
            int i = 0;
            while (i < this.confidences.length) {
                example.setConfidence(predictedLabelAttribute.getMapping().mapIndex(i), this.confidences[i]);
                ++i;
            }
        }
        return exampleSet;
    }

    public String toString() {
        return String.valueOf(super.toString()) + Tools.getLineSeparator() + "default value: " + (this.getLabel().isNominal() ? this.getLabel().getMapping().mapIndex((int)this.value) : String.valueOf(this.value));
    }
}

