/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.CentroidClusterModel;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.clusterer.AbstractClusterer;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMedoids
extends AbstractClusterer {
    public static final String PARAMETER_ADD_CLUSTER_ATTRIBUTE = "add_cluster_attribute";
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_MAX_RUNS = "max_runs";
    public static final String PARAMETER_MAX_OPTIMIZATION_STEPS = "max_optimization_steps";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public KMedoids(OperatorDescription description) {
        super(description);
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        int k = this.getParameterAsInt(PARAMETER_K);
        int maxOptimizationSteps = this.getParameterAsInt(PARAMETER_MAX_OPTIMIZATION_STEPS);
        int maxRuns = this.getParameterAsInt(PARAMETER_MAX_RUNS);
        DistanceMeasure measure = DistanceMeasures.createMeasure(this, exampleSet, this.getInput());
        measure.init(exampleSet);
        Tools.checkAndCreateIds(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "KMedoids");
        if (exampleSet.size() < k) {
            throw new UserError((Operator)this, 142, k);
        }
        Attributes attributes = exampleSet.getAttributes();
        ArrayList<String> attributeNames = new ArrayList<String>(attributes.size());
        for (Attribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        int localRandomSeed = this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED);
        RandomGenerator generator = localRandomSeed == -1 ? RandomGenerator.getGlobalRandomGenerator() : RandomGenerator.getRandomGenerator(localRandomSeed);
        double minimalIntraClusterDistance = Double.POSITIVE_INFINITY;
        ClusterModel bestModel = null;
        int[] bestAssignments = null;
        int iter = 0;
        while (iter < maxRuns) {
            this.checkForStop();
            CentroidClusterModel model = new CentroidClusterModel(k, attributeNames, measure);
            int i = 0;
            for (Integer index : generator.nextIntSetWithRange(0, exampleSet.size() - 1, k)) {
                model.assignExample(i, this.getAsDoubleArray(exampleSet.getExample(index), attributes));
                ++i;
            }
            model.finishAssign();
            int[] centroidAssignments = new int[exampleSet.size()];
            boolean stable = false;
            int step2 = 0;
            while (step2 < maxOptimizationSteps && !stable) {
                i = 0;
                for (Example example : exampleSet) {
                    double[] exampleValues = this.getAsDoubleArray(example, attributes);
                    double nearestDistance = measure.calculateDistance(model.getCentroidCoordinates(0), exampleValues);
                    int nearestIndex = 0;
                    int centroidIndex = 1;
                    while (centroidIndex < k) {
                        double distance = measure.calculateDistance(model.getCentroidCoordinates(centroidIndex), exampleValues);
                        if (distance < nearestDistance) {
                            nearestDistance = distance;
                            nearestIndex = centroidIndex;
                        }
                        ++centroidIndex;
                    }
                    centroidAssignments[i] = nearestIndex;
                    ++i;
                }
                int clusterIndex = 0;
                while (clusterIndex < k) {
                    double[] bestMedoidValues = new double[attributes.size()];
                    double bestDistanceSum = Double.POSITIVE_INFINITY;
                    for (Example medoid : exampleSet) {
                        double distanceSum = 0.0;
                        double[] medoidValues = this.getAsDoubleArray(medoid, attributes);
                        int j = 0;
                        for (Example example : exampleSet) {
                            if (centroidAssignments[j] == clusterIndex) {
                                distanceSum += measure.calculateDistance(this.getAsDoubleArray(example, attributes), medoidValues);
                            }
                            ++j;
                        }
                        if (!(distanceSum < bestDistanceSum)) continue;
                        bestDistanceSum = distanceSum;
                        bestMedoidValues = medoidValues;
                    }
                    model.getCentroid(clusterIndex).assignExample(bestMedoidValues);
                    ++clusterIndex;
                }
                stable = model.finishAssign();
                ++step2;
            }
            double distanceSum = 0.0;
            i = 0;
            for (Example example : exampleSet) {
                double distance = measure.calculateDistance(model.getCentroidCoordinates(centroidAssignments[i]), this.getAsDoubleArray(example, attributes));
                distanceSum += distance * distance;
                ++i;
            }
            if (distanceSum < minimalIntraClusterDistance || Double.isInfinite(minimalIntraClusterDistance)) {
                bestModel = model;
                minimalIntraClusterDistance = distanceSum;
                bestAssignments = centroidAssignments;
            }
            ++iter;
        }
        bestModel.setClusterAssignments(bestAssignments, exampleSet);
        if (this.getParameterAsBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE) && this.getParameterAsBoolean("keep_example_set")) {
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            int i = 0;
            for (Example example : exampleSet) {
                example.setValue(cluster, "cluster_" + bestAssignments[i]);
                ++i;
            }
        }
        return bestModel;
    }

    private double[] getAsDoubleArray(Example example, Attributes attributes) {
        double[] values = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            values[i] = example.getValue(attribute);
            ++i;
        }
        return values;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE, "Indicates if a cluster id is generated as new special attribute.", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, "keep_example_set", false, true));
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_K, "The number of clusters which should be detected.", 2, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeInt(PARAMETER_MAX_RUNS, "The maximal number of runs of k-Means with random initialization that are performed.", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeInt(PARAMETER_MAX_OPTIMIZATION_STEPS, "The maximal number of iterations performed for one run of k-Means.", 1, Integer.MAX_VALUE, 100));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1));
        types.addAll(DistanceMeasures.getParameterTypes(this));
        return types;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }
}

