/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.Process;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.ExampleTableOutputFilter;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.RapidMinerOutputFilter;
import com.rapidminer.operator.TextInput;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeList;
import edu.udo.cs.wvtool.config.WVTConfiguration;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTFileInputList;
import edu.udo.cs.wvtool.main.WVTInputList;
import edu.udo.cs.wvtool.wordlist.WVTWordList;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextInputOperator
extends TextInput {
    public static final String PARAMETER_TEXTS = "texts";
    public static final String PARAMETER_EXTEND_EXAMPLESET = "extend_exampleset";
    private Attribute label = null;

    public TextInputOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected RapidMinerOutputFilter getOutputFilter(WVTWordList wordList, Attribute label) throws OperatorException {
        if (this.getParameterAsBoolean(PARAMETER_EXTEND_EXAMPLESET)) {
            return new ExampleTableOutputFilter(label, wordList, this.getParameterAsBoolean("use_content_attributes"), this.getParameterAsInt("id_attribute_type"), null, this.inputExampleSet, this);
        }
        return new ExampleTableOutputFilter(label, wordList, this.getParameterAsBoolean("use_content_attributes"), this.getParameterAsInt("id_attribute_type"), null, null, this);
    }

    @Override
    protected Attribute getLabel() throws OperatorException {
        return this.label;
    }

    @Override
    protected WVTConfiguration createConfiguration() throws OperatorException {
        return new WVTConfiguration();
    }

    @Override
    protected WVTInputList createInputList() throws OperatorException {
        WVTInputList list = null;
        List<String[]> textList = this.getParameterList(PARAMETER_TEXTS);
        this.label = null;
        if (textList.size() == 0) {
            this.logWarning("No text directories specified, trying reading text information from input example set if available.");
            this.label = this.inputExampleSet.getAttributes().getLabel();
            list = this.createInputList(this.inputExampleSet);
        } else {
            this.label = AttributeFactory.createAttribute("label", 1);
            list = this.createInputList(textList, this.label);
        }
        return list;
    }

    private WVTInputList createInputList(ExampleSet exampleSet) throws OperatorException {
        this.log("Creating WVTool input list from input example set.");
        Attribute documentClassAtt = exampleSet.getAttributes().getLabel();
        if (documentClassAtt != null && !documentClassAtt.isNominal()) {
            throw new UserError((Operator)this, 101, "wvtool", documentClassAtt);
        }
        Attribute sourceNameAtt = exampleSet.getAttributes().get("text_source");
        if (sourceNameAtt == null) {
            throw new UserError((Operator)this, 111, "text_source");
        }
        Attribute contentTypeAtt = exampleSet.getAttributes().get("type");
        Attribute contentEncodingAtt = exampleSet.getAttributes().get("encoding");
        Attribute contentLanguageAtt = exampleSet.getAttributes().get("language");
        String defaultContentType = this.getParameterAsString("default_content_type");
        String defaultContentEncoding = this.getParameterAsString("default_content_encoding");
        String defaultContentLanguage = this.getParameterAsString("default_content_language");
        WVTFileInputList list = new WVTFileInputList(documentClassAtt.getMapping().size());
        for (Example e : exampleSet) {
            String contentType = contentTypeAtt != null ? e.getValueAsString(contentTypeAtt) : defaultContentType;
            String contentEncoding = contentEncodingAtt != null ? e.getValueAsString(contentEncodingAtt) : defaultContentEncoding;
            String contentLanguage = contentLanguageAtt != null ? e.getValueAsString(contentLanguageAtt) : defaultContentLanguage;
            try {
                if (documentClassAtt != null) {
                    list.addEntry(new WVTDocumentInfo(this.resolveFilename(e.getValueAsString(sourceNameAtt)), contentType, contentEncoding, contentLanguage, (int)e.getValue(documentClassAtt)));
                    continue;
                }
                list.addEntry(new WVTDocumentInfo(this.resolveFilename(e.getValueAsString(sourceNameAtt)), contentType, contentEncoding, contentLanguage));
            }
            catch (IOException e1) {
                throw new UserError((Operator)this, 302, e.getValueAsString(sourceNameAtt), e1.getMessage());
            }
        }
        return list;
    }

    private WVTInputList createInputList(List<String[]> textList, Attribute label_) throws OperatorException {
        this.log("Creating WVTool input list from parameter list (ignoring input example set if any).");
        String contentType = this.getParameterAsString("default_content_type");
        String contentEncoding = this.getParameterAsString("default_content_encoding");
        String contentLanguage = this.getParameterAsString("default_content_language");
        for (String[] keyValue : textList) {
            label_.getMapping().mapString(keyValue[0]);
        }
        WVTFileInputList list = new WVTFileInputList(label_.getMapping().getValues().size());
        for (String[] keyValue : textList) {
            try {
                list.addEntry(new WVTDocumentInfo(this.resolveFilename(keyValue[1]), contentType, contentEncoding, contentLanguage, label_.getMapping().mapString(keyValue[0])));
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 302, keyValue[1], e.getMessage());
            }
        }
        return list;
    }

    private String resolveFilename(String name) throws IOException {
        Process associatedExperiment = this.getProcess();
        if (associatedExperiment != null) {
            return associatedExperiment.resolveFileName(name).getAbsolutePath();
        }
        return new File(name).getAbsolutePath();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        ParameterTypeList textListParam = new ParameterTypeList(PARAMETER_TEXTS, "Specifies a list of class/directory pairs.", new ParameterTypeDirectory("directory_name", "All files in this directory will be associated with the class specified by the key.", false));
        textListParam.setExpert(false);
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(textListParam);
        types.addAll(super.getParameterTypes());
        types.add(new ParameterTypeBoolean(PARAMETER_EXTEND_EXAMPLESET, "If true, an input example set is not only used to specify the documents that should be vectorized, but this example set is merged with the vectors. Note, that this works only with nominal ids!", false));
        return types;
    }
}

