/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.ExampleSetOutputFilter;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.RapidMinerOutputFilter;
import com.rapidminer.operator.TextInput;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.Ontology;
import edu.udo.cs.wvtool.config.WVTConfiguration;
import edu.udo.cs.wvtool.config.WVTConfigurationFact;
import edu.udo.cs.wvtool.config.WVTConfigurationRule;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTFileInputList;
import edu.udo.cs.wvtool.main.WVTInputList;
import edu.udo.cs.wvtool.wordlist.WVTWordList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTextInput
extends TextInput {
    public static final String PARAMETER_FILTER_NOMINAL_ATTRIBUTES = "filter_nominal_attributes";
    public static final String PARAMETER_REMOVE_ORIGINAL_ATTRIBUTES = "remove_original_attributes";
    private Attribute label = null;

    public StringTextInput(OperatorDescription description) {
        super(description);
    }

    @Override
    protected RapidMinerOutputFilter getOutputFilter(WVTWordList wordList, Attribute label) {
        LinkedList<Attribute> toRemoveAttributes = null;
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_ORIGINAL_ATTRIBUTES)) {
            toRemoveAttributes = new LinkedList<Attribute>();
            for (Attribute attribute : this.inputExampleSet.getAttributes()) {
                if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 5) && (!attribute.isNominal() || !this.getParameterAsBoolean(PARAMETER_FILTER_NOMINAL_ATTRIBUTES))) continue;
                toRemoveAttributes.add(attribute);
            }
        }
        return new ExampleSetOutputFilter(this.inputExampleSet, wordList, this.getParameterAsBoolean("use_content_attributes"), toRemoveAttributes, this);
    }

    @Override
    protected Attribute getLabel() throws OperatorException {
        return this.label;
    }

    @Override
    protected WVTInputList createInputList() throws OperatorException {
        ExampleSet exampleSet = this.inputExampleSet;
        this.label = exampleSet.getAttributes().getLabel();
        return this.createInputList(exampleSet);
    }

    @Override
    protected WVTConfiguration createConfiguration() throws OperatorException {
        WVTConfiguration config = new WVTConfiguration();
        this.log("Creating WVTool configuration including source as text loader...");
        config.setConfigurationRule("loader", (WVTConfigurationRule)new WVTConfigurationFact("edu.udo.cs.wvtool.generic.loader.SourceAsTextLoader"));
        return config;
    }

    private WVTInputList createInputList(ExampleSet exampleSet) throws OperatorException {
        Attribute documentClassAtt;
        this.log("Creating WVTool input list from input string attributes.");
        if (!Tools.containsValueType(exampleSet, 5)) {
            if (this.getParameterAsBoolean(PARAMETER_FILTER_NOMINAL_ATTRIBUTES)) {
                if (!Tools.containsValueType(exampleSet, 1)) {
                    throw new UserError((Operator)this, 128, String.valueOf(Ontology.VALUE_TYPE_NAMES[5]) + " and " + Ontology.VALUE_TYPE_NAMES[1]);
                }
            } else {
                throw new UserError((Operator)this, 128, Ontology.VALUE_TYPE_NAMES[5]);
            }
        }
        if ((documentClassAtt = exampleSet.getAttributes().getLabel()) != null && !documentClassAtt.isNominal()) {
            throw new UserError((Operator)this, 101, "wvtool", documentClassAtt);
        }
        Attribute contentTypeAtt = exampleSet.getAttributes().get("type");
        Attribute contentEncodingAtt = exampleSet.getAttributes().get("encoding");
        Attribute contentLanguageAtt = exampleSet.getAttributes().get("language");
        String defaultContentType = this.getParameterAsString("default_content_type");
        String defaultContentEncoding = this.getParameterAsString("default_content_encoding");
        String defaultContentLanguage = this.getParameterAsString("default_content_language");
        WVTFileInputList list = null;
        list = documentClassAtt != null ? new WVTFileInputList(documentClassAtt.getMapping().size()) : new WVTFileInputList(0);
        for (Example e : exampleSet) {
            String contentType = contentTypeAtt != null ? e.getValueAsString(contentTypeAtt) : defaultContentType;
            String contentEncoding = contentEncodingAtt != null ? e.getValueAsString(contentEncodingAtt) : defaultContentEncoding;
            String contentLanguage = contentLanguageAtt != null ? e.getValueAsString(contentLanguageAtt) : defaultContentLanguage;
            StringBuffer textBuffer = new StringBuffer();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 5) && (!attribute.isNominal() || !this.getParameterAsBoolean(PARAMETER_FILTER_NOMINAL_ATTRIBUTES))) continue;
                textBuffer.append(String.valueOf(e.getValueAsString(attribute)) + " ");
            }
            String text = textBuffer.toString();
            if (documentClassAtt != null) {
                int labelValue = (int)e.getValue(documentClassAtt);
                list.addEntry(new WVTDocumentInfo(text, contentType, contentEncoding, contentLanguage, labelValue));
                continue;
            }
            list.addEntry(new WVTDocumentInfo(text, contentType, contentEncoding, contentLanguage));
        }
        return list;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterType type = new ParameterTypeBoolean(PARAMETER_FILTER_NOMINAL_ATTRIBUTES, "Indicates if nominal attributes should also be filtered in addition to string attributes.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_REMOVE_ORIGINAL_ATTRIBUTES, "Indicates if the original nominal and / or string attributes should also be removed after the word vector creation.", false);
        type.setExpert(false);
        types.add(type);
        types.addAll(super.getParameterTypes());
        Iterator i = types.iterator();
        while (i.hasNext()) {
            type = (ParameterType)i.next();
            if (!type.getKey().equals("loader")) continue;
            i.remove();
            break;
        }
        return types;
    }
}

