/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.extraction.AttributeQueryMap;
import com.rapidminer.operator.extraction.ExtractionException;
import com.rapidminer.operator.extraction.TextExtractionWrapper;
import com.rapidminer.operator.extraction.TextExtractor;
import com.rapidminer.operator.extraction.util.FeatureExtractionUtil;
import com.rapidminer.operator.extraction.util.NumberParser;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MashupOperator
extends Operator {
    public static final String PARAMETER_URL = "url";
    public static final String PARAMETER_SEPARATORS = "separators";
    public static final String PARAMETER_DELAY = "delay";

    public MashupOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public InputDescription getInputDescription(Class<?> cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, false);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        String genericURL = this.getParameterAsString(PARAMETER_URL);
        String separators = this.getParameterAsString(PARAMETER_SEPARATORS);
        int delay = this.getParameterAsInt(PARAMETER_DELAY);
        ExampleSet es = this.getInput(ExampleSet.class);
        AttributeQueryMap aqMap = null;
        try {
            aqMap = FeatureExtractionUtil.getAttributeQueryMap(this.getParameters());
        }
        catch (ExtractionException e3) {
            UserError error = e3.getUserError();
            error.setOperator(this);
            throw error;
        }
        es.getExampleTable().addAttributes(aqMap.getAttributes());
        for (Attribute attribute : aqMap.getAttributes()) {
            es.getAttributes().addRegular(attribute);
        }
        for (Example e : es) {
            String urlStr = null;
            try {
                urlStr = this.rewriteURL(genericURL, e);
            }
            catch (URISyntaxException e3) {
                throw new UserError((Operator)this, 212, urlStr, e3);
            }
            TextExtractionWrapper wrapper = null;
            try {
                URL url = new URL(urlStr);
                URLConnection connection = url.openConnection();
                wrapper = new TextExtractionWrapper(connection.getInputStream(), 1, false);
            }
            catch (ExtractionException e2) {
                UserError error = e2.getUserError();
                error.setOperator(this);
                throw error;
            }
            catch (MalformedURLException e2) {
                throw new UserError((Operator)this, 212, urlStr, e2);
            }
            catch (IOException e2) {
                throw new UserError((Operator)this, 302, urlStr, e2);
            }
            HashMap<TextExtractor, StringTokenizer> queryMap = new HashMap<TextExtractor, StringTokenizer>();
            for (Attribute att : aqMap.getAttributes()) {
                TextExtractor query = aqMap.getQuery(att);
                StringTokenizer tokenizer = (StringTokenizer)queryMap.get(query);
                if (tokenizer == null) {
                    String result;
                    Iterator<String> values = null;
                    try {
                        values = wrapper.getValues(query);
                    }
                    catch (ExtractionException e1) {
                        this.logWarning("Could not extract values from xml:\n" + e1);
                    }
                    if (values != null && values.hasNext() && (result = values.next()) != null) {
                        tokenizer = new StringTokenizer(result, separators);
                        queryMap.put(query, tokenizer);
                    }
                }
                if (tokenizer != null && tokenizer.hasMoreElements()) {
                    String value = tokenizer.nextToken();
                    if (!att.isNominal()) {
                        double numericalValue;
                        try {
                            numericalValue = NumberParser.parse(value);
                        }
                        catch (NumberFormatException e1) {
                            numericalValue = Double.NaN;
                        }
                        e.setValue(att, numericalValue);
                        continue;
                    }
                    e.setValue(att, att.getMapping().mapString(value));
                    continue;
                }
                e.setValue(att, Double.NaN);
            }
            try {
                if (delay <= 0) continue;
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return new IOObject[0];
    }

    private String rewriteURL(String genericURLStr, Example e) throws URISyntaxException {
        String result = null;
        result = genericURLStr;
        Iterator<Attribute> i = e.getAttributes().allAttributes();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            String value = e.getValueAsString(attribute);
            result = result.replaceAll("<" + attribute.getName() + ">", new URI(null, value, null).toASCIIString());
        }
        return result;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType attributesParam = FeatureExtractionUtil.createQueryParameter();
        attributesParam.setExpert(false);
        types.add(attributesParam);
        ParameterType namespaceParam = FeatureExtractionUtil.createNamespaceParameter();
        namespaceParam.setExpert(false);
        types.add(namespaceParam);
        ParameterTypeString urlParam = new ParameterTypeString(PARAMETER_URL, "The url of the HTTP GET based service. This URL may contain terms of the form <attributeName> that are replaced by the value of the corresonding attribute before invoking the query.");
        types.add(urlParam);
        types.add(new ParameterTypeString(PARAMETER_SEPARATORS, "Characters used to separate entries in the result field obtained by XPath or regular expression."));
        types.add(new ParameterTypeInt(PARAMETER_DELAY, "Amount of milliseconds to wait between requests", 0, Integer.MAX_VALUE, 0));
        return types;
    }
}

