/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOMultiplyOperator
extends Operator {
    public static final String PARAMETER_NUMBER_OF_COPIES = "number_of_copies";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_MULTIPLY_TYPE = "multiply_type";
    public static final String PARAMETER_MULTIPLY_WHICH = "multiply_which";
    private static final String[] MULTIPLY_TYPES = new String[]{"multiply_one", "multiply_all"};
    private static final int MULTIPLY_ONE = 0;
    private static final int MULTIPLY_ALL = 1;
    private String[] objectArray = null;

    public IOMultiplyOperator(OperatorDescription description) {
        super(description);
    }

    private Class<IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (this.objectArray != null) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        LinkedList<IOObject> result = new LinkedList<IOObject>();
        Class<IOObject> clazz = this.getSelectedClass();
        int numberOfCopies = this.getParameterAsInt(PARAMETER_NUMBER_OF_COPIES);
        if (clazz != null) {
            switch (this.getParameterAsInt(PARAMETER_MULTIPLY_TYPE)) {
                case 0: {
                    int number = this.getParameterAsInt(PARAMETER_MULTIPLY_WHICH);
                    IOObject ioObject = this.getInput(clazz, number - 1);
                    this.addCopies(result, ioObject, numberOfCopies);
                    break;
                }
                case 1: {
                    try {
                        while (true) {
                            IOObject ioObject = this.getInput(clazz);
                            this.addCopies(result, ioObject, numberOfCopies);
                        }
                    }
                    catch (MissingIOObjectException missingIOObjectException) {
                        // empty catch block
                    }
                }
            }
        }
        IOObject[] resultArray = new IOObject[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    private void addCopies(List<IOObject> result, IOObject ioObject, int numberOfCopies) {
        result.add(ioObject);
        int i = 0;
        while (i < numberOfCopies) {
            result.add(ioObject.copy());
            ++i;
        }
    }

    @Override
    public Class<?>[] getInputClasses() {
        Class<IOObject> clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (clazz != null) {
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        Class<IOObject> clazz = null;
        int numberOfCopies = 1;
        try {
            clazz = this.getSelectedClass();
            numberOfCopies = this.getParameterAsInt(PARAMETER_NUMBER_OF_COPIES);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (clazz != null) {
            Class[] result = new Class[++numberOfCopies];
            int i = 0;
            while (i < result.length) {
                result[i] = clazz;
                ++i;
            }
            return result;
        }
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_OF_COPIES, "The number of copies which should be created.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object(s) which should be multiplied.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_MULTIPLY_TYPE, "Defines the type of multiplying.", MULTIPLY_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MULTIPLY_WHICH, "Defines which input object should be multiplied (only used for deletion type 'multiply_one').", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

