/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.NoBugError;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dialog.BugAssistant;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ErrorDialog
extends JDialog {
    private static final long serialVersionUID = -8136329951869702133L;
    JButton editButton = new JButton("Edit");

    private ErrorDialog(String title, String mainText, Icon icon, final Throwable error, boolean bugReport) {
        super((Frame)RapidMinerGUI.getMainFrame(), title);
        this.setTitle(title);
        if (JDialog.isDefaultLookAndFeelDecorated() && UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(4);
        }
        this.getContentPane().setLayout(new BorderLayout());
        JPanel box = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        box.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 11, 5, 11);
        c.gridwidth = -1;
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        gbl.setConstraints(iconLabel, c);
        box.add(iconLabel);
        c.gridwidth = 0;
        c.weightx = 1.0;
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attributeSet, "SansSerif");
        StyleConstants.setFontSize(attributeSet, 11);
        JTextPane text = new JTextPane();
        text.setBorder(null);
        text.setEditable(false);
        text.setBackground(this.getBackground());
        text.setContentType("text/html");
        text.setFont(new Font("SansSerif", 0, 11));
        text.setText(mainText);
        text.getStyledDocument().setCharacterAttributes(0, text.getStyledDocument().getLength(), attributeSet, false);
        ExtendedJScrollPane textScrollPane = new ExtendedJScrollPane(text);
        textScrollPane.setBorder(null);
        text.setPreferredSize(new Dimension((int)((double)RapidMinerGUI.getMainFrame().getWidth() * 0.5), Math.max(150, (int)((double)RapidMinerGUI.getMainFrame().getHeight() * 0.15))));
        gbl.setConstraints(textScrollPane, c);
        box.add(textScrollPane);
        Box detailBox = new Box(1);
        final StackTraceList stl = new StackTraceList(error);
        ExtendedJScrollPane detailPane = new ExtendedJScrollPane(stl);
        detailPane.setPreferredSize(new Dimension((int)((double)RapidMinerGUI.getMainFrame().getWidth() * 0.5), Math.max(150, (int)((double)RapidMinerGUI.getMainFrame().getHeight() * 0.25))));
        detailBox.add(detailPane);
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                stl.edit();
            }
        });
        JPanel detailButtonPanel = new JPanel(new FlowLayout(2));
        detailButtonPanel.add(this.editButton);
        detailBox.add(detailButtonPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton detailButton = new JButton(detailBox){
            private static final long serialVersionUID = -8444237609983095359L;
            private boolean more = true;
            {
                this.setText("Details >>");
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (more) {
                            ErrorDialog.this.getContentPane().add((Component)box, "South");
                            this.setText("<< Hide");
                        } else {
                            ErrorDialog.this.getContentPane().remove(box);
                            this.setText("Details >>");
                        }
                        ErrorDialog.this.pack();
                        more = !more;
                    }
                });
            }
        };
        buttonPanel.add(detailButton);
        if (bugReport) {
            JButton report = new JButton("Send bug report...");
            report.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new BugAssistant(error).setVisible(true);
                }
            });
            buttonPanel.add(report);
        }
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.dispose();
            }
        });
        buttonPanel.add(close);
        c.weighty = 0.0;
        gbl.setConstraints(buttonPanel, c);
        box.add(buttonPanel);
        this.getContentPane().add((Component)box, "Center");
        this.pack();
    }

    static ErrorDialog create(String message, Throwable t) {
        if (t instanceof NoBugError) {
            NoBugError ue = (NoBugError)((Object)t);
            return new ErrorDialog("Error " + ue.getCode() + ": " + ue.getErrorName(), ue.getHTMLMessage(), UIManager.getIcon("OptionPane.warningIcon"), t, false);
        }
        return new ErrorDialog("Error occured", "<html><b>" + Tools.classNameWOPackage(t.getClass()) + "</b><br>" + Tools.escapeXML(message) + "<br>" + "Message: " + Tools.escapeXML(t.getMessage()) + "</html>", UIManager.getIcon("OptionPane.errorIcon"), t, !(t instanceof XMLException));
    }

    private static class FormattedStackTraceElement {
        private StackTraceElement ste;

        private FormattedStackTraceElement(StackTraceElement ste) {
            this.ste = ste;
        }

        public String toString() {
            return "  " + this.ste;
        }
    }

    private class StackTraceList
    extends JList {
        private static final long serialVersionUID = -2482220036723949144L;

        public StackTraceList(Throwable t) {
            super(new DefaultListModel());
            this.setFont(this.getFont().deriveFont(0));
            this.setSelectionMode(2);
            this.appendAllStackTraces(t);
            this.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (StackTraceList.this.getSelectedIndex() >= 0) {
                        if (!(StackTraceList.this.getSelectedValue() instanceof FormattedStackTraceElement)) {
                            ((StackTraceList)StackTraceList.this).ErrorDialog.this.editButton.setEnabled(false);
                        } else {
                            ((StackTraceList)StackTraceList.this).ErrorDialog.this.editButton.setEnabled(true);
                        }
                    } else {
                        ((StackTraceList)StackTraceList.this).ErrorDialog.this.editButton.setEnabled(true);
                    }
                }
            });
        }

        private DefaultListModel model() {
            return (DefaultListModel)this.getModel();
        }

        private void appendAllStackTraces(Throwable throwable) {
            while (throwable != null) {
                this.appendStackTrace(throwable);
                throwable = throwable.getCause();
                if (throwable == null) continue;
                this.model().addElement("");
                this.model().addElement("Cause");
            }
        }

        private void appendStackTrace(Throwable throwable) {
            this.model().addElement("Exception: " + throwable.getClass().getName());
            this.model().addElement("Message: " + throwable.getMessage());
            this.model().addElement("Stack trace:" + Tools.getLineSeparator());
            int i = 0;
            while (i < throwable.getStackTrace().length) {
                this.model().addElement(new FormattedStackTraceElement(throwable.getStackTrace()[i]));
                ++i;
            }
        }

        private void edit() {
            try {
                Object o = this.getSelectedValue();
                if (!(o instanceof FormattedStackTraceElement)) {
                    return;
                }
                StackTraceElement ste = ((FormattedStackTraceElement)o).ste;
                File file = Tools.findSourceFile(ste);
                if (file != null) {
                    Tools.launchFileEditor(file, ste.getLineNumber());
                }
            }
            catch (Throwable t) {
                SwingTools.showSimpleErrorMessage("Cannot launch editor.", t);
            }
        }
    }
}

