/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.RandomDistribution;

public class ExponentialDistribution
implements RandomDistribution {
    private double rate;
    private static final long serialVersionUID = 6359607459925864639L;

    public ExponentialDistribution(double rate) {
        if (rate <= 0.0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.rate = rate;
    }

    public double rate() {
        return this.rate;
    }

    public double generate() {
        return -Math.log(Math.random()) / this.rate;
    }

    public double probability(double n) {
        return this.rate * Math.exp(-n * this.rate);
    }
}

