/*
 * Decompiled with CFR 0.152.
 */
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class LicensePrepender {
    private char[] license;

    private char[] readFile(File file, String from) throws IOException {
        StringBuffer contents = new StringBuffer((int)file.length());
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line = null;
            while ((line = in.readLine()) != null && !line.startsWith("package")) {
            }
            if (line == null) {
                System.err.println("'package' not found in file '" + file + "'.");
                return null;
            }
            do {
                contents.append(line);
                contents.append(Tools.getLineSeparator());
            } while ((line = in.readLine()) != null);
        }
        finally {
            in.close();
        }
        return contents.toString().toCharArray();
    }

    private void readLicense(File file, String additionalAdmin) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuffer licenseText = new StringBuffer();
        while ((line = in.readLine()) != null) {
            licenseText.append(String.valueOf(line) + Tools.getLineSeparator());
        }
        in.close();
        this.license = licenseText.toString().toCharArray();
    }

    private void prependLicense(File file) throws IOException {
        System.out.print(file + "...");
        char[] fileContents = this.readFile(file, "package");
        if (fileContents == null) {
            return;
        }
        FileWriter out = new FileWriter(file);
        out.write(this.license);
        out.write(fileContents);
        ((Writer)out).close();
        System.out.println("ok");
    }

    private void recurse(File file) {
        block4: {
            block3: {
                if (!file.isDirectory()) break block3;
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.recurse(files[i]);
                    ++i;
                }
                break block4;
            }
            if (!file.getName().endsWith(".java")) break block4;
            try {
                this.prependLicense(file);
            }
            catch (IOException e) {
                System.err.println("failed: " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        LicensePrepender lp = new LicensePrepender();
        if (argv.length < 1 || argv[0].equals("-help")) {
            System.out.println("Usage: java " + lp.getClass().getName() + " licensefile [additional_admin]");
            System.exit(1);
        }
        String additionalAdmin = null;
        if (argv.length >= 3) {
            StringBuffer additionalAdminBuffer = new StringBuffer();
            int i = 2;
            while (i < argv.length) {
                additionalAdminBuffer.append(String.valueOf(argv[i]) + " ");
                ++i;
            }
            additionalAdmin = additionalAdminBuffer.toString();
        }
        lp.readLicense(new File(argv[0]), additionalAdmin);
        System.out.println("Prepending license:");
        System.out.print(lp.license);
        lp.recurse(new File(argv[1]));
    }
}

