/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.rules;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.learner.tree.SplitCondition;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule {
    private static final long serialVersionUID = 7355669588176081975L;
    private LinkedList<SplitCondition> terms = new LinkedList();
    private String labelName;
    private int[] frequencies;
    private int frequencySum = 0;

    public Rule() {
    }

    public Rule(String labelName) {
        this.labelName = labelName;
    }

    public Rule(String labelName, SplitCondition term) {
        this.labelName = labelName;
        this.terms.add(term);
    }

    public Rule(String labelName, Collection<SplitCondition> terms) {
        this.labelName = labelName;
        this.terms.addAll(terms);
    }

    private Rule(Rule other) {
        this.labelName = other.labelName;
        for (SplitCondition condition : other.terms) {
            this.terms.add(condition);
        }
        this.frequencySum = other.frequencySum;
        if (other.frequencies != null) {
            this.frequencies = new int[other.frequencies.length];
            int i = 0;
            while (i < this.frequencies.length) {
                this.frequencies[i] = other.frequencies[i];
                ++i;
            }
        }
    }

    public Object clone() {
        return new Rule(this);
    }

    public void setLabel(String labelName) {
        this.labelName = labelName;
    }

    public boolean coversExample(Example example) {
        boolean result = true;
        for (SplitCondition term : this.terms) {
            result &= term.test(example);
        }
        return result;
    }

    public void setFrequencies(int[] frequencies) {
        this.frequencies = frequencies;
        this.frequencySum = 0;
        if (frequencies != null) {
            int i = 0;
            while (i < this.frequencies.length) {
                this.frequencySum += this.frequencies[i];
                ++i;
            }
        }
    }

    public int[] getFrequencies() {
        return this.frequencies;
    }

    public double[] getConfidences() {
        if (this.frequencies != null) {
            double[] confidences = new double[this.frequencies.length];
            int i = 0;
            while (i < this.frequencies.length) {
                confidences[i] = (double)this.frequencies[i] / (double)this.frequencySum;
                ++i;
            }
            return confidences;
        }
        return new double[0];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.terms.size() > 0) {
            buffer.append("if ");
            boolean firstTerm = true;
            for (SplitCondition condition : this.terms) {
                if (!firstTerm) {
                    buffer.append(" and ");
                }
                buffer.append(condition.toString());
                firstTerm = false;
            }
            buffer.append(" then ");
        } else {
            buffer.append("else ");
        }
        buffer.append(this.labelName);
        if (this.frequencies != null) {
            buffer.append("  (");
            int i = 0;
            while (i < this.frequencies.length) {
                if (i != 0) {
                    buffer.append(" / ");
                }
                buffer.append(this.frequencies[i]);
                ++i;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public void addTerm(SplitCondition condition) {
        this.terms.add(condition);
    }

    public void removeLastTerm() {
        this.terms.removeLast();
    }

    public List<SplitCondition> getTerms() {
        return this.terms;
    }

    public void setTerms(LinkedList<SplitCondition> terms) {
        this.terms = terms;
    }

    public String getLabel() {
        return this.labelName;
    }

    public ExampleSet getCovered(ExampleSet exampleSet) {
        int[] partition = new int[exampleSet.size()];
        int counter = 0;
        for (Example e : exampleSet) {
            if (this.coversExample(e)) {
                partition[counter] = 1;
            }
            ++counter;
        }
        SplittedExampleSet result = new SplittedExampleSet(exampleSet, new Partition(partition, 2));
        result.selectSingleSubset(1);
        return result;
    }

    public ExampleSet removeCovered(ExampleSet exampleSet) {
        int[] partition = new int[exampleSet.size()];
        int counter = 0;
        for (Example e : exampleSet) {
            if (this.coversExample(e)) {
                partition[counter] = 1;
            }
            ++counter;
        }
        SplittedExampleSet result = new SplittedExampleSet(exampleSet, new Partition(partition, 2));
        result.selectSingleSubset(0);
        return result;
    }

    public boolean isPure(ExampleSet exampleSet, double pureness) {
        Attribute label = exampleSet.getAttributes().getLabel();
        exampleSet.recalculateAttributeStatistics(label);
        return exampleSet.getStatistics(label, "count", this.getLabel()) >= pureness * (double)exampleSet.size();
    }
}

