/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.ResultSetExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.UndefinedParameterError;
import java.io.File;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import org.kobjects.jdbc.TableManager;
import org.kobjects.jdbc.util.AbstractResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KDBExampleSource
extends ResultSetExampleSource {
    public static final String PARAMETER_DATA_FILE = "data_file";

    public abstract String getFormat();

    public abstract String getExtension();

    public KDBExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public void tearDown() {
    }

    @Override
    public ResultSet getResultSet() throws UndefinedParameterError {
        File dataFile = this.getParameterAsFile(PARAMETER_DATA_FILE);
        String dataFileAbsolutePath = dataFile.getAbsolutePath();
        return TableManager.getResultSet((String)(String.valueOf(this.getFormat()) + ":" + dataFileAbsolutePath), (int)1);
    }

    public void setNominalValues(List attributeList, ResultSet resultSet, Attribute label) throws OperatorException {
        if (resultSet instanceof AbstractResultSet) {
            AbstractResultSet ars = (AbstractResultSet)resultSet;
            Iterator i = attributeList.iterator();
            int j = 0;
            while (i.hasNext()) {
                Attribute attribute = (Attribute)i.next();
                Object[] values = ars.getColumnSet().getColumn(++j).getValues();
                if (!attribute.isNominal()) continue;
                if (values == null) {
                    this.logWarning("Information about class values is null!");
                    continue;
                }
                int k = 0;
                while (k < values.length) {
                    attribute.getMapping().mapString(values[k].toString());
                    ++k;
                }
            }
        } else {
            this.logWarning("Result set does not provide information about class values!");
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_DATA_FILE, "The file containing the data", this.getExtension(), false));
        return types;
    }
}

