/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatortree;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.actions.NewBuildingBlockAction;
import com.rapidminer.gui.actions.NewOperatorAction;
import com.rapidminer.gui.dialog.OperatorInfoScreen;
import com.rapidminer.gui.operatormenu.OperatorMenu;
import com.rapidminer.gui.operatortree.DnDSupport;
import com.rapidminer.gui.operatortree.OperatorTreeCellEditor;
import com.rapidminer.gui.operatortree.OperatorTreeCellRenderer;
import com.rapidminer.gui.operatortree.OperatorTreeModel;
import com.rapidminer.gui.operatortree.actions.AddAllBreakpointsAction;
import com.rapidminer.gui.operatortree.actions.CollapseAllAction;
import com.rapidminer.gui.operatortree.actions.CopyAction;
import com.rapidminer.gui.operatortree.actions.CutAction;
import com.rapidminer.gui.operatortree.actions.DeleteOperatorAction;
import com.rapidminer.gui.operatortree.actions.ExpandAllAction;
import com.rapidminer.gui.operatortree.actions.InfoOperatorAction;
import com.rapidminer.gui.operatortree.actions.LockTreeStructureAction;
import com.rapidminer.gui.operatortree.actions.PasteAction;
import com.rapidminer.gui.operatortree.actions.RemoveAllBreakpointsAction;
import com.rapidminer.gui.operatortree.actions.RenameOperatorAction;
import com.rapidminer.gui.operatortree.actions.SaveBuildingBlockAction;
import com.rapidminer.gui.operatortree.actions.ToggleActivationAction;
import com.rapidminer.gui.operatortree.actions.ToggleActivationItem;
import com.rapidminer.gui.operatortree.actions.ToggleBreakpointItem;
import com.rapidminer.gui.operatortree.actions.ToggleShowDisabledItem;
import com.rapidminer.gui.templates.NewBuildingBlockMenu;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.ProcessRootOperator;
import java.awt.Frame;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorTree
extends JTree
implements TreeSelectionListener,
TreeExpansionListener,
MouseListener {
    private static final long serialVersionUID = -6934683725946634563L;
    public final Action TOGGLE_ACTIVATION_ACTION = new ToggleActivationAction(this);
    public final Action NEW_OPERATOR_ACTION_24 = new NewOperatorAction(this, IconSize.SMALL);
    public final Action NEW_OPERATOR_ACTION_32 = new NewOperatorAction(this, IconSize.MIDDLE);
    public final Action NEW_BUILDING_BLOCK_ACTION_24 = new NewBuildingBlockAction(this, IconSize.SMALL);
    public final Action NEW_BUILDING_BLOCK_ACTION_32 = new NewBuildingBlockAction(this, IconSize.MIDDLE);
    public final Action CUT_ACTION_24 = new CutAction(this, IconSize.SMALL);
    public final Action CUT_ACTION_32 = new CutAction(this, IconSize.MIDDLE);
    public final Action COPY_ACTION_24 = new CopyAction(this, IconSize.SMALL);
    public final Action COPY_ACTION_32 = new CopyAction(this, IconSize.MIDDLE);
    public final Action PASTE_ACTION_24 = new PasteAction(this, IconSize.SMALL);
    public final Action PASTE_ACTION_32 = new PasteAction(this, IconSize.MIDDLE);
    public final Action DELETE_OPERATOR_ACTION_24 = new DeleteOperatorAction(this, IconSize.SMALL);
    public final Action DELETE_OPERATOR_ACTION_32 = new DeleteOperatorAction(this, IconSize.MIDDLE);
    public final Action RENAME_OPERATOR_ACTION_24 = new RenameOperatorAction(this, IconSize.SMALL);
    public final Action RENAME_OPERATOR_ACTION_32 = new RenameOperatorAction(this, IconSize.MIDDLE);
    public final Action INFO_OPERATOR_ACTION_24 = new InfoOperatorAction(this, IconSize.SMALL);
    public final Action INFO_OPERATOR_ACTION_32 = new InfoOperatorAction(this, IconSize.MIDDLE);
    public final Action SAVE_BUILDING_BLOCK_ACTION_24 = new SaveBuildingBlockAction(this, IconSize.SMALL);
    public final Action SAVE_BUILDING_BLOCK_ACTION_32 = new SaveBuildingBlockAction(this, IconSize.MIDDLE);
    public final ToggleBreakpointItem[] TOGGLE_BREAKPOINT = new ToggleBreakpointItem[]{new ToggleBreakpointItem(this, 0, IconSize.SMALL), new ToggleBreakpointItem(this, 1, IconSize.SMALL), new ToggleBreakpointItem(this, 2, IconSize.SMALL)};
    public final ToggleShowDisabledItem TOGGLE_SHOW_DISABLED = new ToggleShowDisabledItem(this, true);
    public final transient Action ADD_ALL_BREAKPOINTS_24 = new AddAllBreakpointsAction(this, IconSize.SMALL);
    public final transient Action ADD_ALL_BREAKPOINTS_32 = new AddAllBreakpointsAction(this, IconSize.MIDDLE);
    public final transient Action REMOVE_ALL_BREAKPOINTS_24 = new RemoveAllBreakpointsAction(this, IconSize.SMALL);
    public final transient Action REMOVE_ALL_BREAKPOINTS_32 = new RemoveAllBreakpointsAction(this, IconSize.MIDDLE);
    public final transient Action EXPAND_ALL_ACTION_24 = new ExpandAllAction(this, IconSize.SMALL);
    public final transient Action EXPAND_ALL_ACTION_32 = new ExpandAllAction(this, IconSize.MIDDLE);
    public final transient Action COLLAPSE_ALL_ACTION_24 = new CollapseAllAction(this, IconSize.SMALL);
    public final transient Action COLLAPSE_ALL_ACTION_32 = new CollapseAllAction(this, IconSize.MIDDLE);
    public final transient LockTreeStructureAction TOGGLE_STRUCTURE_LOCK_ACTION_24 = new LockTreeStructureAction(this, IconSize.SMALL);
    public final transient LockTreeStructureAction TOGGLE_STRUCTURE_LOCK_ACTION_32 = new LockTreeStructureAction(this, IconSize.MIDDLE);
    private MainFrame mainFrame;
    private transient OperatorTreeModel treeModel;
    private transient Operator clipBoard = null;
    private DragSource dragSource;
    private transient DnDSupport associatedDnDSupport;
    private boolean isStructureLocked = false;

    public OperatorTree(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.getInputMap(0).put(KeyStroke.getKeyStroke(88, 2), "cutAction");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(67, 2), "copyAction");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(86, 2), "pasteAction");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(69, 2), "toggleActivation");
        this.getActionMap().put("toggleActivation", this.TOGGLE_ACTIVATION_ACTION);
        this.getActionMap().put("cutAction", this.CUT_ACTION_24);
        this.getActionMap().put("copyAction", this.COPY_ACTION_24);
        this.getActionMap().put("pasteAction", this.PASTE_ACTION_24);
        this.associatedDnDSupport = new DnDSupport(this);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this.associatedDnDSupport);
        new DropTarget(this, 2, this.associatedDnDSupport, true);
        this.setCellRenderer(new OperatorTreeCellRenderer());
        this.setCellEditor(new OperatorTreeCellEditor(this));
        this.setEditable(true);
        this.setShowsRootHandles(true);
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        this.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setToggleClickCount(5);
        this.setRowHeight(0);
    }

    protected Object readResolve() {
        this.treeModel = new OperatorTreeModel(null, this);
        this.clipBoard = null;
        this.associatedDnDSupport = new DnDSupport(this);
        return this;
    }

    public DnDSupport getAssociatedDnDSupport() {
        return this.associatedDnDSupport;
    }

    public void setOperator(Operator root) {
        HashMap<String, Boolean> expansionMap = new HashMap<String, Boolean>();
        this.fillExpansionMap(root, expansionMap);
        boolean showDisabled = this.treeModel != null ? this.treeModel.showDisabledOperators() : true;
        this.treeModel = new OperatorTreeModel(root, this);
        this.treeModel.setShowDisabledOperators(showDisabled);
        this.setModel(this.treeModel);
        this.setRootVisible(true);
        this.restoreExpansionState(new TreePath(this.treeModel.getRoot()), expansionMap);
        expansionMap.clear();
    }

    private void fillExpansionMap(Operator operator, Map<String, Boolean> expansionMap) {
        if (operator instanceof OperatorChain) {
            if (operator.isExpanded()) {
                expansionMap.put(operator.getName(), true);
            } else {
                expansionMap.put(operator.getName(), false);
            }
        }
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            for (Operator child : chain.getAllInnerOperators()) {
                this.fillExpansionMap(child, expansionMap);
            }
        }
    }

    private void restoreExpansionState(TreePath path, Map<String, Boolean> expansionMap) {
        Operator operator = (Operator)path.getLastPathComponent();
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            for (Operator child : chain.getAllInnerOperators()) {
                TreePath childPath = path.pathByAddingChild(child);
                this.restoreExpansionState(childPath, expansionMap);
            }
        }
        if (operator instanceof OperatorChain) {
            if (expansionMap.get(operator.getName()).booleanValue()) {
                this.expandPath(path);
            } else {
                this.collapsePath(path);
            }
        }
    }

    public Operator getSelectedOperator() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (Operator)path.getLastPathComponent();
    }

    public Operator getClipBoard() {
        return this.clipBoard;
    }

    public boolean isStructureLocked() {
        return this.isStructureLocked;
    }

    public void setStructureLocked(boolean locked) {
        this.isStructureLocked = locked;
        this.TOGGLE_STRUCTURE_LOCK_ACTION_24.updateIcon();
        this.TOGGLE_STRUCTURE_LOCK_ACTION_32.updateIcon();
    }

    public void expandAll() {
        int row = 0;
        while (row < this.getRowCount()) {
            this.expandRow(row);
            ++row;
        }
    }

    public void collapseAll() {
        int row = this.getRowCount() - 1;
        while (row >= 0) {
            this.collapseRow(row);
            --row;
        }
    }

    public void completeRefresh() {
        this.treeModel.fireStructureChanged(this, new TreePath(this.treeModel.getRoot()));
    }

    public void refresh() {
        this.refresh(new TreePath(this.treeModel.getRoot()));
    }

    public void refresh(TreePath path) {
        this.treeModel.fireOperatorChanged(this, path);
        Object object = path.getLastPathComponent();
        int numberOfChildren = this.treeModel.getChildCount(object);
        int i = 0;
        while (i < numberOfChildren) {
            Object child = this.treeModel.getChild(object, i);
            this.refresh(path.pathByAddingChild(child));
            ++i;
        }
    }

    public void cut() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            this.clipBoard = selectedOperator;
            this.delete();
            if (this.mainFrame != null) {
                this.mainFrame.enableActions();
            }
        }
    }

    public void copy() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            this.clipBoard = selectedOperator.cloneOperator(selectedOperator.getName());
            if (this.mainFrame != null) {
                this.mainFrame.enableActions();
            }
        }
    }

    public void paste() {
        if (this.clipBoard != null) {
            this.insert(this.clipBoard);
            this.clipBoard = this.clipBoard.cloneOperator(this.clipBoard.getName());
        }
        if (this.mainFrame != null) {
            this.mainFrame.enableActions();
        }
    }

    public void delete() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        int index = this.treeModel.getIndexOfChild(selectedOperator.getParent(), selectedOperator);
        selectedOperator.remove();
        this.treeModel.fireOperatorRemoved(this, this.getSelectionPath().getParentPath(), index, selectedOperator);
        if (this.mainFrame != null) {
            this.mainFrame.processChanged();
            this.mainFrame.enableActions();
        }
    }

    public void insert(Operator newOperator) {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        if (selectedOperator instanceof OperatorChain) {
            int index = ((OperatorChain)selectedOperator).addOperator(newOperator);
            this.treeModel.fireOperatorInserted(this, this.getSelectionPath(), index, newOperator);
            this.scrollPathToVisible(this.getSelectionPath().pathByAddingChild(newOperator));
            if (this.mainFrame != null) {
                this.mainFrame.processChanged();
            }
        } else {
            OperatorChain parentChain = selectedOperator.getParent();
            int parentIndex = parentChain.getIndexOfOperator(selectedOperator, true) + 1;
            int index = parentChain.addOperator(newOperator, parentIndex);
            this.treeModel.fireOperatorInserted(this, this.getSelectionPath().getParentPath(), index, newOperator);
            this.scrollPathToVisible(this.getSelectionPath().getParentPath().pathByAddingChild(newOperator));
            if (this.mainFrame != null) {
                this.mainFrame.processChanged();
            }
        }
    }

    public void renameOperator() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            this.startEditingAtPath(path);
        }
    }

    public void replace(Operator operator) {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        OperatorChain parent = selectedOperator.getParent();
        if (parent == null) {
            return;
        }
        int oldPos = this.treeModel.getIndexOfChild(parent, selectedOperator);
        if (selectedOperator instanceof OperatorChain && operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)selectedOperator;
            OperatorChain newChain = (OperatorChain)operator;
            while (chain.getNumberOfAllOperators() > 0) {
                Operator child = chain.getOperatorFromAll(0);
                child.remove();
                newChain.addOperator(child);
            }
        }
        selectedOperator.remove();
        parent.addOperator(operator, oldPos);
        TreePath path = this.getSelectionPath().getParentPath();
        this.treeModel.fireStructureChanged(this, path);
        this.setSelectionPath(path.pathByAddingChild(operator));
        if (this.mainFrame != null) {
            this.mainFrame.processChanged();
        }
    }

    public void showOperatorInfo() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            OperatorInfoScreen infoScreen = new OperatorInfoScreen((Frame)this.mainFrame, selectedOperator);
            infoScreen.setVisible(true);
        }
    }

    public void addAllBreakpoints() {
        this.addAllBreakpoints((Operator)this.treeModel.getRoot());
        this.refresh();
    }

    private void addAllBreakpoints(Operator operator) {
        operator.setBreakpoint(0, false);
        operator.setBreakpoint(1, false);
        operator.setBreakpoint(2, true);
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            int i = 0;
            while (i < chain.getNumberOfOperators()) {
                this.addAllBreakpoints(chain.getOperator(i));
                ++i;
            }
        }
    }

    public void removeAllBreakpoints() {
        this.removeAllBreakpoints((Operator)this.treeModel.getRoot());
        this.refresh();
    }

    private void removeAllBreakpoints(Operator operator) {
        operator.setBreakpoint(0, false);
        operator.setBreakpoint(1, false);
        operator.setBreakpoint(2, false);
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            int i = 0;
            while (i < chain.getNumberOfOperators()) {
                this.removeAllBreakpoints(chain.getOperator(i));
                ++i;
            }
        }
    }

    public void toggleOperatorActivation() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            boolean state = selectedOperator.isEnabled();
            this.toggleOperatorActivation(!state);
        }
    }

    public void toggleOperatorActivation(boolean state) {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            selectedOperator.setEnabled(state);
            this.repaint();
            if (this.mainFrame != null) {
                this.mainFrame.processChanged();
            }
        }
    }

    public void toggleShowDisabledOperators() {
        this.treeModel.setShowDisabledOperators(!this.treeModel.showDisabledOperators());
        this.completeRefresh();
    }

    public void toggleBreakpoint(int position, boolean state) {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            selectedOperator.setBreakpoint(position, state);
            this.TOGGLE_BREAKPOINT[position].setSelected(state);
            this.refresh();
            if (this.mainFrame != null) {
                this.mainFrame.processChanged();
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Operator selectedOperator = this.getSelectedOperator();
        if (this.mainFrame != null) {
            this.mainFrame.getPropertyTable().editingStopped(new ChangeEvent(this));
            this.mainFrame.getMainProcessEditor().changeFromNewOperator2ParameterEditor();
            this.mainFrame.notifyEditorsOfChange(selectedOperator);
        }
        if (selectedOperator == null) {
            return;
        }
        if (this.mainFrame != null) {
            this.mainFrame.enableActions();
        }
        int i = 0;
        while (i < this.TOGGLE_BREAKPOINT.length) {
            this.TOGGLE_BREAKPOINT[i].setState(selectedOperator.hasBreakpoint(i));
            ++i;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int selRow = this.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        if (selRow != -1) {
            if (e.getClickCount() == 1) {
                this.evaluateSingleClick(selRow, selPath);
            } else if (e.getClickCount() == 2) {
                this.evaluateDoubleClick(selRow, selPath);
            }
        }
        this.evaluatePopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.evaluatePopup(e);
    }

    private void evaluateSingleClick(int row, TreePath path) {
        this.setSelectionPath(path);
        if (this.mainFrame != null) {
            this.mainFrame.enableActions();
        }
    }

    private void evaluateDoubleClick(int row, TreePath path) {
        this.setSelectionPath(path);
        if (this.getSelectedOperator().hasBreakpoint()) {
            this.toggleBreakpoint(0, false);
            this.toggleBreakpoint(1, false);
            this.toggleBreakpoint(2, false);
        } else {
            this.toggleBreakpoint(2, true);
        }
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createOperatorPopupMenu().show(this, e.getX(), e.getY());
        }
    }

    public void addOperatorMenuItems(JMenu menu) {
        menu.add(this.RENAME_OPERATOR_ACTION_24);
        menu.add(this.COPY_ACTION_24);
        menu.add(this.CUT_ACTION_24);
        menu.add(this.PASTE_ACTION_24);
        menu.add(this.DELETE_OPERATOR_ACTION_24);
        menu.addSeparator();
        menu.add(this.SAVE_BUILDING_BLOCK_ACTION_24);
    }

    private JPopupMenu createOperatorPopupMenu() {
        Operator op = this.getSelectedOperator();
        JPopupMenu menu = new JPopupMenu();
        if (op != null && op instanceof OperatorChain) {
            menu.add(OperatorMenu.NEW_OPERATOR_MENU);
        }
        if (op != null && !(op instanceof ProcessRootOperator)) {
            if (op instanceof OperatorChain && ((OperatorChain)op).getNumberOfAllOperators() > 0) {
                menu.add(OperatorMenu.REPLACE_OPERATORCHAIN_MENU);
            } else {
                menu.add(OperatorMenu.REPLACE_OPERATOR_MENU);
            }
        }
        if (op != null && op instanceof OperatorChain) {
            final NewBuildingBlockMenu buildingBlockMenu = new NewBuildingBlockMenu();
            menu.add(buildingBlockMenu);
            buildingBlockMenu.addMenuListener(new MenuListener(){

                public void menuCanceled(MenuEvent e) {
                }

                public void menuDeselected(MenuEvent e) {
                }

                public void menuSelected(MenuEvent e) {
                    buildingBlockMenu.addAllMenuItems();
                }
            });
        }
        menu.add(this.SAVE_BUILDING_BLOCK_ACTION_24);
        menu.addSeparator();
        if (op != null && !(op instanceof ProcessRootOperator)) {
            ToggleActivationItem activationItem = new ToggleActivationItem(this, op.isEnabled());
            if (op.getParent() != null && !op.getParent().isEnabled()) {
                activationItem.setEnabled(false);
            }
            menu.add(activationItem);
        }
        menu.add(this.TOGGLE_SHOW_DISABLED);
        menu.addSeparator();
        menu.add(this.RENAME_OPERATOR_ACTION_24);
        menu.add(this.DELETE_OPERATOR_ACTION_24);
        menu.add(this.COPY_ACTION_24);
        menu.add(this.CUT_ACTION_24);
        menu.add(this.PASTE_ACTION_24);
        menu.addSeparator();
        menu.add(this.INFO_OPERATOR_ACTION_24);
        menu.addSeparator();
        int i = 0;
        while (i < this.TOGGLE_BREAKPOINT.length) {
            menu.add(this.TOGGLE_BREAKPOINT[i]);
            ++i;
        }
        menu.add(this.ADD_ALL_BREAKPOINTS_24);
        menu.add(this.REMOVE_ALL_BREAKPOINTS_24);
        menu.addSeparator();
        menu.add(this.EXPAND_ALL_ACTION_24);
        menu.add(this.COLLAPSE_ALL_ACTION_24);
        menu.add(this.TOGGLE_STRUCTURE_LOCK_ACTION_24);
        return menu;
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        Operator operator = (Operator)event.getPath().getLastPathComponent();
        operator.setExpanded(false);
        if (this.mainFrame != null) {
            this.mainFrame.processChanged();
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        Operator operator = (Operator)event.getPath().getLastPathComponent();
        operator.setExpanded(true);
        if (this.mainFrame != null) {
            this.mainFrame.processChanged();
        }
    }
}

