/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.ConsoleInputHandler;
import com.rapidminer.InputHandler;
import com.rapidminer.Process;
import com.rapidminer.Version;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.tools.SplashScreen;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ObjectVisualizerService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.WekaTools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.XMLSerialization;
import com.rapidminer.tools.cipher.CipherTools;
import com.rapidminer.tools.cipher.KeyGenerationException;
import com.rapidminer.tools.cipher.KeyGeneratorTool;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.plugin.Plugin;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RapidMiner {
    public static final String SYSTEM_ENCODING_NAME = "SYSTEM";
    public static final String PROPERTY_RAPIDMINER_HOME = "rapidminer.home";
    public static final String PROPERTY_RAPIDMINER_VERSION = "rapidminer.version";
    public static final String PROPERTY_RAPIDMINER_OPERATORS_ADDITIONAL = "rapidminer.operators.additional";
    public static final String PROPERTY_RAPIDMINER_OBJECTS_ADDITIONAL = "rapidminer.objects.additional";
    public static final String PROPERTY_RAPIDMINER_RC_FILE = "rapidminer.rcfile";
    public static final String PROPERTY_RAPIDMINER_WEKA_JAR = "rapidminer.weka.jar";
    public static final String PROPERTY_RAPIDMINER_GLOBAL_LOG_FILE = "rapidminer.global.logging.file";
    public static final String PROPERTY_RAPIDMINER_GLOBAL_LOG_VERBOSITY = "rapidminer.global.logging.verbosity";
    public static final String PROPERTY_RAPIDMINER_INIT_OPERATORS = "rapidminer.init.operators";
    public static final String PROPERTY_RAPIDMINER_INIT_WEKA = "rapidminer.init.weka";
    public static final String PROPERTY_RAPIDMINER_INIT_JDBC_LIB_LOCATION = "rapidminer.init.jdbc.location";
    public static final String PROPERTY_RAPIDMINER_INIT_JDBC_LIB = "rapidminer.init.jdbc.lib";
    public static final String PROPERTY_RAPIDMINER_INIT_JDBC_CLASSPATH = "rapidminer.init.jdbc.classpath";
    public static final String PROPERTY_RAPIDMINER_INIT_PLUGINS = "rapidminer.init.plugins";
    public static final String PROPERTY_RAPIDMINER_INIT_PLUGINS_LOCATION = "rapidminer.init.plugins.location";
    public static final String PROPERTY_RAPIDMINER_GENERAL_FRACTIONDIGITS_NUMBERS = "rapidminer.general.fractiondigits.numbers";
    public static final String PROPERTY_RAPIDMINER_GENERAL_FRACTIONDIGITS_PERCENT = "rapidminer.general.fractiondigits.percent";
    public static final String PROPERTY_RAPIDMINER_TOOLS_EDITOR = "rapidminer.tools.editor";
    public static final String PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD = "rapidminer.tools.mail.method";
    public static final String[] PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_VALUES = new String[]{"sendmail", "SMTP"};
    public static final int PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_SENDMAIL = 0;
    public static final int PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_SMTP = 1;
    public static final String PROPERTY_RAPIDMINER_TOOLS_MAIL_DEFAULT_RECIPIENT = "rapidminer.tools.mail.default_recipient";
    public static final String PROPERTY_RAPIDMINER_TOOLS_MAIL_DEFAULT_PROCESS_DURATION_FOR_MAIL = "rapidminer.tools.mail.process_duration_for_mail";
    public static final String PROPERTY_RAPIDMINER_TOOLS_SENDMAIL_COMMAND = "rapidminer.tools.sendmail.command";
    public static final String PROPERTY_RAPIDMINER_TOOLS_SMTP_HOST = "rapidminer.tools.smtp.host";
    public static final String PROPERTY_RAPIDMINER_TOOLS_SMTP_PORT = "rapidminer.tools.smtp.port";
    public static final String PROPERTY_RAPIDMINER_TOOLS_SMTP_USER = "rapidminer.tools.smtp.user";
    public static final String PROPERTY_RAPIDMINER_TOOLS_SMTP_PASSWD = "rapidminer.tools.smtp.passwd";
    public static final String PROPERTY_RAPIDMINER_GENERAL_LOGFILE_FORMAT = "rapidminer.general.logfile.format";
    public static final String PROPERTY_RAPIDMINER_GENERAL_DEBUGMODE = "rapidminer.general.debugmode";
    public static final String PROPERTY_RAPIDMINER_GENERAL_DEFAULT_ENCODING = "rapidminer.general.encoding";
    public static final String PROPERTY_RAPIDMINER_GENERAL_TIME_ZONE = "rapidminer.general.timezone";
    private static final Set<ParameterType> PROPERTY_TYPES = new TreeSet<ParameterType>();
    private static InputHandler inputHandler;
    private static SplashScreen splashScreen;

    static {
        System.setProperty(PROPERTY_RAPIDMINER_VERSION, RapidMiner.getLongVersion());
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GENERAL_FRACTIONDIGITS_NUMBERS, "The number of fraction digits of formatted numbers.", 0, Integer.MAX_VALUE, 3));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GENERAL_FRACTIONDIGITS_PERCENT, "The number of fraction digits of formatted percent values.", 0, Integer.MAX_VALUE, 2));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_EDITOR, "Path to external Java editor. %f is replaced by filename and %l by the linenumber.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeCategory(PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD, "Method to send outgoing mails. Either SMTP or sendmail.", PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_VALUES, 0));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_MAIL_DEFAULT_RECIPIENT, "Default recipient for outgoing mails.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_TOOLS_MAIL_DEFAULT_PROCESS_DURATION_FOR_MAIL, "Default process duration time necessary to send notification emails (in minutes).", 0, Integer.MAX_VALUE, 30));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_SENDMAIL_COMMAND, "Path to sendmail. Used for email notifications.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_SMTP_HOST, "SMTP host. Used for email notifications.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_SMTP_PORT, "SMTP port, defaults to 25. Used for email notifications.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_SMTP_USER, "SMTP user name. Used for email notifications.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypePassword(PROPERTY_RAPIDMINER_TOOLS_SMTP_PASSWD, "SMTP password, if required. Used for email notifications."));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GENERAL_LOGFILE_FORMAT, "Use unix special characters for logfile highlighting (requires new RapidMiner instance).", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GENERAL_DEBUGMODE, "Indicates if RapidMiner should be used in debug mode (print exception stacks and shows more technical error messages)", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_GENERAL_DEFAULT_ENCODING, "The default encoding used for file operations (default: 'SYSTEM' uses the underlying system encoding, 'UTF-8' or 'ISO-8859-1' are other common options)", SYSTEM_ENCODING_NAME));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeCategory(PROPERTY_RAPIDMINER_GENERAL_TIME_ZONE, "The default time zone used for displaying date and time information (default: 'SYSTEM' uses the underlying system encoding, 'UCT', 'GMT' or 'CET' are other common options)", Tools.getAllTimeZones(), 0));
        inputHandler = new ConsoleInputHandler();
    }

    public static String getShortVersion() {
        return Version.getShortVersion();
    }

    public static String getLongVersion() {
        return Version.getLongVersion();
    }

    @Deprecated
    public static Process readExperimentFile(File experimentfile) throws XMLException, IOException, InstantiationException, IllegalAccessException {
        return RapidMiner.readProcessFile(experimentfile);
    }

    public static Process readProcessFile(File processFile) throws XMLException, IOException, InstantiationException, IllegalAccessException {
        try {
            LogService.getGlobal().log("Reading process file '" + processFile + "'.", 2);
            if (!processFile.exists() || !processFile.canRead()) {
                LogService.getGlobal().log("Cannot read config file '" + processFile + "'!", 7);
            }
            return new Process(processFile);
        }
        catch (XMLException e) {
            throw new XMLException(String.valueOf(processFile.getName()) + ":" + e.getMessage());
        }
    }

    public static void init(InputStream operatorsXMLStream, File pluginDir, boolean addWekaOperators, boolean searchJDBCInLibDir, boolean searchJDBCInClasspath, boolean addPlugins) {
        RapidMiner.init(operatorsXMLStream, null, pluginDir, addWekaOperators, searchJDBCInLibDir, searchJDBCInClasspath, addPlugins);
    }

    public static void init(InputStream operatorsXMLStream, File pluginDir, File jdbcDir, boolean addWekaOperators, boolean searchJDBCInLibDir, boolean searchJDBCInClasspath, boolean addPlugins) {
        RapidMiner.init(operatorsXMLStream, null, pluginDir, jdbcDir, addWekaOperators, searchJDBCInLibDir, searchJDBCInClasspath, addPlugins);
    }

    public static void init(InputStream operatorsXMLStream, InputStream additionalXMLStream, File pluginDir, File jdbcDir, boolean addWekaOperators, boolean searchJDBCInLibDir, boolean searchJDBCInClasspath, boolean addPlugins) {
        RapidMiner.splashMessage("Using US Local");
        Locale.setDefault(Locale.US);
        RapidMiner.splashMessage("Ensure RapidMiner Home is set");
        ParameterService.ensureRapidMinerHomeSet();
        if (addPlugins) {
            RapidMiner.splashMessage("Register Plugins");
            Plugin.registerAllPlugins(pluginDir, true);
            Plugin.initPlugins();
        }
        Plugin.initPluginSplashTexts();
        RapidMiner.showSplashInfos();
        RapidMiner.splashMessage("Init Setup");
        File wekaJar = null;
        try {
            wekaJar = WekaTools.getWekaJarAsFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String wekaMessage = String.valueOf(addWekaOperators);
        if (wekaJar == null || !wekaJar.exists()) {
            wekaMessage = "weka not found";
            addWekaOperators = false;
        }
        LogService.getGlobal().log("----------------------------------------------------", 3);
        LogService.getGlobal().log("Initialization Settings", 3);
        LogService.getGlobal().log("----------------------------------------------------", 3);
        LogService.getGlobal().log("Default system encoding for IO: " + Tools.getDefaultEncoding(), 3);
        LogService.getGlobal().log("Load " + (operatorsXMLStream == null ? "core" : "specific") + " operators...", 3);
        LogService.getGlobal().log("Load Weka operators: " + wekaMessage, 3);
        LogService.getGlobal().log("Load JDBC drivers from lib directory: " + searchJDBCInLibDir, 3);
        LogService.getGlobal().log("Load JDBC drivers from classpath: " + searchJDBCInClasspath, 3);
        LogService.getGlobal().log("Load plugins: " + addPlugins, 3);
        LogService.getGlobal().log("Load plugins from '" + (pluginDir == null ? ParameterService.getPluginDir() : pluginDir) + "'", 3);
        LogService.getGlobal().log("----------------------------------------------------", 3);
        RapidMiner.splashMessage("Initializing Operators");
        ParameterService.init(operatorsXMLStream, additionalXMLStream, addWekaOperators);
        RapidMiner.splashMessage("Loading JDBC Drivers");
        DatabaseService.init(jdbcDir, searchJDBCInLibDir, searchJDBCInClasspath);
        RapidMiner.splashMessage("Initialize XML serialization");
        XMLSerialization.init(Plugin.getMajorClassLoader());
        RapidMiner.splashMessage("Define XML Serialization Alias Pairs");
        OperatorService.defineXMLAliasPairs();
        if (!CipherTools.isKeyAvailable()) {
            RapidMiner.splashMessage("Generate Encryption Key");
            try {
                KeyGeneratorTool.createAndStoreKey();
            }
            catch (KeyGenerationException e) {
                LogService.getGlobal().logError("Cannot generate encryption key: " + e.getMessage());
            }
        }
        RapidMiner.splashMessage("Initialize renderers");
        RendererService.init();
    }

    private static void showSplashInfos() {
        if (RapidMiner.getSplashScreen() != null) {
            RapidMiner.getSplashScreen().setInfosVisible(true);
        }
    }

    public static void init(InputStream operatorsXMLStream, boolean addWekaOperators, boolean searchJDBCInLibDir, boolean searchJDBCInClasspath, boolean addPlugins) {
        RapidMiner.init(operatorsXMLStream, null, addWekaOperators, searchJDBCInLibDir, searchJDBCInClasspath, addPlugins);
    }

    public static void init(boolean addWekaOperators, boolean searchJDBCInLibDir, boolean searchJDBCInClasspath, boolean addPlugins) {
        RapidMiner.init(null, addWekaOperators, searchJDBCInLibDir, searchJDBCInClasspath, addPlugins);
    }

    public static void init() {
        block15: {
            File pluginDir = null;
            String pluginDirString = System.getProperty(PROPERTY_RAPIDMINER_INIT_PLUGINS_LOCATION);
            if (pluginDirString != null) {
                pluginDir = new File(pluginDirString);
            }
            String loadWekaString = System.getProperty(PROPERTY_RAPIDMINER_INIT_WEKA);
            boolean loadWeka = Tools.booleanValue(loadWekaString, true);
            String loadJDBCDirString = System.getProperty(PROPERTY_RAPIDMINER_INIT_JDBC_LIB);
            boolean loadJDBCDir = Tools.booleanValue(loadJDBCDirString, true);
            File jdbcDir = null;
            String jdbcDirString = System.getProperty(PROPERTY_RAPIDMINER_INIT_JDBC_LIB_LOCATION);
            if (jdbcDirString != null) {
                jdbcDir = new File(jdbcDirString);
            }
            String loadJDBCClasspathString = System.getProperty(PROPERTY_RAPIDMINER_INIT_JDBC_CLASSPATH);
            boolean loadJDBCClasspath = Tools.booleanValue(loadJDBCClasspathString, false);
            String loadPluginsString = System.getProperty(PROPERTY_RAPIDMINER_INIT_PLUGINS);
            boolean loadPlugins = Tools.booleanValue(loadPluginsString, true);
            InputStream operatorStream = null;
            try {
                try {
                    String operatorsXML = System.getProperty(PROPERTY_RAPIDMINER_INIT_OPERATORS);
                    if (operatorsXML != null) {
                        operatorStream = new FileInputStream(operatorsXML);
                    }
                    RapidMiner.init(operatorStream, pluginDir, jdbcDir, loadWeka, loadJDBCDir, loadJDBCClasspath, loadPlugins);
                }
                catch (IOException iOException) {
                    if (operatorStream == null) break block15;
                    try {
                        operatorStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (operatorStream != null) {
                    try {
                        operatorStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void cleanUp() {
        ObjectVisualizerService.clearVisualizers();
    }

    public static SplashScreen showSplash() {
        URL url = Tools.getResource("rapidminer_logo.png");
        BufferedImage logo = null;
        try {
            if (url != null) {
                logo = ImageIO.read(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return RapidMiner.showSplash(logo);
    }

    public static SplashScreen showSplash(Image productLogo) {
        splashScreen = new SplashScreen(RapidMiner.getShortVersion(), productLogo);
        splashScreen.showSplashScreen();
        return splashScreen;
    }

    public static void hideSplash() {
        splashScreen.dispose();
    }

    public static void splashMessage(String message) {
        if (splashScreen != null) {
            splashScreen.setMessage(message);
        }
    }

    public static SplashScreen getSplashScreen() {
        return splashScreen;
    }

    public static Frame getSplashScreenFrame() {
        if (splashScreen != null) {
            return splashScreen.getSplashScreenFrame();
        }
        return null;
    }

    public static void setInputHandler(InputHandler inputHandler) {
        RapidMiner.inputHandler = inputHandler;
    }

    public static InputHandler getInputHandler() {
        return inputHandler;
    }

    @Deprecated
    public static Set<ParameterType> getYaleProperties() {
        return RapidMiner.getRapidMinerProperties();
    }

    public static Set<ParameterType> getRapidMinerProperties() {
        return PROPERTY_TYPES;
    }

    @Deprecated
    public static void registerYaleProperty(ParameterType type) {
        RapidMiner.registerRapidMinerProperty(type);
    }

    public static void registerRapidMinerProperty(ParameterType type) {
        PROPERTY_TYPES.add(type);
    }

    public static void quit(int errorcode) {
        try {
            Runtime.getRuntime().runFinalization();
        }
        catch (Exception e) {
            System.err.println("ERROR during SHUTDOWN: " + e.getMessage());
        }
        System.exit(errorcode);
    }
}

