/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenSampleStream
extends FilterObjectStream<String, TokenSample> {
    private final String separatorChars;

    public TokenSampleStream(ObjectStream<String> sampleStrings, String separatorChars) {
        super(sampleStrings);
        if (sampleStrings == null || separatorChars == null) {
            throw new IllegalArgumentException("parameters must not be null!");
        }
        this.separatorChars = separatorChars;
    }

    public TokenSampleStream(ObjectStream<String> sentences) {
        this(sentences, "<SPLIT>");
    }

    @Override
    public TokenSample read() throws IOException {
        String sampleString = (String)this.samples.read();
        if (sampleString != null) {
            return TokenSample.parse(sampleString, this.separatorChars);
        }
        return null;
    }
}

