/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.IOException;
import java.io.Reader;
import opennlp.maxent.Evalable;
import opennlp.maxent.GIS;
import opennlp.model.Event;
import opennlp.model.EventStream;
import opennlp.model.MaxentModel;

public class TrainEval {
    public static void eval(MaxentModel model, Reader r, Evalable e) {
        TrainEval.eval(model, r, e, false);
    }

    public static void eval(MaxentModel model, Reader r, Evalable e, boolean verbose) {
        float totPos = 0.0f;
        float truePos = 0.0f;
        float falsePos = 0.0f;
        Event[] events = e.getEventCollector(r).getEvents(true);
        String negOutcome = e.getNegativeOutcome();
        for (int i = 0; i < events.length; ++i) {
            String guess = model.getBestOutcome(model.eval(events[i].getContext()));
            String ans = events[i].getOutcome();
            if (verbose) {
                System.out.println(ans + " " + guess);
            }
            if (!ans.equals(negOutcome)) {
                totPos += 1.0f;
            }
            if (!guess.equals(negOutcome) && !guess.equals(ans)) {
                falsePos += 1.0f;
                continue;
            }
            if (!ans.equals(guess)) continue;
            truePos += 1.0f;
        }
        System.out.println("Precision: " + truePos / (truePos + falsePos));
        System.out.println("Recall:    " + truePos / totPos);
    }

    public static MaxentModel train(EventStream events, int cutoff) throws IOException {
        return GIS.trainModel(events, 100, cutoff);
    }

    public static void run(String[] args, Evalable e) throws IOException {
    }
}

