/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import marytts.cart.DecisionNode;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.util.data.MaryHeader;

public class WagonCARTReader {
    private Node rootNode;
    private Node lastNode;
    private FeatureDefinition featDef;
    private int openBrackets;
    private LeafNode.LeafType leafType;
    private int targetFeature;

    public WagonCARTReader(LeafNode.LeafType leafType) {
        this.leafType = leafType;
    }

    protected LeafNode createLeafNode(String line) {
        if (this.leafType == LeafNode.LeafType.IntArrayLeafNode) {
            return this.createIntArrayLeafNode(line);
        }
        if (this.leafType == LeafNode.LeafType.IntAndFloatArrayLeafNode) {
            return this.createIntAndFloatArrayLeafNode(line);
        }
        if (this.leafType == LeafNode.LeafType.FloatLeafNode) {
            return this.createFloatLeafNode(line);
        }
        if (this.leafType == LeafNode.LeafType.FeatureVectorLeafNode) {
            return this.createFeatureVectorLeafNode(line);
        }
        if (this.leafType == LeafNode.LeafType.StringAndFloatLeafNode) {
            return this.createStringAndFloatLeafNode(line);
        }
        return null;
    }

    private void cleadReader() {
        this.rootNode = null;
        this.lastNode = null;
        this.featDef = null;
        this.openBrackets = 0;
    }

    public Node load(BufferedReader reader, FeatureDefinition featDefinition) throws IOException {
        this.cleadReader();
        this.featDef = featDefinition;
        this.openBrackets = 0;
        String line = reader.readLine();
        if (line.equals("")) {
            line = reader.readLine();
        }
        while (line != null) {
            if (!line.startsWith(";;") && !line.equals("")) {
                this.parseAndAdd(line);
            }
            line = reader.readLine();
        }
        if (this.openBrackets != 0) {
            throw new IOException("Error loading CART: bracket mismatch");
        }
        if (this.rootNode instanceof DecisionNode) {
            ((DecisionNode)this.rootNode).countData();
        }
        return this.rootNode;
    }

    public Node load(String fileName, FeatureDefinition featDefinition, String[] dummy) throws IOException, MaryConfigurationException {
        this.cleadReader();
        DataInputStream raf = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        MaryHeader maryHeader = new MaryHeader(raf);
        if (!maryHeader.hasCurrentVersion()) {
            throw new IOException("Wrong version of database file");
        }
        if (maryHeader.getType() != 100) {
            throw new IOException("No CARTs file");
        }
        int numNodes = raf.readInt();
        raf.readUTF();
        this.featDef = featDefinition;
        this.openBrackets = 0;
        try {
            while (true) {
                int length = raf.readInt();
                char[] cartChars = new char[length];
                for (int i = 0; i < length; ++i) {
                    cartChars[i] = raf.readChar();
                }
                String cart = new String(cartChars);
                this.parseAndAdd(cart);
            }
        }
        catch (EOFException eof) {
            if (this.openBrackets != 0) {
                throw new IOException("Error loading CART: bracket mismatch: " + this.openBrackets);
            }
            if (this.rootNode instanceof DecisionNode) {
                ((DecisionNode)this.rootNode).countData();
            }
            return this.rootNode;
        }
    }

    private void parseAndAdd(String line) throws IOException {
        if (!(line = line.trim()).startsWith("((")) {
            throw new IOException("Invalid input line for CART: " + line);
        }
        if (Character.isLetter(line.charAt(2)) && !line.substring(2, 6).equals("nan ")) {
            DecisionNode nextNode;
            block20: {
                ++this.openBrackets;
                StringTokenizer tokenizer = new StringTokenizer(line, " ");
                String feature = tokenizer.nextToken().substring(2);
                String type = tokenizer.nextToken();
                String value = tokenizer.nextToken();
                if ((value = value.substring(0, value.length() - 1)).startsWith("\"") && value.endsWith("\"") && value.length() > 2) {
                    value = value.substring(1, value.length() - 1);
                }
                if (value.contains("\\\"")) {
                    value = value.replaceAll("\\\\\"", "\"");
                }
                try {
                    if (type.equals("is")) {
                        nextNode = this.featDef.isByteFeature(feature) ? new DecisionNode.BinaryByteDecisionNode(feature, value, this.featDef) : new DecisionNode.BinaryShortDecisionNode(feature, value, this.featDef);
                        break block20;
                    }
                    if (type.equals("<")) {
                        nextNode = new DecisionNode.BinaryFloatDecisionNode(feature, Float.parseFloat(value), this.featDef);
                        break block20;
                    }
                    if (type.equals("isShortOf")) {
                        nextNode = new DecisionNode.ShortDecisionNode(feature, Integer.parseInt(value), this.featDef);
                        break block20;
                    }
                    if (type.equals("isByteOf")) {
                        nextNode = new DecisionNode.ByteDecisionNode(feature, Integer.parseInt(value), this.featDef);
                        break block20;
                    }
                    throw new IOException("Unknown node type : " + type);
                }
                catch (Exception exc) {
                    throw new RuntimeException("Cannot create decision node for cart line: '" + line + "'", exc);
                }
            }
            if (this.lastNode != null) {
                ((DecisionNode)this.lastNode).addDaughter(nextNode);
            } else {
                this.rootNode = nextNode;
                nextNode.setIsRoot(true);
            }
            this.lastNode = nextNode;
        } else {
            Node nextNode = this.createLeafNode(line);
            if (this.lastNode == null) {
                this.rootNode = nextNode;
                nextNode.setIsRoot(true);
            } else {
                ((DecisionNode)this.lastNode).addDaughter(nextNode);
            }
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            int numTokens = tokenizer.countTokens();
            for (int i = 0; i < numTokens - 1; ++i) {
                tokenizer.nextToken();
            }
            String lastToken = tokenizer.nextToken();
            int length = lastToken.length();
            for (int index = lastToken.indexOf(41) + 2; index < length; ++index) {
                char nextChar = lastToken.charAt(index);
                if (nextChar == ')') {
                    --this.openBrackets;
                    if (this.lastNode.isRoot()) {
                        if (index + 1 == length) continue;
                        throw new IOException("Too many closing brackets in line " + line);
                    }
                    nextNode = this.lastNode;
                    this.lastNode = this.lastNode.getMother();
                    continue;
                }
                throw new IOException("Expected closing bracket in line " + line + ", but found " + nextChar);
            }
            if (nextNode != null) {
                int nodeIndex = nextNode.getNodeIndex();
            }
        }
    }

    protected LeafNode createIntArrayLeafNode(String line) {
        int[] indices;
        StringTokenizer tok = new StringTokenizer(line, " ");
        int numTokens = tok.countTokens();
        int index = 0;
        if (numTokens == 2) {
            tok.nextToken();
            indices = new int[]{};
        } else {
            indices = new int[(numTokens - 1) / 2];
            while (index * 2 < numTokens - 1) {
                String nextToken = tok.nextToken();
                nextToken = index == 0 ? nextToken.substring(4) : nextToken.substring(1);
                indices[index] = Integer.parseInt(nextToken);
                tok.nextToken();
                ++index;
            }
        }
        return new LeafNode.IntArrayLeafNode(indices);
    }

    protected LeafNode createIntAndFloatArrayLeafNode(String line) {
        float[] probs;
        int[] indices;
        StringTokenizer tok = new StringTokenizer(line, " ");
        int numTokens = tok.countTokens();
        int index = 0;
        if (numTokens == 2) {
            tok.nextToken();
            indices = new int[]{};
            probs = new float[]{};
        } else {
            indices = new int[(numTokens - 1) / 2];
            probs = new float[indices.length];
            while (index * 2 < numTokens - 1) {
                String token = tok.nextToken();
                token = index == 0 ? token.substring(4) : token.substring(1);
                indices[index] = Integer.parseInt(token);
                token = tok.nextToken();
                int lastIndex = token.length() - 1;
                if (index * 2 == numTokens - 3) {
                    if ((token = token.substring(0, lastIndex - 1)).equals("inf")) {
                        probs[index] = 10000.0f;
                        ++index;
                        continue;
                    }
                    if (token.equals("nan")) {
                        probs[index] = -1.0f;
                        ++index;
                        continue;
                    }
                } else {
                    if ((token = token.substring(0, lastIndex)).equals("inf")) {
                        probs[index] = 1000000.0f;
                        ++index;
                        continue;
                    }
                    if (token.equals("nan")) {
                        probs[index] = -1.0f;
                        ++index;
                        continue;
                    }
                }
                probs[index] = Float.parseFloat(token);
                ++index;
            }
        }
        return new LeafNode.IntAndFloatArrayLeafNode(indices, probs);
    }

    protected LeafNode createFloatLeafNode(String line) {
        StringTokenizer tok = new StringTokenizer(line, " ");
        int numTokens = tok.countTokens();
        if (numTokens != 2) {
            throw new IllegalArgumentException("Expected two tokens in line, got " + numTokens + ": '" + line + "'");
        }
        float[] data = new float[2];
        String nextToken = tok.nextToken();
        nextToken = nextToken.substring(2);
        try {
            data[0] = Float.parseFloat(nextToken);
        }
        catch (NumberFormatException nfe) {
            data[0] = 0.0f;
        }
        nextToken = tok.nextToken();
        nextToken = nextToken.substring(0, nextToken.indexOf(")"));
        try {
            data[1] = Float.parseFloat(nextToken);
        }
        catch (NumberFormatException nfe) {
            data[1] = 0.0f;
        }
        return new LeafNode.FloatLeafNode(data);
    }

    protected LeafNode createFeatureVectorLeafNode(String line) {
        StringTokenizer tok = new StringTokenizer(line, " ");
        int numTokens = tok.countTokens();
        boolean index = false;
        if (numTokens != 2) {
            throw new Error("Leaf in line " + line + " is not empty");
        }
        tok.nextToken();
        return new LeafNode.FeatureVectorLeafNode();
    }

    public void fillLeafs(Node root, FeatureVector[] featureVectors) {
        if (this.leafType == LeafNode.LeafType.FeatureVectorLeafNode) {
            Node currentNode = this.rootNode = root;
            Node prevNode = null;
            for (int i = 0; i < featureVectors.length; ++i) {
                currentNode = this.rootNode;
                prevNode = null;
                FeatureVector featureVector = featureVectors[i];
                while (!(currentNode instanceof LeafNode)) {
                    prevNode = currentNode;
                    currentNode = ((DecisionNode)currentNode).getNextNode(featureVector);
                }
                ((LeafNode.FeatureVectorLeafNode)currentNode).addFeatureVector(featureVector);
            }
        } else {
            throw new IllegalArgumentException("The leaves of this tree are not FeatureVectorLeafNode.");
        }
    }

    protected LeafNode createStringAndFloatLeafNode(String line) {
        float[] probs;
        int[] indices;
        StringTokenizer tok = new StringTokenizer(line, " ");
        int numTokens = tok.countTokens();
        int index = 0;
        if (numTokens == 2) {
            tok.nextToken();
            indices = new int[]{};
            probs = new float[]{};
        } else {
            indices = new int[(numTokens - 1) / 2];
            probs = new float[indices.length];
            while (index * 2 < numTokens - 1) {
                String token = tok.nextToken();
                token = index == 0 ? token.substring(4) : token.substring(1);
                indices[index] = Integer.parseInt(token);
                token = tok.nextToken();
                int lastIndex = token.length() - 1;
                if (index * 2 == numTokens - 3) {
                    if ((token = token.substring(0, lastIndex - 1)).equals("inf")) {
                        probs[index] = 10000.0f;
                        ++index;
                        continue;
                    }
                    if (token.equals("nan")) {
                        probs[index] = -1.0f;
                        ++index;
                        continue;
                    }
                } else {
                    if ((token = token.substring(0, lastIndex)).equals("inf")) {
                        probs[index] = 1000000.0f;
                        ++index;
                        continue;
                    }
                    if (token.equals("nan")) {
                        probs[index] = -1.0f;
                        ++index;
                        continue;
                    }
                }
                probs[index] = Float.parseFloat(token);
                ++index;
            }
        }
        return new LeafNode.StringAndFloatLeafNode(indices, probs);
    }
}

