/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.container;

import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.BoundedPriorityQueue;
import com.rapidminer.tools.math.container.GeometricDataCollection;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearList<T extends Serializable>
implements GeometricDataCollection<T>,
RandomAccess {
    private static final long serialVersionUID = -746048910140779285L;
    DistanceMeasure distance;
    ArrayList<double[]> samples = new ArrayList();
    ArrayList<T> storedValues = new ArrayList();

    public LinearList(DistanceMeasure distance) {
        this.distance = distance;
    }

    @Override
    public void add(double[] values, T storeValue) {
        this.samples.add(values);
        this.storedValues.add(storeValue);
    }

    @Override
    public Collection<T> getNearestValues(int k, double[] values) {
        BoundedPriorityQueue<Tupel<Double, Serializable>> queue = new BoundedPriorityQueue<Tupel<Double, Serializable>>(k);
        int i = 0;
        for (double[] sample : this.samples) {
            queue.add(new Tupel<Double, Serializable>(this.distance.calculateDistance(sample, values), (Serializable)this.storedValues.get(i)));
            ++i;
        }
        ArrayList<Serializable> result = new ArrayList<Serializable>(k);
        for (Tupel tupel : queue) {
            result.add((Serializable)tupel.getSecond());
        }
        return result;
    }

    @Override
    public Collection<Tupel<Double, T>> getNearestValueDistances(int k, double[] values) {
        BoundedPriorityQueue<Tupel<Double, Serializable>> queue = new BoundedPriorityQueue<Tupel<Double, Serializable>>(k);
        int i = 0;
        for (double[] sample : this.samples) {
            queue.add(new Tupel<Double, Serializable>(this.distance.calculateDistance(sample, values), (Serializable)this.storedValues.get(i)));
            ++i;
        }
        ArrayList<Tupel<Double, T>> result = new ArrayList<Tupel<Double, T>>(k);
        for (Tupel tupel : queue) {
            result.add(new Tupel<Double, Serializable>((Double)tupel.getFirst(), (Serializable)tupel.getSecond()));
        }
        return result;
    }

    @Override
    public Collection<Tupel<Double, T>> getNearestValueDistances(double withinDistance, double[] values) {
        ArrayList<Tupel<Double, T>> queue = new ArrayList<Tupel<Double, T>>();
        int i = 0;
        for (double[] sample : this.samples) {
            double currentDistance = this.distance.calculateDistance(sample, values);
            if (currentDistance <= withinDistance) {
                queue.add(new Tupel<Double, Serializable>(currentDistance, (Serializable)this.storedValues.get(i)));
            }
            ++i;
        }
        return queue;
    }

    @Override
    public Collection<Tupel<Double, T>> getNearestValueDistances(double withinDistance, int butAtLeastK, double[] values) {
        Collection<Tupel<Double, T>> result = this.getNearestValueDistances(withinDistance, values);
        if (result.size() < butAtLeastK) {
            return this.getNearestValueDistances(butAtLeastK, values);
        }
        return result;
    }

    @Override
    public int size() {
        return this.samples.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.storedValues.iterator();
    }

    @Override
    public T get(int index) {
        return (T)((Serializable)this.storedValues.get(index));
    }
}

