/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.Tools;
import com.rapidminer.operator.validation.ValidationChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.math.AverageVector;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlidingWindowValidation
extends ValidationChain {
    public static final String PARAMETER_TRAINING_WINDOW_WIDTH = "training_window_width";
    public static final String PARAMETER_TRAINING_WINDOW_STEP_SIZE = "training_window_step_size";
    public static final String PARAMETER_TEST_WINDOW_WIDTH = "test_window_width";
    public static final String PARAMETER_HORIZON = "horizon";
    public static final String PARAMETER_CUMULATIVE_TRAINING = "cumulative_training";
    public static final String PARAMETER_AVERAGE_PERFORMANCES_ONLY = "average_performances_only";

    public SlidingWindowValidation(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] estimatePerformance(ExampleSet inputSet) throws OperatorException {
        int[] partition;
        int horizon;
        int neededSize;
        int trainingWindowWidth = this.getParameterAsInt(PARAMETER_TRAINING_WINDOW_WIDTH);
        int testWindowWidth = this.getParameterAsInt(PARAMETER_TEST_WINDOW_WIDTH);
        int stepSize = this.getParameterAsInt(PARAMETER_TRAINING_WINDOW_STEP_SIZE);
        if (stepSize < 0) {
            stepSize = testWindowWidth;
        }
        if ((neededSize = trainingWindowWidth + (horizon = this.getParameterAsInt(PARAMETER_HORIZON) - 1) + testWindowWidth) > (partition = new int[inputSet.size()]).length) {
            String reason = "(" + trainingWindowWidth + "+" + horizon + "+" + testWindowWidth + "=" + neededSize + ")";
            throw new UserError((Operator)this, 110, reason);
        }
        ArrayList<AverageVector> averageVectors = new ArrayList<AverageVector>();
        int trainingStart = 0;
        while (trainingStart < partition.length) {
            if (trainingStart + trainingWindowWidth + horizon + testWindowWidth > partition.length) break;
            int actualTrainingStart = trainingStart;
            if (this.getParameterAsBoolean(PARAMETER_CUMULATIVE_TRAINING)) {
                actualTrainingStart = 0;
            }
            int i = 0;
            while (i < partition.length) {
                partition[i] = i >= actualTrainingStart && i < trainingStart + trainingWindowWidth ? 0 : (i >= trainingStart + trainingWindowWidth + horizon && i < trainingStart + trainingWindowWidth + horizon + testWindowWidth ? 1 : 2);
                ++i;
            }
            SplittedExampleSet splittedES = new SplittedExampleSet(inputSet, new Partition(partition, 3));
            splittedES.selectSingleSubset(0);
            this.learn(splittedES);
            splittedES.selectSingleSubset(1);
            IOContainer evalOutput = this.evaluate(splittedES);
            Tools.handleAverages(evalOutput, averageVectors, this.getParameterAsBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY));
            this.inApplyLoop();
            trainingStart += stepSize;
        }
        PerformanceVector averagePerformance = Tools.getPerformanceVector(averageVectors);
        if (averagePerformance != null) {
            this.setResult(averagePerformance);
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_TRAINING_WINDOW_WIDTH, "Number of examples in the window which is used for training", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_TRAINING_WINDOW_STEP_SIZE, "Number of examples the window is moved after each iteration (-1: same as test window width)", -1, Integer.MAX_VALUE, -1);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_TEST_WINDOW_WIDTH, "Number of examples which are used for testing (following after 'horizon' examples after the training window end)", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_HORIZON, "Increment from last training to first testing example (1 = next example).", 1, Integer.MAX_VALUE, 1);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_CUMULATIVE_TRAINING, "Indicates if each training window should be added to the old one or should replace the old one.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY, "Indicates if only performance vectors should be averaged or all types of averagable result vectors", true));
        return types;
    }
}

